/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.sensitivity;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.TypedString;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivitiesBuilder;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.sensitivity.CurveSensitivitiesBuilder;
import com.opengamma.strata.market.sensitivity.CurveSensitivitiesType;
import com.opengamma.strata.market.sensitivity.Sensitivities;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.PortfolioItemType;
import com.opengamma.strata.product.ProductType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CurveSensitivities
implements Sensitivities,
FxConvertible<CurveSensitivities>,
ImmutableBean,
Serializable {
    private static final CurveSensitivities EMPTY = new CurveSensitivities(PortfolioItemInfo.empty(), (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)ImmutableMap.of());
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PortfolioItemInfo info;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<CurveSensitivitiesType, CurrencyParameterSensitivities> typedSensitivities;
    private static final long serialVersionUID = 1L;

    public static CurveSensitivities empty() {
        return EMPTY;
    }

    public static CurveSensitivitiesBuilder builder(PortfolioItemInfo info) {
        return new CurveSensitivitiesBuilder(info);
    }

    public static CurveSensitivities of(PortfolioItemInfo info, CurveSensitivitiesType type, CurrencyParameterSensitivities sensitivities) {
        return new CurveSensitivities(info, (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)ImmutableMap.of((Object)((Object)type), (Object)sensitivities));
    }

    public static CurveSensitivities of(PortfolioItemInfo info, Map<CurveSensitivitiesType, CurrencyParameterSensitivities> typedSensitivities) {
        return new CurveSensitivities(info, (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)ImmutableMap.copyOf(typedSensitivities));
    }

    public static Collector<CurveSensitivities, ?, CurveSensitivities> toMergedSensitivities() {
        return Collector.of(() -> CurveSensitivities.builder(PortfolioItemInfo.empty()), CurveSensitivitiesBuilder::add, CurveSensitivitiesBuilder::combine, CurveSensitivitiesBuilder::build, new Collector.Characteristics[0]);
    }

    public CurrencyParameterSensitivities getTypedSensitivity(CurveSensitivitiesType type) {
        CurrencyParameterSensitivities sens = (CurrencyParameterSensitivities)this.typedSensitivities.get((Object)type);
        if (sens == null) {
            throw new IllegalArgumentException("Unable to find sensitivities: " + (Object)((Object)type));
        }
        return sens;
    }

    public Optional<CurrencyParameterSensitivities> findTypedSensitivity(CurveSensitivitiesType type) {
        return Optional.ofNullable(this.typedSensitivities.get((Object)type));
    }

    public CurveSensitivities mergedWith(Map<CurveSensitivitiesType, CurrencyParameterSensitivities> other) {
        ImmutableMap combinedSens = MapStream.concat((MapStream)MapStream.of(this.typedSensitivities), (MapStream)MapStream.of(other)).toMapGrouping(CurveSensitivities.mergeSensitivities());
        return new CurveSensitivities(this.info, (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)combinedSens);
    }

    private static Collector<CurrencyParameterSensitivities, CurrencyParameterSensitivitiesBuilder, CurrencyParameterSensitivities> mergeSensitivities() {
        return Collector.of(CurrencyParameterSensitivities::builder, CurrencyParameterSensitivitiesBuilder::add, (l, r) -> l.add(r.build()), CurrencyParameterSensitivitiesBuilder::build, new Collector.Characteristics[0]);
    }

    public CurveSensitivities mergedWith(CurveSensitivities other) {
        return new CurveSensitivities(this.info.combinedWith(other.info), (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)this.mergedWith((Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)other.typedSensitivities).getTypedSensitivities());
    }

    public CurveSensitivities withMarketDataNames(Function<MarketDataName<?>, MarketDataName<?>> nameFn) {
        return new CurveSensitivities(this.info, (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)MapStream.of(this.typedSensitivities).mapValues(sens -> sens.withMarketDataNames(nameFn)).toMap());
    }

    public CurveSensitivities withParameterMetadatas(UnaryOperator<ParameterMetadata> mdFn) {
        return new CurveSensitivities(this.info, (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)MapStream.of(this.typedSensitivities).mapValues(sens -> sens.withParameterMetadatas(mdFn)).toMap());
    }

    public CurveSensitivities convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return new CurveSensitivities(this.info, (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)MapStream.of(this.typedSensitivities).mapValues(v -> v.convertedTo(resultCurrency, rateProvider)).toMap());
    }

    public PortfolioItemSummary summarize() {
        String typesStr = this.typedSensitivities.keySet().stream().map(TypedString::toString).sorted().collect(Collectors.joining(", ", "CurveSensitivities[", "]"));
        return PortfolioItemSummary.of((StandardId)this.getId().orElse(null), (PortfolioItemType)PortfolioItemType.SENSITIVITIES, (ProductType)ProductType.SENSITIVITIES, (Set)((Set)this.typedSensitivities.values().stream().flatMap(s -> s.getSensitivities().stream()).map(s -> s.getCurrency()).collect(Guavate.toImmutableSet())), (String)typesStr);
    }

    @Override
    public CurveSensitivities withInfo(PortfolioItemInfo info) {
        return new CurveSensitivities(info, (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)this.typedSensitivities);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CurveSensitivities(PortfolioItemInfo info, Map<CurveSensitivitiesType, CurrencyParameterSensitivities> typedSensitivities) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull(typedSensitivities, (String)"typedSensitivities");
        this.info = info;
        this.typedSensitivities = ImmutableMap.copyOf(typedSensitivities);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PortfolioItemInfo getInfo() {
        return this.info;
    }

    public ImmutableMap<CurveSensitivitiesType, CurrencyParameterSensitivities> getTypedSensitivities() {
        return this.typedSensitivities;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurveSensitivities other = (CurveSensitivities)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal(this.typedSensitivities, other.typedSensitivities);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.typedSensitivities);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CurveSensitivities{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("typedSensitivities").append('=').append(JodaBeanUtils.toString(this.typedSensitivities));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CurveSensitivities> {
        private PortfolioItemInfo info;
        private Map<CurveSensitivitiesType, CurrencyParameterSensitivities> typedSensitivities = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 153032499: {
                    return this.typedSensitivities;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (PortfolioItemInfo)newValue;
                    break;
                }
                case 153032499: {
                    this.typedSensitivities = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CurveSensitivities build() {
            return new CurveSensitivities(this.info, this.typedSensitivities);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("CurveSensitivities.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("typedSensitivities").append('=').append(JodaBeanUtils.toString(this.typedSensitivities));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PortfolioItemInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", CurveSensitivities.class, PortfolioItemInfo.class);
        private final MetaProperty<ImmutableMap<CurveSensitivitiesType, CurrencyParameterSensitivities>> typedSensitivities = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"typedSensitivities", CurveSensitivities.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "typedSensitivities"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 153032499: {
                    return this.typedSensitivities;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CurveSensitivities> builder() {
            return new Builder();
        }

        public Class<? extends CurveSensitivities> beanType() {
            return CurveSensitivities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PortfolioItemInfo> info() {
            return this.info;
        }

        public MetaProperty<ImmutableMap<CurveSensitivitiesType, CurrencyParameterSensitivities>> typedSensitivities() {
            return this.typedSensitivities;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((CurveSensitivities)bean).getInfo();
                }
                case 153032499: {
                    return ((CurveSensitivities)bean).getTypedSensitivities();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

