/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class YearMonthDateParameterMetadata
implements DatedParameterMetadata,
ImmutableBean,
Serializable {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("MMMuu", Locale.ENGLISH);
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate date;
    @PropertyDefinition(validate="notNull")
    private final YearMonth yearMonth;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    private static final long serialVersionUID = 1L;

    public static YearMonthDateParameterMetadata of(LocalDate date, YearMonth yearMonth) {
        ArgChecker.notNull((Object)date, (String)"date");
        ArgChecker.notNull((Object)yearMonth, (String)"yearMonth");
        return new YearMonthDateParameterMetadata(date, yearMonth, yearMonth.format(FORMATTER));
    }

    public static YearMonthDateParameterMetadata of(LocalDate date, YearMonth yearMonth, String label) {
        return new YearMonthDateParameterMetadata(date, yearMonth, label);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.label == null && builder.yearMonth != null) {
            builder.label = builder.yearMonth.format(YearMonthDateParameterMetadata.FORMATTER);
        }
    }

    @Override
    public YearMonth getIdentifier() {
        return this.yearMonth;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private YearMonthDateParameterMetadata(LocalDate date, YearMonth yearMonth, String label) {
        JodaBeanUtils.notNull((Object)date, (String)"date");
        JodaBeanUtils.notNull((Object)yearMonth, (String)"yearMonth");
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        this.date = date;
        this.yearMonth = yearMonth;
        this.label = label;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public LocalDate getDate() {
        return this.date;
    }

    public YearMonth getYearMonth() {
        return this.yearMonth;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            YearMonthDateParameterMetadata other = (YearMonthDateParameterMetadata)obj;
            return JodaBeanUtils.equal((Object)this.date, (Object)other.date) && JodaBeanUtils.equal((Object)this.yearMonth, (Object)other.yearMonth) && JodaBeanUtils.equal((Object)this.label, (Object)other.label);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.yearMonth);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("YearMonthDateParameterMetadata{");
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
        buf.append("yearMonth").append('=').append(JodaBeanUtils.toString((Object)this.yearMonth)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<YearMonthDateParameterMetadata> {
        private LocalDate date;
        private YearMonth yearMonth;
        private String label;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3076014: {
                    return this.date;
                }
                case -496678845: {
                    return this.yearMonth;
                }
                case 102727412: {
                    return this.label;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3076014: {
                    this.date = (LocalDate)newValue;
                    break;
                }
                case -496678845: {
                    this.yearMonth = (YearMonth)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public YearMonthDateParameterMetadata build() {
            YearMonthDateParameterMetadata.preBuild(this);
            return new YearMonthDateParameterMetadata(this.date, this.yearMonth, this.label);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("YearMonthDateParameterMetadata.Builder{");
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
            buf.append("yearMonth").append('=').append(JodaBeanUtils.toString((Object)this.yearMonth)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", YearMonthDateParameterMetadata.class, LocalDate.class);
        private final MetaProperty<YearMonth> yearMonth = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearMonth", YearMonthDateParameterMetadata.class, YearMonth.class);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", YearMonthDateParameterMetadata.class, String.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"date", "yearMonth", "label"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3076014: {
                    return this.date;
                }
                case -496678845: {
                    return this.yearMonth;
                }
                case 102727412: {
                    return this.label;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends YearMonthDateParameterMetadata> builder() {
            return new Builder();
        }

        public Class<? extends YearMonthDateParameterMetadata> beanType() {
            return YearMonthDateParameterMetadata.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> date() {
            return this.date;
        }

        public MetaProperty<YearMonth> yearMonth() {
            return this.yearMonth;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3076014: {
                    return ((YearMonthDateParameterMetadata)bean).getDate();
                }
                case -496678845: {
                    return ((YearMonthDateParameterMetadata)bean).getYearMonth();
                }
                case 102727412: {
                    return ((YearMonthDateParameterMetadata)bean).getLabel();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

