/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterSize;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class UnitParameterSensitivity
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final MarketDataName<?> marketDataName;
    @PropertyDefinition(validate="notNull", builderType="List<? extends ParameterMetadata>")
    private final ImmutableList<ParameterMetadata> parameterMetadata;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray sensitivity;
    @PropertyDefinition(get="optional", type="List<>")
    private final ImmutableList<ParameterSize> parameterSplit;
    private static final long serialVersionUID = 1L;

    public static UnitParameterSensitivity of(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, DoubleArray sensitivity) {
        return new UnitParameterSensitivity(marketDataName, parameterMetadata, sensitivity, null);
    }

    public static UnitParameterSensitivity of(MarketDataName<?> marketDataName, DoubleArray sensitivity) {
        return UnitParameterSensitivity.of(marketDataName, ParameterMetadata.listOfEmpty(sensitivity.size()), sensitivity);
    }

    public static UnitParameterSensitivity of(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, DoubleArray sensitivity, List<ParameterSize> parameterSplit) {
        return new UnitParameterSensitivity(marketDataName, parameterMetadata, sensitivity, parameterSplit);
    }

    public static UnitParameterSensitivity combine(MarketDataName<?> marketDataName, UnitParameterSensitivity ... sensitivities) {
        ArgChecker.notEmpty((Object[])sensitivities, (String)"sensitivities");
        if (sensitivities.length < 2) {
            throw new IllegalArgumentException("At least two sensitivity instances must be specified");
        }
        int size = Stream.of(sensitivities).mapToInt(s -> s.getParameterCount()).sum();
        double[] combinedSensitivities = new double[size];
        ImmutableList.Builder combinedMeta = ImmutableList.builder();
        ImmutableList.Builder split = ImmutableList.builder();
        int count = 0;
        for (int i = 0; i < sensitivities.length; ++i) {
            UnitParameterSensitivity sens = sensitivities[i];
            System.arraycopy(sens.getSensitivity().toArrayUnsafe(), 0, combinedSensitivities, count, sens.getParameterCount());
            combinedMeta.addAll(sens.getParameterMetadata());
            split.add((Object)ParameterSize.of(sens.getMarketDataName(), sens.getParameterCount()));
            count += sens.getParameterCount();
        }
        return new UnitParameterSensitivity(marketDataName, (List<? extends ParameterMetadata>)combinedMeta.build(), DoubleArray.ofUnsafe((double[])combinedSensitivities), (List<ParameterSize>)split.build());
    }

    @ImmutableValidator
    private void validate() {
        if (this.sensitivity.size() != this.parameterMetadata.size()) {
            throw new IllegalArgumentException("Length of sensitivity and parameter metadata must match");
        }
        if (this.parameterSplit != null) {
            long total = this.parameterSplit.stream().mapToInt(p -> p.getParameterCount()).sum();
            if ((long)this.sensitivity.size() != total) {
                throw new IllegalArgumentException("Length of sensitivity and parameter split must match");
            }
            if (this.parameterSplit.stream().map(p -> p.getName()).distinct().count() != (long)this.parameterSplit.size()) {
                throw new IllegalArgumentException("Parameter split must not contain duplicate market data names");
            }
        }
    }

    public int getParameterCount() {
        return this.sensitivity.size();
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return (ParameterMetadata)this.parameterMetadata.get(parameterIndex);
    }

    public int compareKey(UnitParameterSensitivity other) {
        return ComparisonChain.start().compare(this.marketDataName, other.marketDataName).result();
    }

    public CurrencyParameterSensitivity multipliedBy(Currency currency, double amount) {
        return CurrencyParameterSensitivity.of(this.marketDataName, this.parameterMetadata, currency, this.sensitivity.multipliedBy(amount), this.parameterSplit);
    }

    public UnitParameterSensitivity multipliedBy(double factor) {
        return this.mapSensitivity(s -> s * factor);
    }

    public UnitParameterSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new UnitParameterSensitivity(this.marketDataName, (List<? extends ParameterMetadata>)this.parameterMetadata, this.sensitivity.map(operator), (List<ParameterSize>)this.parameterSplit);
    }

    public UnitParameterSensitivity withSensitivity(DoubleArray sensitivity) {
        return new UnitParameterSensitivity(this.marketDataName, (List<? extends ParameterMetadata>)this.parameterMetadata, sensitivity, (List<ParameterSize>)this.parameterSplit);
    }

    public UnitParameterSensitivity plus(DoubleArray otherSensitivty) {
        if (otherSensitivty.size() != this.sensitivity.size()) {
            throw new IllegalArgumentException(Messages.format((String)"Sensitivity array size {} must match size {}", (Object[])new Object[]{otherSensitivty.size(), this.sensitivity.size()}));
        }
        return this.withSensitivity(this.sensitivity.plus(otherSensitivty));
    }

    public UnitParameterSensitivity plus(UnitParameterSensitivity otherSensitivty) {
        if (!this.marketDataName.equals(otherSensitivty.marketDataName) || !this.parameterMetadata.equals(otherSensitivty.parameterMetadata) || this.parameterSplit != null && !this.parameterSplit.equals(otherSensitivty.parameterSplit)) {
            throw new IllegalArgumentException("Two sensitivity instances can only be added if name, metadata and split are equal");
        }
        return this.plus(otherSensitivty.getSensitivity());
    }

    public ImmutableList<UnitParameterSensitivity> split() {
        if (this.parameterSplit == null) {
            return ImmutableList.of((Object)this);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int count = 0;
        for (ParameterSize size : this.parameterSplit) {
            ImmutableList splitMetadata = this.parameterMetadata.subList(count, count + size.getParameterCount());
            DoubleArray splitSensitivity = this.sensitivity.subArray(count, count + size.getParameterCount());
            builder.add((Object)UnitParameterSensitivity.of(size.getName(), (List<? extends ParameterMetadata>)splitMetadata, splitSensitivity));
            count += size.getParameterCount();
        }
        return builder.build();
    }

    public double total() {
        return this.sensitivity.sum();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private UnitParameterSensitivity(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, DoubleArray sensitivity, List<ParameterSize> parameterSplit) {
        JodaBeanUtils.notNull(marketDataName, (String)"marketDataName");
        JodaBeanUtils.notNull(parameterMetadata, (String)"parameterMetadata");
        JodaBeanUtils.notNull((Object)sensitivity, (String)"sensitivity");
        this.marketDataName = marketDataName;
        this.parameterMetadata = ImmutableList.copyOf(parameterMetadata);
        this.sensitivity = sensitivity;
        this.parameterSplit = parameterSplit != null ? ImmutableList.copyOf(parameterSplit) : null;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public MarketDataName<?> getMarketDataName() {
        return this.marketDataName;
    }

    public ImmutableList<ParameterMetadata> getParameterMetadata() {
        return this.parameterMetadata;
    }

    public DoubleArray getSensitivity() {
        return this.sensitivity;
    }

    public Optional<List<ParameterSize>> getParameterSplit() {
        return Optional.ofNullable(this.parameterSplit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            UnitParameterSensitivity other = (UnitParameterSensitivity)obj;
            return JodaBeanUtils.equal(this.marketDataName, other.marketDataName) && JodaBeanUtils.equal(this.parameterMetadata, other.parameterMetadata) && JodaBeanUtils.equal((Object)this.sensitivity, (Object)other.sensitivity) && JodaBeanUtils.equal(this.parameterSplit, other.parameterSplit);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.marketDataName);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterMetadata);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sensitivity);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterSplit);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("UnitParameterSensitivity{");
        buf.append("marketDataName").append('=').append(JodaBeanUtils.toString(this.marketDataName)).append(',').append(' ');
        buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity)).append(',').append(' ');
        buf.append("parameterSplit").append('=').append(JodaBeanUtils.toString(this.parameterSplit));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<UnitParameterSensitivity> {
        private MarketDataName<?> marketDataName;
        private List<? extends ParameterMetadata> parameterMetadata = ImmutableList.of();
        private DoubleArray sensitivity;
        private List<ParameterSize> parameterSplit;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    return this.marketDataName;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
                case 564403871: {
                    return this.sensitivity;
                }
                case 1122130161: {
                    return this.parameterSplit;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    this.marketDataName = (MarketDataName)newValue;
                    break;
                }
                case -1169106440: {
                    this.parameterMetadata = (List)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (DoubleArray)newValue;
                    break;
                }
                case 1122130161: {
                    this.parameterSplit = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public UnitParameterSensitivity build() {
            return new UnitParameterSensitivity(this.marketDataName, this.parameterMetadata, this.sensitivity, this.parameterSplit);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("UnitParameterSensitivity.Builder{");
            buf.append("marketDataName").append('=').append(JodaBeanUtils.toString(this.marketDataName)).append(',').append(' ');
            buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity)).append(',').append(' ');
            buf.append("parameterSplit").append('=').append(JodaBeanUtils.toString(this.parameterSplit));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<MarketDataName<?>> marketDataName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"marketDataName", UnitParameterSensitivity.class, MarketDataName.class);
        private final MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterMetadata", UnitParameterSensitivity.class, ImmutableList.class);
        private final MetaProperty<DoubleArray> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", UnitParameterSensitivity.class, DoubleArray.class);
        private final MetaProperty<List<ParameterSize>> parameterSplit = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterSplit", UnitParameterSensitivity.class, List.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"marketDataName", "parameterMetadata", "sensitivity", "parameterSplit"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    return this.marketDataName;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
                case 564403871: {
                    return this.sensitivity;
                }
                case 1122130161: {
                    return this.parameterSplit;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends UnitParameterSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends UnitParameterSensitivity> beanType() {
            return UnitParameterSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<MarketDataName<?>> marketDataName() {
            return this.marketDataName;
        }

        public MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata() {
            return this.parameterMetadata;
        }

        public MetaProperty<DoubleArray> sensitivity() {
            return this.sensitivity;
        }

        public MetaProperty<List<ParameterSize>> parameterSplit() {
            return this.parameterSplit;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    return ((UnitParameterSensitivity)bean).getMarketDataName();
                }
                case -1169106440: {
                    return ((UnitParameterSensitivity)bean).getParameterMetadata();
                }
                case 564403871: {
                    return ((UnitParameterSensitivity)bean).getSensitivity();
                }
                case 1122130161: {
                    return ((UnitParameterSensitivity)bean).parameterSplit;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

