/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class UnitParameterSensitivities
implements ImmutableBean,
Serializable {
    private static final UnitParameterSensitivities EMPTY = new UnitParameterSensitivities((ImmutableList<UnitParameterSensitivity>)ImmutableList.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<UnitParameterSensitivity> sensitivities;
    private static final long serialVersionUID = 1L;

    public static UnitParameterSensitivities empty() {
        return EMPTY;
    }

    public static UnitParameterSensitivities of(UnitParameterSensitivity sensitivity) {
        return new UnitParameterSensitivities((ImmutableList<UnitParameterSensitivity>)ImmutableList.of((Object)sensitivity));
    }

    public static UnitParameterSensitivities of(UnitParameterSensitivity ... sensitivities) {
        return UnitParameterSensitivities.of(Arrays.asList(sensitivities));
    }

    public static UnitParameterSensitivities of(List<? extends UnitParameterSensitivity> sensitivities) {
        ArrayList<UnitParameterSensitivity> mutable = new ArrayList<UnitParameterSensitivity>();
        for (UnitParameterSensitivity unitParameterSensitivity : sensitivities) {
            UnitParameterSensitivities.insert(mutable, unitParameterSensitivity);
        }
        return new UnitParameterSensitivities((ImmutableList<UnitParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    @ImmutableConstructor
    private UnitParameterSensitivities(List<? extends UnitParameterSensitivity> sensitivities) {
        if (sensitivities.size() < 2) {
            this.sensitivities = ImmutableList.copyOf(sensitivities);
        } else {
            ArrayList<? extends UnitParameterSensitivity> mutable = new ArrayList<UnitParameterSensitivity>(sensitivities);
            mutable.sort(UnitParameterSensitivity::compareKey);
            this.sensitivities = ImmutableList.copyOf(mutable);
        }
    }

    private UnitParameterSensitivities(ImmutableList<UnitParameterSensitivity> sensitivities) {
        this.sensitivities = sensitivities;
    }

    public int size() {
        return this.sensitivities.size();
    }

    public UnitParameterSensitivity getSensitivity(MarketDataName<?> name) {
        return this.findSensitivity(name).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"Unable to find sensitivity: {}", (Object)name)));
    }

    public Optional<UnitParameterSensitivity> findSensitivity(MarketDataName<?> name) {
        return this.sensitivities.stream().filter(sens -> sens.getMarketDataName().equals((Object)name)).findFirst();
    }

    public UnitParameterSensitivities combinedWith(UnitParameterSensitivity other) {
        ArrayList<UnitParameterSensitivity> mutable = new ArrayList<UnitParameterSensitivity>((Collection<UnitParameterSensitivity>)this.sensitivities);
        UnitParameterSensitivities.insert(mutable, other);
        return new UnitParameterSensitivities((ImmutableList<UnitParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    public UnitParameterSensitivities combinedWith(UnitParameterSensitivities other) {
        ArrayList<UnitParameterSensitivity> mutable = new ArrayList<UnitParameterSensitivity>((Collection<UnitParameterSensitivity>)this.sensitivities);
        for (UnitParameterSensitivity otherSens : other.sensitivities) {
            UnitParameterSensitivities.insert(mutable, otherSens);
        }
        return new UnitParameterSensitivities((ImmutableList<UnitParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    private static void insert(List<UnitParameterSensitivity> mutable, UnitParameterSensitivity addition) {
        int index = Collections.binarySearch(mutable, addition, UnitParameterSensitivity::compareKey);
        if (index >= 0) {
            UnitParameterSensitivity base = mutable.get(index);
            DoubleArray combined = base.getSensitivity().plus(addition.getSensitivity());
            mutable.set(index, base.withSensitivity(combined));
        } else {
            int insertionPoint = -(index + 1);
            mutable.add(insertionPoint, addition);
        }
    }

    public CurrencyParameterSensitivities multipliedBy(Currency currency, double amount) {
        return this.sensitivities.stream().map(s -> s.multipliedBy(currency, amount)).collect(Collectors.collectingAndThen(Guavate.toImmutableList(), CurrencyParameterSensitivities::of));
    }

    public UnitParameterSensitivities multipliedBy(double factor) {
        return this.mapSensitivities(s -> s * factor);
    }

    public UnitParameterSensitivities mapSensitivities(DoubleUnaryOperator operator) {
        return this.sensitivities.stream().map(s -> s.mapSensitivity(operator)).collect(Collectors.collectingAndThen(Guavate.toImmutableList(), UnitParameterSensitivities::new));
    }

    public UnitParameterSensitivities split() {
        if (!this.sensitivities.stream().anyMatch(s -> s.getParameterSplit().isPresent())) {
            return this;
        }
        return UnitParameterSensitivities.of((List)this.sensitivities.stream().flatMap(s -> s.split().stream()).collect(Guavate.toImmutableList()));
    }

    public boolean equalWithTolerance(UnitParameterSensitivities other, double tolerance) {
        ArrayList<UnitParameterSensitivity> mutable = new ArrayList<UnitParameterSensitivity>((Collection<UnitParameterSensitivity>)other.sensitivities);
        for (UnitParameterSensitivity sens1 : this.sensitivities) {
            int index = Collections.binarySearch(mutable, sens1, UnitParameterSensitivity::compareKey);
            if (index >= 0) {
                UnitParameterSensitivity sens2 = (UnitParameterSensitivity)mutable.get(index);
                if (!sens1.getSensitivity().equalWithTolerance(sens2.getSensitivity(), tolerance)) {
                    return false;
                }
                mutable.remove(index);
                continue;
            }
            if (sens1.getSensitivity().equalZeroWithTolerance(tolerance)) continue;
            return false;
        }
        for (UnitParameterSensitivity sens2 : mutable) {
            if (sens2.getSensitivity().equalZeroWithTolerance(tolerance)) continue;
            return false;
        }
        return true;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<UnitParameterSensitivity> getSensitivities() {
        return this.sensitivities;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            UnitParameterSensitivities other = (UnitParameterSensitivities)obj;
            return JodaBeanUtils.equal(this.sensitivities, other.sensitivities);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.sensitivities);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("UnitParameterSensitivities{");
        buf.append("sensitivities").append('=').append(JodaBeanUtils.toString(this.sensitivities));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<UnitParameterSensitivities> {
        private List<UnitParameterSensitivity> sensitivities = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return this.sensitivities;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    this.sensitivities = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public UnitParameterSensitivities build() {
            return new UnitParameterSensitivities(this.sensitivities);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("UnitParameterSensitivities.Builder{");
            buf.append("sensitivities").append('=').append(JodaBeanUtils.toString(this.sensitivities));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<UnitParameterSensitivity>> sensitivities = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivities", UnitParameterSensitivities.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"sensitivities"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return this.sensitivities;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends UnitParameterSensitivities> builder() {
            return new Builder();
        }

        public Class<? extends UnitParameterSensitivities> beanType() {
            return UnitParameterSensitivities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<UnitParameterSensitivity>> sensitivities() {
            return this.sensitivities;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return ((UnitParameterSensitivities)bean).getSensitivities();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

