/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import com.opengamma.strata.market.param.TenoredParameterMetadata;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class TenorDateParameterMetadata
implements DatedParameterMetadata,
TenoredParameterMetadata,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate date;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Tenor tenor;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    private static final long serialVersionUID = 1L;

    public static TenorDateParameterMetadata of(LocalDate date, Tenor tenor) {
        ArgChecker.notNull((Object)date, (String)"date");
        ArgChecker.notNull((Object)tenor, (String)"tenor");
        return new TenorDateParameterMetadata(date, tenor, tenor.toString());
    }

    public static TenorDateParameterMetadata of(LocalDate date, Tenor tenor, String label) {
        return new TenorDateParameterMetadata(date, tenor, label);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.label == null && builder.tenor != null) {
            builder.label = builder.tenor.toString();
        }
    }

    public Tenor getIdentifier() {
        return this.tenor;
    }

    @Override
    public TenorDateParameterMetadata withTenor(Tenor tenor) {
        if (this.tenor.equals((Object)tenor)) {
            return this;
        }
        if (this.label.equals(this.tenor.toString())) {
            return TenorDateParameterMetadata.of(this.date, tenor);
        }
        return TenorDateParameterMetadata.of(this.date, tenor, this.label);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private TenorDateParameterMetadata(LocalDate date, Tenor tenor, String label) {
        JodaBeanUtils.notNull((Object)date, (String)"date");
        JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        this.date = date;
        this.tenor = tenor;
        this.label = label;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public LocalDate getDate() {
        return this.date;
    }

    @Override
    public Tenor getTenor() {
        return this.tenor;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TenorDateParameterMetadata other = (TenorDateParameterMetadata)obj;
            return JodaBeanUtils.equal((Object)this.date, (Object)other.date) && JodaBeanUtils.equal((Object)this.tenor, (Object)other.tenor) && JodaBeanUtils.equal((Object)this.label, (Object)other.label);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("TenorDateParameterMetadata{");
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
        buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<TenorDateParameterMetadata> {
        private LocalDate date;
        private Tenor tenor;
        private String label;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3076014: {
                    return this.date;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 102727412: {
                    return this.label;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3076014: {
                    this.date = (LocalDate)newValue;
                    break;
                }
                case 110246592: {
                    this.tenor = (Tenor)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public TenorDateParameterMetadata build() {
            TenorDateParameterMetadata.preBuild(this);
            return new TenorDateParameterMetadata(this.date, this.tenor, this.label);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("TenorDateParameterMetadata.Builder{");
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
            buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", TenorDateParameterMetadata.class, LocalDate.class);
        private final MetaProperty<Tenor> tenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tenor", TenorDateParameterMetadata.class, Tenor.class);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", TenorDateParameterMetadata.class, String.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"date", "tenor", "label"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3076014: {
                    return this.date;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 102727412: {
                    return this.label;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends TenorDateParameterMetadata> builder() {
            return new Builder();
        }

        public Class<? extends TenorDateParameterMetadata> beanType() {
            return TenorDateParameterMetadata.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> date() {
            return this.date;
        }

        public MetaProperty<Tenor> tenor() {
            return this.tenor;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3076014: {
                    return ((TenorDateParameterMetadata)bean).getDate();
                }
                case 110246592: {
                    return ((TenorDateParameterMetadata)bean).getTenor();
                }
                case 102727412: {
                    return ((TenorDateParameterMetadata)bean).getLabel();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

