/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.ShiftType;
import com.opengamma.strata.market.param.PointShifts;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class PointShiftsBuilder {
    private final ShiftType shiftType;
    private final Map<Pair<Integer, Object>, Double> shifts = new LinkedHashMap<Pair<Integer, Object>, Double>();

    PointShiftsBuilder(ShiftType shiftType) {
        this.shiftType = (ShiftType)((Object)ArgChecker.notNull((Object)((Object)shiftType), (String)"shiftType"));
    }

    public PointShiftsBuilder addShift(int scenarioIndex, Object nodeIdentifier, double shiftAmount) {
        ArgChecker.notNull((Object)nodeIdentifier, (String)"nodeIdentifier");
        ArgChecker.notNegative((int)scenarioIndex, (String)"scenarioIndex");
        this.shifts.put((Pair<Integer, Object>)Pair.of((Object)scenarioIndex, (Object)nodeIdentifier), shiftAmount);
        return this;
    }

    public PointShiftsBuilder addShifts(int scenarioIndex, Map<?, Double> shiftMap) {
        ArgChecker.notNull(shiftMap, (String)"shiftMap");
        ArgChecker.notNegative((int)scenarioIndex, (String)"scenarioIndex");
        MapStream.of(shiftMap).forEach((id, shift) -> this.shifts.put((Pair<Integer, Object>)Pair.of((Object)scenarioIndex, (Object)id), (Double)shift));
        return this;
    }

    public PointShifts build() {
        int scenarioCount = this.shifts.keySet().stream().mapToInt(Pair::getFirst).max().orElse(-1) + 1;
        List nodeIdentifiers = (List)this.shifts.keySet().stream().map(Pair::getSecond).distinct().collect(Guavate.toImmutableList());
        DoubleMatrix shiftMatrix = DoubleMatrix.of((int)scenarioCount, (int)nodeIdentifiers.size(), (r, c) -> this.shiftValue(r, nodeIdentifiers.get(c)));
        return new PointShifts(this.shiftType, shiftMatrix, nodeIdentifiers);
    }

    private double shiftValue(int scenarioIndex, Object nodeIdentifier) {
        Double shift = this.shifts.get(Pair.of((Object)scenarioIndex, (Object)nodeIdentifier));
        return shift != null ? shift : 0.0;
    }
}

