/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.tuple.ObjIntPair;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioPerturbation;
import com.opengamma.strata.market.ShiftType;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.param.PointShiftsBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class PointShifts
implements ScenarioPerturbation<ParameterizedData>,
ImmutableBean,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(PointShifts.class);
    @PropertyDefinition(validate="notNull")
    private final ShiftType shiftType;
    @PropertyDefinition(validate="notNull")
    private final DoubleMatrix shifts;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Object, Integer> nodeIndices;
    private static final long serialVersionUID = 1L;

    public static PointShiftsBuilder builder(ShiftType shiftType) {
        return new PointShiftsBuilder(shiftType);
    }

    PointShifts(ShiftType shiftType, DoubleMatrix shifts, List<Object> nodeIdentifiers) {
        this(shiftType, shifts, PointShifts.buildNodeMap(nodeIdentifiers));
    }

    private static Map<Object, Integer> buildNodeMap(List<Object> nodeIdentifiers) {
        return (Map)Guavate.zipWithIndex(nodeIdentifiers.stream()).collect(Guavate.toImmutableMap(ObjIntPair::getFirst, ObjIntPair::getSecond));
    }

    public MarketDataBox<ParameterizedData> applyTo(MarketDataBox<ParameterizedData> marketData, ReferenceData refData) {
        log.debug("Applying {} point shift to ParameterizedData '{}'", (Object)this.shiftType, (Object)((ParameterizedData)marketData.getValue(0)).toString());
        return marketData.mapWithIndex(this.shifts.rowCount(), (prams, scenarioIndex) -> this.applyShifts(scenarioIndex, (ParameterizedData)prams));
    }

    private ParameterizedData applyShifts(int scenarioIndex, ParameterizedData prams) {
        return prams.withPerturbation((index, value, meta) -> {
            double shiftAmount = this.shiftForNode(scenarioIndex, meta);
            return this.shiftType.applyShift(value, shiftAmount);
        });
    }

    public int getScenarioCount() {
        return this.shifts.rowCount();
    }

    private double shiftForNode(int scenarioIndex, ParameterMetadata meta) {
        Integer nodeIndex = (Integer)this.nodeIndices.get(meta.getIdentifier());
        if (nodeIndex != null) {
            return this.shifts.get(scenarioIndex, nodeIndex.intValue());
        }
        nodeIndex = (Integer)this.nodeIndices.get((Object)meta.getLabel());
        if (nodeIndex != null) {
            return this.shifts.get(scenarioIndex, nodeIndex.intValue());
        }
        return 0.0;
    }

    public Class<ParameterizedData> getMarketDataType() {
        return ParameterizedData.class;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    PointShifts(ShiftType shiftType, DoubleMatrix shifts, Map<Object, Integer> nodeIndices) {
        JodaBeanUtils.notNull((Object)((Object)shiftType), (String)"shiftType");
        JodaBeanUtils.notNull((Object)shifts, (String)"shifts");
        JodaBeanUtils.notNull(nodeIndices, (String)"nodeIndices");
        this.shiftType = shiftType;
        this.shifts = shifts;
        this.nodeIndices = ImmutableMap.copyOf(nodeIndices);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ShiftType getShiftType() {
        return this.shiftType;
    }

    public DoubleMatrix getShifts() {
        return this.shifts;
    }

    public ImmutableMap<Object, Integer> getNodeIndices() {
        return this.nodeIndices;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PointShifts other = (PointShifts)obj;
            return JodaBeanUtils.equal((Object)((Object)this.shiftType), (Object)((Object)other.shiftType)) && JodaBeanUtils.equal((Object)this.shifts, (Object)other.shifts) && JodaBeanUtils.equal(this.nodeIndices, other.nodeIndices);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.shiftType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shifts);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.nodeIndices);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("PointShifts{");
        buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
        buf.append("shifts").append('=').append(JodaBeanUtils.toString((Object)this.shifts)).append(',').append(' ');
        buf.append("nodeIndices").append('=').append(JodaBeanUtils.toString(this.nodeIndices));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<PointShifts> {
        private ShiftType shiftType;
        private DoubleMatrix shifts;
        private Map<Object, Integer> nodeIndices = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return this.shiftType;
                }
                case -903338959: {
                    return this.shifts;
                }
                case -1547874491: {
                    return this.nodeIndices;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    this.shiftType = (ShiftType)((Object)newValue);
                    break;
                }
                case -903338959: {
                    this.shifts = (DoubleMatrix)newValue;
                    break;
                }
                case -1547874491: {
                    this.nodeIndices = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public PointShifts build() {
            return new PointShifts(this.shiftType, this.shifts, this.nodeIndices);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("PointShifts.Builder{");
            buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
            buf.append("shifts").append('=').append(JodaBeanUtils.toString((Object)this.shifts)).append(',').append(' ');
            buf.append("nodeIndices").append('=').append(JodaBeanUtils.toString(this.nodeIndices));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ShiftType> shiftType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftType", PointShifts.class, ShiftType.class);
        private final MetaProperty<DoubleMatrix> shifts = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shifts", PointShifts.class, DoubleMatrix.class);
        private final MetaProperty<ImmutableMap<Object, Integer>> nodeIndices = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nodeIndices", PointShifts.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"shiftType", "shifts", "nodeIndices"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return this.shiftType;
                }
                case -903338959: {
                    return this.shifts;
                }
                case -1547874491: {
                    return this.nodeIndices;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends PointShifts> builder() {
            return new Builder();
        }

        public Class<? extends PointShifts> beanType() {
            return PointShifts.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ShiftType> shiftType() {
            return this.shiftType;
        }

        public MetaProperty<DoubleMatrix> shifts() {
            return this.shifts;
        }

        public MetaProperty<ImmutableMap<Object, Integer>> nodeIndices() {
            return this.nodeIndices;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return ((PointShifts)bean).getShiftType();
                }
                case -903338959: {
                    return ((PointShifts)bean).getShifts();
                }
                case -1547874491: {
                    return ((PointShifts)bean).getNodeIndices();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

