/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import java.util.List;

public final class ParameterizedDataCombiner {
    private final ParameterizedData[] underlyings;
    private final int[] lookup;
    private final int paramCount;

    public static ParameterizedDataCombiner of(ParameterizedData ... instances) {
        return new ParameterizedDataCombiner(instances);
    }

    public static ParameterizedDataCombiner of(List<? extends ParameterizedData> instances) {
        return new ParameterizedDataCombiner(instances.toArray(new ParameterizedData[0]));
    }

    private ParameterizedDataCombiner(ParameterizedData[] underlyings) {
        ArgChecker.notEmpty((Object[])underlyings, (String)"underlyings");
        int size = underlyings.length;
        this.underlyings = underlyings;
        int[] lookup = new int[size];
        for (int i = 1; i < size; ++i) {
            lookup[i] = lookup[i - 1] + underlyings[i - 1].getParameterCount();
        }
        this.lookup = lookup;
        this.paramCount = lookup[size - 1] + underlyings[size - 1].getParameterCount();
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public double getParameter(int parameterIndex) {
        int underlyingIndex = this.findUnderlyingIndex(parameterIndex);
        int adjustment = this.lookup[underlyingIndex];
        return this.underlyings[underlyingIndex].getParameter(parameterIndex - adjustment);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        int underlyingIndex = this.findUnderlyingIndex(parameterIndex);
        int adjustment = this.lookup[underlyingIndex];
        return this.underlyings[underlyingIndex].getParameterMetadata(parameterIndex - adjustment);
    }

    public <R extends ParameterizedData> R underlyingWithParameter(int underlyingIndex, Class<R> underlyingType, int parameterIndex, double newValue) {
        ParameterizedData perturbed = this.underlyings[underlyingIndex];
        if (this.findUnderlyingIndex(parameterIndex) == underlyingIndex) {
            int adjustment = this.lookup[underlyingIndex];
            perturbed = perturbed.withParameter(parameterIndex - adjustment, newValue);
        }
        return (R)((ParameterizedData)underlyingType.cast(perturbed));
    }

    public <R extends ParameterizedData> R underlyingWithPerturbation(int underlyingIndex, Class<R> underlyingType, ParameterPerturbation perturbation) {
        ParameterizedData underlying = this.underlyings[underlyingIndex];
        int adjustment = this.lookup[underlyingIndex];
        ParameterizedData perturbed = underlying.withPerturbation((idx, value, meta) -> perturbation.perturbParameter(idx + adjustment, value, meta));
        return (R)((ParameterizedData)underlyingType.cast(perturbed));
    }

    public <R extends ParameterizedData> List<R> withParameter(Class<R> underlyingType, int parameterIndex, double newValue) {
        int underlyingIndex = this.findUnderlyingIndex(parameterIndex);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.underlyings.length; ++i) {
            ParameterizedData underlying = this.underlyings[i];
            if (i == underlyingIndex) {
                int adjustment = this.lookup[underlyingIndex];
                ParameterizedData perturbed = underlying.withParameter(parameterIndex - adjustment, newValue);
                builder.add(underlyingType.cast(perturbed));
                continue;
            }
            builder.add(underlyingType.cast(underlying));
        }
        return builder.build();
    }

    public <R extends ParameterizedData> List<R> withPerturbation(Class<R> underlyingType, ParameterPerturbation perturbation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.underlyings.length; ++i) {
            builder.add(this.underlyingWithPerturbation(i, underlyingType, perturbation));
        }
        return builder.build();
    }

    private int findUnderlyingIndex(int parameterIndex) {
        Preconditions.checkElementIndex((int)parameterIndex, (int)this.paramCount);
        for (int i = 1; i < this.lookup.length; ++i) {
            if (parameterIndex >= this.lookup[i]) continue;
            return i - 1;
        }
        return this.lookup.length - 1;
    }
}

