/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import java.util.OptionalInt;
import org.joda.beans.JodaBeanUtils;

public interface ParameterizedData {
    public int getParameterCount();

    public double getParameter(int var1);

    public ParameterMetadata getParameterMetadata(int var1);

    default public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        if (!ParameterMetadata.empty().equals(metadata)) {
            for (int i = 0; i < this.getParameterCount(); ++i) {
                if (!this.getParameterMetadata(i).equals(metadata)) continue;
                return OptionalInt.of(i);
            }
        }
        return OptionalInt.empty();
    }

    public ParameterizedData withParameter(int var1, double var2);

    default public ParameterizedData withPerturbation(ParameterPerturbation perturbation) {
        ParameterizedData result = this;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            double perturbedValue;
            double currentValue = this.getParameter(i);
            result = JodaBeanUtils.equal((double)currentValue, (double)(perturbedValue = perturbation.perturbParameter(i, currentValue, this.getParameterMetadata(i)))) ? result : result.withParameter(i, perturbedValue);
        }
        return result;
    }
}

