/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataName;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ParameterSize
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final MarketDataName<?> name;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final int parameterCount;
    private static final long serialVersionUID = 1L;

    public static ParameterSize of(MarketDataName<?> name, int parameterCount) {
        return new ParameterSize(name, parameterCount);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ParameterSize(MarketDataName<?> name, int parameterCount) {
        JodaBeanUtils.notNull(name, (String)"name");
        ArgChecker.notNegativeOrZero((int)parameterCount, (String)"parameterCount");
        this.name = name;
        this.parameterCount = parameterCount;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public MarketDataName<?> getName() {
        return this.name;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ParameterSize other = (ParameterSize)obj;
            return JodaBeanUtils.equal(this.name, other.name) && this.parameterCount == other.parameterCount;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.parameterCount);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ParameterSize{");
        buf.append("name").append('=').append(JodaBeanUtils.toString(this.name)).append(',').append(' ');
        buf.append("parameterCount").append('=').append(JodaBeanUtils.toString((Object)this.parameterCount));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ParameterSize> {
        private MarketDataName<?> name;
        private int parameterCount;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1107332838: {
                    return this.parameterCount;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (MarketDataName)newValue;
                    break;
                }
                case 1107332838: {
                    this.parameterCount = (Integer)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ParameterSize build() {
            return new ParameterSize(this.name, this.parameterCount);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ParameterSize.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString(this.name)).append(',').append(' ');
            buf.append("parameterCount").append('=').append(JodaBeanUtils.toString((Object)this.parameterCount));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<MarketDataName<?>> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ParameterSize.class, MarketDataName.class);
        private final MetaProperty<Integer> parameterCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterCount", ParameterSize.class, Integer.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "parameterCount"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1107332838: {
                    return this.parameterCount;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ParameterSize> builder() {
            return new Builder();
        }

        public Class<? extends ParameterSize> beanType() {
            return ParameterSize.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<MarketDataName<?>> name() {
            return this.name;
        }

        public MetaProperty<Integer> parameterCount() {
            return this.parameterCount;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ParameterSize)bean).getName();
                }
                case 1107332838: {
                    return ((ParameterSize)bean).getParameterCount();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

