/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CrossGammaParameterSensitivity;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CrossGammaParameterSensitivities
implements FxConvertible<CrossGammaParameterSensitivities>,
ImmutableBean,
Serializable {
    private static final CrossGammaParameterSensitivities EMPTY = new CrossGammaParameterSensitivities((ImmutableList<CrossGammaParameterSensitivity>)ImmutableList.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<CrossGammaParameterSensitivity> sensitivities;
    private static final long serialVersionUID = 1L;

    public static CrossGammaParameterSensitivities empty() {
        return EMPTY;
    }

    public static CrossGammaParameterSensitivities of(CrossGammaParameterSensitivity sensitivity) {
        return new CrossGammaParameterSensitivities((ImmutableList<CrossGammaParameterSensitivity>)ImmutableList.of((Object)sensitivity));
    }

    public static CrossGammaParameterSensitivities of(CrossGammaParameterSensitivity ... sensitivities) {
        return CrossGammaParameterSensitivities.of(Arrays.asList(sensitivities));
    }

    public static CrossGammaParameterSensitivities of(List<? extends CrossGammaParameterSensitivity> sensitivities) {
        ArrayList<CrossGammaParameterSensitivity> mutable = new ArrayList<CrossGammaParameterSensitivity>();
        for (CrossGammaParameterSensitivity crossGammaParameterSensitivity : sensitivities) {
            CrossGammaParameterSensitivities.insert(mutable, crossGammaParameterSensitivity);
        }
        return new CrossGammaParameterSensitivities((ImmutableList<CrossGammaParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    @ImmutableConstructor
    private CrossGammaParameterSensitivities(List<? extends CrossGammaParameterSensitivity> sensitivities) {
        if (sensitivities.size() < 2) {
            this.sensitivities = ImmutableList.copyOf(sensitivities);
        } else {
            ArrayList<? extends CrossGammaParameterSensitivity> mutable = new ArrayList<CrossGammaParameterSensitivity>(sensitivities);
            mutable.sort(CrossGammaParameterSensitivity::compareKey);
            this.sensitivities = ImmutableList.copyOf(mutable);
        }
    }

    private CrossGammaParameterSensitivities(ImmutableList<CrossGammaParameterSensitivity> sensitivities) {
        this.sensitivities = sensitivities;
    }

    public int size() {
        return this.sensitivities.size();
    }

    public CrossGammaParameterSensitivity getSensitivity(MarketDataName<?> name, Currency currency) {
        return this.findSensitivity(name, currency).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"Unable to find sensitivity: {} for {}", (Object[])new Object[]{name, currency})));
    }

    public CrossGammaParameterSensitivity getSensitivity(MarketDataName<?> nameFirst, MarketDataName<?> nameSecond, Currency currency) {
        CrossGammaParameterSensitivity sensi = this.findSensitivity(nameFirst, currency).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"Unable to find sensitivity: {} for {}", (Object[])new Object[]{nameFirst, currency})));
        return sensi.getSensitivity(nameSecond);
    }

    public Optional<CrossGammaParameterSensitivity> findSensitivity(MarketDataName<?> name, Currency currency) {
        return this.sensitivities.stream().filter(sens -> sens.getMarketDataName().equals((Object)name) && sens.getCurrency().equals((Object)currency)).findFirst();
    }

    public CrossGammaParameterSensitivities combinedWith(CrossGammaParameterSensitivity other) {
        ArrayList<CrossGammaParameterSensitivity> mutable = new ArrayList<CrossGammaParameterSensitivity>((Collection<CrossGammaParameterSensitivity>)this.sensitivities);
        CrossGammaParameterSensitivities.insert(mutable, other);
        return new CrossGammaParameterSensitivities((ImmutableList<CrossGammaParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    public CrossGammaParameterSensitivities combinedWith(CrossGammaParameterSensitivities other) {
        ArrayList<CrossGammaParameterSensitivity> mutable = new ArrayList<CrossGammaParameterSensitivity>((Collection<CrossGammaParameterSensitivity>)this.sensitivities);
        for (CrossGammaParameterSensitivity otherSens : other.sensitivities) {
            CrossGammaParameterSensitivities.insert(mutable, otherSens);
        }
        return new CrossGammaParameterSensitivities((ImmutableList<CrossGammaParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    private static void insert(List<CrossGammaParameterSensitivity> mutable, CrossGammaParameterSensitivity addition) {
        int index = Collections.binarySearch(mutable, addition, CrossGammaParameterSensitivity::compareKey);
        if (index >= 0) {
            CrossGammaParameterSensitivity base = mutable.get(index);
            DoubleMatrix combined = base.getSensitivity().plus(addition.getSensitivity());
            mutable.set(index, base.withSensitivity(combined));
        } else {
            int insertionPoint = -(index + 1);
            mutable.add(insertionPoint, addition);
        }
    }

    public CrossGammaParameterSensitivities convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        ArrayList<CrossGammaParameterSensitivity> mutable = new ArrayList<CrossGammaParameterSensitivity>();
        for (CrossGammaParameterSensitivity sens : this.sensitivities) {
            CrossGammaParameterSensitivities.insert(mutable, sens.convertedTo(resultCurrency, rateProvider));
        }
        return new CrossGammaParameterSensitivities((ImmutableList<CrossGammaParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    public CurrencyAmount total(Currency resultCurrency, FxRateProvider rateProvider) {
        CrossGammaParameterSensitivities converted = this.convertedTo(resultCurrency, rateProvider);
        double total = converted.sensitivities.stream().mapToDouble(s -> s.getSensitivity().total()).sum();
        return CurrencyAmount.of((Currency)resultCurrency, (double)total);
    }

    public MultiCurrencyAmount total() {
        return (MultiCurrencyAmount)this.sensitivities.stream().map(CrossGammaParameterSensitivity::total).collect(MultiCurrencyAmount.toMultiCurrencyAmount());
    }

    public CurrencyParameterSensitivities diagonal() {
        return CurrencyParameterSensitivities.of(this.sensitivities.stream().map(s -> s.diagonal()).collect(Collectors.toList()));
    }

    public CrossGammaParameterSensitivities multipliedBy(double factor) {
        return this.mapSensitivities(s -> s * factor);
    }

    public CrossGammaParameterSensitivities mapSensitivities(DoubleUnaryOperator operator) {
        return this.sensitivities.stream().map(s -> s.mapSensitivity(operator)).collect(Collectors.collectingAndThen(Guavate.toImmutableList(), CrossGammaParameterSensitivities::new));
    }

    public boolean equalWithTolerance(CrossGammaParameterSensitivities other, double tolerance) {
        ArrayList<CrossGammaParameterSensitivity> mutable = new ArrayList<CrossGammaParameterSensitivity>((Collection<CrossGammaParameterSensitivity>)other.sensitivities);
        for (CrossGammaParameterSensitivity sens1 : this.sensitivities) {
            int index = Collections.binarySearch(mutable, sens1, CrossGammaParameterSensitivity::compareKey);
            if (index >= 0) {
                CrossGammaParameterSensitivity sens2 = (CrossGammaParameterSensitivity)mutable.get(index);
                if (!this.equalWithTolerance(sens1.getSensitivity(), sens2.getSensitivity(), tolerance)) {
                    return false;
                }
                mutable.remove(index);
                continue;
            }
            if (this.equalZeroWithTolerance(sens1.getSensitivity(), tolerance)) continue;
            return false;
        }
        for (CrossGammaParameterSensitivity sens2 : mutable) {
            if (this.equalZeroWithTolerance(sens2.getSensitivity(), tolerance)) continue;
            return false;
        }
        return true;
    }

    private boolean equalWithTolerance(DoubleMatrix sens1, DoubleMatrix sens2, double tolerance) {
        int colCount = sens1.columnCount();
        if (colCount != sens2.columnCount()) {
            return false;
        }
        for (int i = 0; i < colCount; ++i) {
            if (sens1.column(i).equalWithTolerance(sens2.column(i), tolerance)) continue;
            return false;
        }
        return true;
    }

    private boolean equalZeroWithTolerance(DoubleMatrix sens, double tolerance) {
        int colCount = sens.columnCount();
        for (int i = 0; i < colCount; ++i) {
            if (DoubleArrayMath.fuzzyEqualsZero((double[])sens.column(i).toArray(), (double)tolerance)) continue;
            return false;
        }
        return true;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<CrossGammaParameterSensitivity> getSensitivities() {
        return this.sensitivities;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CrossGammaParameterSensitivities other = (CrossGammaParameterSensitivities)obj;
            return JodaBeanUtils.equal(this.sensitivities, other.sensitivities);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.sensitivities);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("CrossGammaParameterSensitivities{");
        buf.append("sensitivities").append('=').append(JodaBeanUtils.toString(this.sensitivities));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CrossGammaParameterSensitivities> {
        private List<CrossGammaParameterSensitivity> sensitivities = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return this.sensitivities;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    this.sensitivities = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CrossGammaParameterSensitivities build() {
            return new CrossGammaParameterSensitivities(this.sensitivities);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("CrossGammaParameterSensitivities.Builder{");
            buf.append("sensitivities").append('=').append(JodaBeanUtils.toString(this.sensitivities));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<CrossGammaParameterSensitivity>> sensitivities = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivities", CrossGammaParameterSensitivities.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"sensitivities"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return this.sensitivities;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CrossGammaParameterSensitivities> builder() {
            return new Builder();
        }

        public Class<? extends CrossGammaParameterSensitivities> beanType() {
            return CrossGammaParameterSensitivities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<CrossGammaParameterSensitivity>> sensitivities() {
            return this.sensitivities;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return ((CrossGammaParameterSensitivities)bean).getSensitivities();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

