/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.observable;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.ObservableSource;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light", cacheHashCode=true)
public final class QuoteId
implements ObservableId,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final StandardId standardId;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FieldName fieldName;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ObservableSource observableSource;
    private static final TypedMetaBean<QuoteId> META_BEAN = LightMetaBean.of(QuoteId.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"standardId", "fieldName", "observableSource"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;
    private transient int cacheHashCode;

    public static QuoteId of(StandardId standardId) {
        return new QuoteId(standardId, FieldName.MARKET_VALUE, ObservableSource.NONE);
    }

    public static QuoteId of(StandardId standardId, FieldName fieldName) {
        return new QuoteId(standardId, fieldName, ObservableSource.NONE);
    }

    public static QuoteId of(StandardId standardId, FieldName fieldName, ObservableSource obsSource) {
        return new QuoteId(standardId, fieldName, obsSource);
    }

    public QuoteId withObservableSource(ObservableSource obsSource) {
        return new QuoteId(this.standardId, this.fieldName, obsSource);
    }

    public String toString() {
        return new StringBuilder(32).append("QuoteId:").append(this.standardId).append('/').append(this.fieldName).append(this.observableSource.equals((Object)ObservableSource.NONE) ? "" : "/" + this.observableSource).toString();
    }

    public static TypedMetaBean<QuoteId> meta() {
        return META_BEAN;
    }

    private QuoteId(StandardId standardId, FieldName fieldName, ObservableSource observableSource) {
        JodaBeanUtils.notNull((Object)standardId, (String)"standardId");
        JodaBeanUtils.notNull((Object)fieldName, (String)"fieldName");
        JodaBeanUtils.notNull((Object)observableSource, (String)"observableSource");
        this.standardId = standardId;
        this.fieldName = fieldName;
        this.observableSource = observableSource;
    }

    public TypedMetaBean<QuoteId> metaBean() {
        return META_BEAN;
    }

    public StandardId getStandardId() {
        return this.standardId;
    }

    public FieldName getFieldName() {
        return this.fieldName;
    }

    public ObservableSource getObservableSource() {
        return this.observableSource;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            QuoteId other = (QuoteId)obj;
            return JodaBeanUtils.equal((Object)this.standardId, (Object)other.standardId) && JodaBeanUtils.equal((Object)this.fieldName, (Object)other.fieldName) && JodaBeanUtils.equal((Object)this.observableSource, (Object)other.observableSource);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.cacheHashCode;
        if (hash == 0) {
            hash = this.getClass().hashCode();
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.standardId);
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fieldName);
            this.cacheHashCode = hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableSource);
        }
        return hash;
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

