/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.observable;

import com.opengamma.strata.market.observable.QuoteId;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class Quote
implements ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final QuoteId quoteId;
    @PropertyDefinition(validate="notNull")
    private final double value;

    public static Quote of(QuoteId quoteId, double value) {
        return new Quote(quoteId, value);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private Quote(QuoteId quoteId, double value) {
        JodaBeanUtils.notNull((Object)quoteId, (String)"quoteId");
        JodaBeanUtils.notNull((Object)value, (String)"value");
        this.quoteId = quoteId;
        this.value = value;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Quote other = (Quote)obj;
            return JodaBeanUtils.equal((Object)this.quoteId, (Object)other.quoteId) && JodaBeanUtils.equal((double)this.value, (double)other.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.quoteId);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.value);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("Quote{");
        buf.append("quoteId").append('=').append(JodaBeanUtils.toString((Object)this.quoteId)).append(',').append(' ');
        buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<Quote> {
        private QuoteId quoteId;
        private double value;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 664377527: {
                    return this.quoteId;
                }
                case 111972721: {
                    return this.value;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 664377527: {
                    this.quoteId = (QuoteId)newValue;
                    break;
                }
                case 111972721: {
                    this.value = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Quote build() {
            return new Quote(this.quoteId, this.value);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("Quote.Builder{");
            buf.append("quoteId").append('=').append(JodaBeanUtils.toString((Object)this.quoteId)).append(',').append(' ');
            buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<QuoteId> quoteId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quoteId", Quote.class, QuoteId.class);
        private final MetaProperty<Double> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", Quote.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"quoteId", "value"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 664377527: {
                    return this.quoteId;
                }
                case 111972721: {
                    return this.value;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends Quote> builder() {
            return new Builder();
        }

        public Class<? extends Quote> beanType() {
            return Quote.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<QuoteId> quoteId() {
            return this.quoteId;
        }

        public MetaProperty<Double> value() {
            return this.value;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 664377527: {
                    return ((Quote)bean).getQuoteId();
                }
                case 111972721: {
                    return ((Quote)bean).getValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

