/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.observable;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.ObservableSource;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light", cacheHashCode=true)
public final class IndexQuoteId
implements ObservableId,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Index index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FieldName fieldName;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ObservableSource observableSource;
    private static final TypedMetaBean<IndexQuoteId> META_BEAN = LightMetaBean.of(IndexQuoteId.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"index", "fieldName", "observableSource"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;
    private transient int cacheHashCode;

    public static IndexQuoteId of(Index index) {
        return new IndexQuoteId(index, FieldName.MARKET_VALUE, ObservableSource.NONE);
    }

    public static IndexQuoteId of(Index index, FieldName fieldName) {
        return new IndexQuoteId(index, fieldName, ObservableSource.NONE);
    }

    public static IndexQuoteId of(Index index, FieldName fieldName, ObservableSource obsSource) {
        return new IndexQuoteId(index, fieldName, obsSource);
    }

    public StandardId getStandardId() {
        return StandardId.of((String)"OG-Index", (String)this.index.getName());
    }

    public IndexQuoteId withObservableSource(ObservableSource obsSource) {
        return new IndexQuoteId(this.index, this.fieldName, obsSource);
    }

    public String toString() {
        return new StringBuilder(32).append("IndexQuoteId:").append(this.index).append('/').append(this.fieldName).append(this.observableSource.equals((Object)ObservableSource.NONE) ? "" : "/" + this.observableSource).toString();
    }

    public static TypedMetaBean<IndexQuoteId> meta() {
        return META_BEAN;
    }

    private IndexQuoteId(Index index, FieldName fieldName, ObservableSource observableSource) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)fieldName, (String)"fieldName");
        JodaBeanUtils.notNull((Object)observableSource, (String)"observableSource");
        this.index = index;
        this.fieldName = fieldName;
        this.observableSource = observableSource;
    }

    public TypedMetaBean<IndexQuoteId> metaBean() {
        return META_BEAN;
    }

    public Index getIndex() {
        return this.index;
    }

    public FieldName getFieldName() {
        return this.fieldName;
    }

    public ObservableSource getObservableSource() {
        return this.observableSource;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IndexQuoteId other = (IndexQuoteId)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.fieldName, (Object)other.fieldName) && JodaBeanUtils.equal((Object)this.observableSource, (Object)other.observableSource);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.cacheHashCode;
        if (hash == 0) {
            hash = this.getClass().hashCode();
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fieldName);
            this.cacheHashCode = hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableSource);
        }
        return hash;
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

