/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.explain;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class ExplainMapBuilder {
    private final ExplainMapBuilder parent;
    private final Map<ExplainKey<?>, Object> map = new LinkedHashMap();

    ExplainMapBuilder() {
        this.parent = null;
    }

    ExplainMapBuilder(ExplainMapBuilder parent) {
        this.parent = parent;
    }

    public <R extends List<?>> ExplainMapBuilder openListEntry(ExplainKey<R> key) {
        ArrayList<ExplainMapBuilder> list;
        ExplainMapBuilder child = new ExplainMapBuilder(this);
        Object value = this.map.get(key);
        if (value instanceof ArrayList) {
            list = (ArrayList<ExplainMapBuilder>)value;
        } else {
            list = new ArrayList<ExplainMapBuilder>();
            this.map.put(key, list);
        }
        list.add(child);
        return child;
    }

    public <R extends List<?>> ExplainMapBuilder closeListEntry(ExplainKey<R> key) {
        Object value = this.parent.map.get(key);
        if (!(value instanceof ArrayList)) {
            throw new IllegalStateException("ExplainMapBuilder.closeList() called but no list found to close");
        }
        ArrayList list = (ArrayList)value;
        ExplainMapBuilder closedEntry = (ExplainMapBuilder)list.get(list.size() - 1);
        list.set(list.size() - 1, closedEntry.build());
        return this.parent;
    }

    public <R extends List<?>> ExplainMapBuilder addListEntry(ExplainKey<R> key, Consumer<ExplainMapBuilder> consumer) {
        ExplainMapBuilder child = this.openListEntry(key);
        consumer.accept(child);
        return child.closeListEntry(key);
    }

    public <R extends List<?>> ExplainMapBuilder addListEntryWithIndex(ExplainKey<R> key, Consumer<ExplainMapBuilder> consumer) {
        ExplainMapBuilder child = this.openListEntry(key);
        Object value = this.map.get(key);
        ArrayList list = (ArrayList)value;
        child.put(ExplainKey.ENTRY_INDEX, list.size() - 1);
        consumer.accept(child);
        return child.closeListEntry(key);
    }

    public <R> ExplainMapBuilder put(ExplainKey<R> key, R value) {
        ArgChecker.notNull(key, (String)"key");
        ArgChecker.notNull(value, (String)"value");
        this.map.put(key, value);
        return this;
    }

    public ExplainMap build() {
        return ExplainMap.of(this.map);
    }
}

