/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.explain;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.joda.convert.StringConvert;

@BeanDefinition(builderScope="private")
public final class ExplainMap
implements FxConvertible<ExplainMap>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<ExplainKey<?>, Object> map;
    private static final long serialVersionUID = 1L;

    public static ExplainMap of(Map<ExplainKey<?>, Object> map) {
        return new ExplainMap(map);
    }

    public static ExplainMap empty() {
        return new ExplainMap((Map<ExplainKey<?>, Object>)ImmutableMap.of());
    }

    public static ExplainMapBuilder builder() {
        return new ExplainMapBuilder();
    }

    public <R> Optional<R> get(ExplainKey<R> key) {
        return Optional.ofNullable(this.map.get(key));
    }

    public String explanationString() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("ExplainMap ");
        this.explanationString(buf, "");
        buf.append(System.lineSeparator());
        return buf.toString();
    }

    private void explanationString(StringBuilder buf, String indent) {
        buf.append("{").append(System.lineSeparator());
        String entryIndent = indent + "  ";
        for (Map.Entry entry : this.map.entrySet()) {
            buf.append(entryIndent).append(entry.getKey()).append(" = ");
            if (entry.getValue() instanceof List) {
                List list = (List)entry.getValue();
                this.explanationString(buf, entryIndent, list);
            } else {
                try {
                    buf.append(StringConvert.INSTANCE.convertToString(entry.getValue()));
                }
                catch (Exception ex) {
                    buf.append(entry.getValue());
                }
            }
            buf.append(',').append(System.lineSeparator());
        }
        if (!this.map.entrySet().isEmpty()) {
            buf.deleteCharAt(buf.lastIndexOf(","));
        }
        buf.append(indent).append("}");
    }

    private void explanationString(StringBuilder buf, String indent, List<ExplainMap> list) {
        if (list.isEmpty()) {
            buf.append("[]");
        } else {
            buf.append("[");
            for (ExplainMap child : list) {
                child.explanationString(buf, indent);
                buf.append(',');
            }
            buf.setCharAt(buf.length() - 1, ']');
        }
    }

    public ExplainMap convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry explainEntry : this.map.entrySet()) {
            if (explainEntry.getValue() instanceof FxConvertible) {
                Object convertedValue = ((FxConvertible)explainEntry.getValue()).convertedTo(resultCurrency, rateProvider);
                builder.put(explainEntry.getKey(), convertedValue);
                continue;
            }
            builder.put(explainEntry.getKey(), explainEntry.getValue());
        }
        return ExplainMap.of(builder.build());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ExplainMap(Map<ExplainKey<?>, Object> map) {
        JodaBeanUtils.notNull(map, (String)"map");
        this.map = ImmutableMap.copyOf(map);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableMap<ExplainKey<?>, Object> getMap() {
        return this.map;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ExplainMap other = (ExplainMap)obj;
            return JodaBeanUtils.equal(this.map, other.map);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.map);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("ExplainMap{");
        buf.append("map").append('=').append(JodaBeanUtils.toString(this.map));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ExplainMap> {
        private Map<ExplainKey<?>, Object> map = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 107868: {
                    return this.map;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 107868: {
                    this.map = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ExplainMap build() {
            return new ExplainMap(this.map);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("ExplainMap.Builder{");
            buf.append("map").append('=').append(JodaBeanUtils.toString(this.map));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableMap<ExplainKey<?>, Object>> map = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"map", ExplainMap.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"map"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 107868: {
                    return this.map;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ExplainMap> builder() {
            return new Builder();
        }

        public Class<? extends ExplainMap> beanType() {
            return ExplainMap.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableMap<ExplainKey<?>, Object>> map() {
            return this.map;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 107868: {
                    return ((ExplainMap)bean).getMap();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

