/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.node;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.FxRateId;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveNode;
import com.opengamma.strata.market.curve.CurveNodeDate;
import com.opengamma.strata.market.curve.CurveNodeDateOrder;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import com.opengamma.strata.market.param.LabelDateParameterMetadata;
import com.opengamma.strata.market.param.TenorDateParameterMetadata;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.swap.ResolvedSwapTrade;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.XCcyOvernightOvernightSwapTemplate;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class XCcyOvernightOvernightSwapCurveNode
implements CurveNode,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final XCcyOvernightOvernightSwapTemplate template;
    @PropertyDefinition(validate="notNull")
    private final FxRateId fxRateId;
    @PropertyDefinition(validate="notNull")
    private final ObservableId spreadId;
    @PropertyDefinition
    private final double additionalSpread;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    @PropertyDefinition
    private final CurveNodeDate date;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveNodeDateOrder dateOrder;
    private static final long serialVersionUID = 1L;

    public static XCcyOvernightOvernightSwapCurveNode of(XCcyOvernightOvernightSwapTemplate template, ObservableId spreadId) {
        return XCcyOvernightOvernightSwapCurveNode.of(template, spreadId, 0.0);
    }

    public static XCcyOvernightOvernightSwapCurveNode of(XCcyOvernightOvernightSwapTemplate template, ObservableId spreadId, double additionalSpread) {
        return XCcyOvernightOvernightSwapCurveNode.builder().template(template).spreadId(spreadId).additionalSpread(additionalSpread).build();
    }

    public static XCcyOvernightOvernightSwapCurveNode of(XCcyOvernightOvernightSwapTemplate template, ObservableId spreadId, double additionalSpread, String label) {
        FxRateId fxRateId = FxRateId.of((CurrencyPair)template.getCurrencyPair());
        return new XCcyOvernightOvernightSwapCurveNode(template, fxRateId, spreadId, additionalSpread, label, CurveNodeDate.END, CurveNodeDateOrder.DEFAULT);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.date = CurveNodeDate.END;
        builder.dateOrder = CurveNodeDateOrder.DEFAULT;
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.template != null) {
            if (builder.label == null) {
                builder.label = builder.template.getTenor().toString();
            }
            if (builder.fxRateId == null) {
                builder.fxRateId = FxRateId.of((CurrencyPair)builder.template.getCurrencyPair());
            } else {
                ArgChecker.isTrue((boolean)builder.fxRateId.getPair().toConventional().equals((Object)builder.template.getCurrencyPair().toConventional()), (String)"FxRateId currency pair '{}' must match that of the template '{}'", (Object[])new Object[]{builder.fxRateId.getPair(), builder.template.getCurrencyPair()});
            }
        }
    }

    @Override
    public Set<? extends MarketDataId<?>> requirements() {
        return ImmutableSet.of((Object)this.fxRateId, (Object)this.spreadId);
    }

    @Override
    public LocalDate date(LocalDate valuationDate, ReferenceData refData) {
        return this.date.calculate(() -> this.calculateEnd(valuationDate, refData), () -> this.calculateLastFixingDate(valuationDate));
    }

    @Override
    public DatedParameterMetadata metadata(LocalDate valuationDate, ReferenceData refData) {
        LocalDate nodeDate = this.date(valuationDate, refData);
        if (this.date.isFixed()) {
            return LabelDateParameterMetadata.of(nodeDate, this.label);
        }
        return TenorDateParameterMetadata.of(nodeDate, this.template.getTenor(), this.label);
    }

    private LocalDate calculateEnd(LocalDate valuationDate, ReferenceData refData) {
        SwapTrade trade = this.template.createTrade(valuationDate, BuySell.BUY, 1.0, 1.0, 0.0, refData);
        return trade.getProduct().getEndDate().adjusted(refData);
    }

    private LocalDate calculateLastFixingDate(LocalDate valuationDate) {
        throw new UnsupportedOperationException("Node date of 'LastFixing' is not supported for XCcyOvernightOvernightSwap");
    }

    public SwapTrade trade(double quantity, MarketData marketData, ReferenceData refData) {
        double marketQuote = (Double)marketData.getValue((MarketDataId)this.spreadId) + this.additionalSpread;
        FxRate fxRate = (FxRate)marketData.getValue((MarketDataId)this.fxRateId);
        double rate = fxRate.fxRate(this.template.getCurrencyPair());
        BuySell buySell = quantity > 0.0 ? BuySell.SELL : BuySell.BUY;
        double spreadLegNotional = Math.abs(quantity);
        double flatLegNotional = spreadLegNotional * rate;
        return this.template.createTrade(marketData.getValuationDate(), buySell, spreadLegNotional, flatLegNotional, marketQuote, refData);
    }

    public ResolvedSwapTrade resolvedTrade(double quantity, MarketData marketData, ReferenceData refData) {
        return this.trade(quantity, marketData, refData).resolve(refData);
    }

    public ResolvedSwapTrade sampleResolvedTrade(LocalDate valuationDate, FxRateProvider fxProvider, ReferenceData refData) {
        double rate = fxProvider.fxRate(this.template.getCurrencyPair());
        SwapTrade trade = this.template.createTrade(valuationDate, BuySell.SELL, 1.0, rate, this.additionalSpread, refData);
        return trade.resolve(refData);
    }

    @Override
    public double initialGuess(MarketData marketData, ValueType valueType) {
        if (ValueType.DISCOUNT_FACTOR.equals((Object)valueType)) {
            return 1.0;
        }
        return 0.0;
    }

    public XCcyOvernightOvernightSwapCurveNode withDate(CurveNodeDate date) {
        return new XCcyOvernightOvernightSwapCurveNode(this.template, this.fxRateId, this.spreadId, this.additionalSpread, this.label, date, this.dateOrder);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private XCcyOvernightOvernightSwapCurveNode(XCcyOvernightOvernightSwapTemplate template, FxRateId fxRateId, ObservableId spreadId, double additionalSpread, String label, CurveNodeDate date, CurveNodeDateOrder dateOrder) {
        JodaBeanUtils.notNull((Object)template, (String)"template");
        JodaBeanUtils.notNull((Object)fxRateId, (String)"fxRateId");
        JodaBeanUtils.notNull((Object)spreadId, (String)"spreadId");
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        JodaBeanUtils.notNull((Object)dateOrder, (String)"dateOrder");
        this.template = template;
        this.fxRateId = fxRateId;
        this.spreadId = spreadId;
        this.additionalSpread = additionalSpread;
        this.label = label;
        this.date = date;
        this.dateOrder = dateOrder;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public XCcyOvernightOvernightSwapTemplate getTemplate() {
        return this.template;
    }

    public FxRateId getFxRateId() {
        return this.fxRateId;
    }

    public ObservableId getSpreadId() {
        return this.spreadId;
    }

    public double getAdditionalSpread() {
        return this.additionalSpread;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public CurveNodeDate getDate() {
        return this.date;
    }

    @Override
    public CurveNodeDateOrder getDateOrder() {
        return this.dateOrder;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            XCcyOvernightOvernightSwapCurveNode other = (XCcyOvernightOvernightSwapCurveNode)obj;
            return JodaBeanUtils.equal((Object)this.template, (Object)other.template) && JodaBeanUtils.equal((Object)this.fxRateId, (Object)other.fxRateId) && JodaBeanUtils.equal((Object)this.spreadId, (Object)other.spreadId) && JodaBeanUtils.equal((double)this.additionalSpread, (double)other.additionalSpread) && JodaBeanUtils.equal((Object)this.label, (Object)other.label) && JodaBeanUtils.equal((Object)this.date, (Object)other.date) && JodaBeanUtils.equal((Object)this.dateOrder, (Object)other.dateOrder);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.template);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fxRateId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spreadId);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.additionalSpread);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dateOrder);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("XCcyOvernightOvernightSwapCurveNode{");
        buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
        buf.append("fxRateId").append('=').append(JodaBeanUtils.toString((Object)this.fxRateId)).append(',').append(' ');
        buf.append("spreadId").append('=').append(JodaBeanUtils.toString((Object)this.spreadId)).append(',').append(' ');
        buf.append("additionalSpread").append('=').append(JodaBeanUtils.toString((Object)this.additionalSpread)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
        buf.append("dateOrder").append('=').append(JodaBeanUtils.toString((Object)this.dateOrder));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<XCcyOvernightOvernightSwapCurveNode> {
        private XCcyOvernightOvernightSwapTemplate template;
        private FxRateId fxRateId;
        private ObservableId spreadId;
        private double additionalSpread;
        private String label;
        private CurveNodeDate date;
        private CurveNodeDateOrder dateOrder;

        private Builder() {
            XCcyOvernightOvernightSwapCurveNode.applyDefaults(this);
        }

        private Builder(XCcyOvernightOvernightSwapCurveNode beanToCopy) {
            this.template = beanToCopy.getTemplate();
            this.fxRateId = beanToCopy.getFxRateId();
            this.spreadId = beanToCopy.getSpreadId();
            this.additionalSpread = beanToCopy.getAdditionalSpread();
            this.label = beanToCopy.getLabel();
            this.date = beanToCopy.getDate();
            this.dateOrder = beanToCopy.getDateOrder();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case -1054985843: {
                    return this.fxRateId;
                }
                case -1759090194: {
                    return this.spreadId;
                }
                case 291232890: {
                    return this.additionalSpread;
                }
                case 102727412: {
                    return this.label;
                }
                case 3076014: {
                    return this.date;
                }
                case -263699392: {
                    return this.dateOrder;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    this.template = (XCcyOvernightOvernightSwapTemplate)newValue;
                    break;
                }
                case -1054985843: {
                    this.fxRateId = (FxRateId)newValue;
                    break;
                }
                case -1759090194: {
                    this.spreadId = (ObservableId)newValue;
                    break;
                }
                case 291232890: {
                    this.additionalSpread = (Double)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                case 3076014: {
                    this.date = (CurveNodeDate)newValue;
                    break;
                }
                case -263699392: {
                    this.dateOrder = (CurveNodeDateOrder)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public XCcyOvernightOvernightSwapCurveNode build() {
            XCcyOvernightOvernightSwapCurveNode.preBuild(this);
            return new XCcyOvernightOvernightSwapCurveNode(this.template, this.fxRateId, this.spreadId, this.additionalSpread, this.label, this.date, this.dateOrder);
        }

        public Builder template(XCcyOvernightOvernightSwapTemplate template) {
            JodaBeanUtils.notNull((Object)template, (String)"template");
            this.template = template;
            return this;
        }

        public Builder fxRateId(FxRateId fxRateId) {
            JodaBeanUtils.notNull((Object)fxRateId, (String)"fxRateId");
            this.fxRateId = fxRateId;
            return this;
        }

        public Builder spreadId(ObservableId spreadId) {
            JodaBeanUtils.notNull((Object)spreadId, (String)"spreadId");
            this.spreadId = spreadId;
            return this;
        }

        public Builder additionalSpread(double additionalSpread) {
            this.additionalSpread = additionalSpread;
            return this;
        }

        public Builder label(String label) {
            JodaBeanUtils.notEmpty((String)label, (String)"label");
            this.label = label;
            return this;
        }

        public Builder date(CurveNodeDate date) {
            this.date = date;
            return this;
        }

        public Builder dateOrder(CurveNodeDateOrder dateOrder) {
            JodaBeanUtils.notNull((Object)dateOrder, (String)"dateOrder");
            this.dateOrder = dateOrder;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("XCcyOvernightOvernightSwapCurveNode.Builder{");
            buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
            buf.append("fxRateId").append('=').append(JodaBeanUtils.toString((Object)this.fxRateId)).append(',').append(' ');
            buf.append("spreadId").append('=').append(JodaBeanUtils.toString((Object)this.spreadId)).append(',').append(' ');
            buf.append("additionalSpread").append('=').append(JodaBeanUtils.toString((Object)this.additionalSpread)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
            buf.append("dateOrder").append('=').append(JodaBeanUtils.toString((Object)this.dateOrder));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<XCcyOvernightOvernightSwapTemplate> template = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"template", XCcyOvernightOvernightSwapCurveNode.class, XCcyOvernightOvernightSwapTemplate.class);
        private final MetaProperty<FxRateId> fxRateId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fxRateId", XCcyOvernightOvernightSwapCurveNode.class, FxRateId.class);
        private final MetaProperty<ObservableId> spreadId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spreadId", XCcyOvernightOvernightSwapCurveNode.class, ObservableId.class);
        private final MetaProperty<Double> additionalSpread = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"additionalSpread", XCcyOvernightOvernightSwapCurveNode.class, Double.TYPE);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", XCcyOvernightOvernightSwapCurveNode.class, String.class);
        private final MetaProperty<CurveNodeDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", XCcyOvernightOvernightSwapCurveNode.class, CurveNodeDate.class);
        private final MetaProperty<CurveNodeDateOrder> dateOrder = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dateOrder", XCcyOvernightOvernightSwapCurveNode.class, CurveNodeDateOrder.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"template", "fxRateId", "spreadId", "additionalSpread", "label", "date", "dateOrder"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case -1054985843: {
                    return this.fxRateId;
                }
                case -1759090194: {
                    return this.spreadId;
                }
                case 291232890: {
                    return this.additionalSpread;
                }
                case 102727412: {
                    return this.label;
                }
                case 3076014: {
                    return this.date;
                }
                case -263699392: {
                    return this.dateOrder;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends XCcyOvernightOvernightSwapCurveNode> beanType() {
            return XCcyOvernightOvernightSwapCurveNode.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<XCcyOvernightOvernightSwapTemplate> template() {
            return this.template;
        }

        public MetaProperty<FxRateId> fxRateId() {
            return this.fxRateId;
        }

        public MetaProperty<ObservableId> spreadId() {
            return this.spreadId;
        }

        public MetaProperty<Double> additionalSpread() {
            return this.additionalSpread;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        public MetaProperty<CurveNodeDate> date() {
            return this.date;
        }

        public MetaProperty<CurveNodeDateOrder> dateOrder() {
            return this.dateOrder;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return ((XCcyOvernightOvernightSwapCurveNode)bean).getTemplate();
                }
                case -1054985843: {
                    return ((XCcyOvernightOvernightSwapCurveNode)bean).getFxRateId();
                }
                case -1759090194: {
                    return ((XCcyOvernightOvernightSwapCurveNode)bean).getSpreadId();
                }
                case 291232890: {
                    return ((XCcyOvernightOvernightSwapCurveNode)bean).getAdditionalSpread();
                }
                case 102727412: {
                    return ((XCcyOvernightOvernightSwapCurveNode)bean).getLabel();
                }
                case 3076014: {
                    return ((XCcyOvernightOvernightSwapCurveNode)bean).getDate();
                }
                case -263699392: {
                    return ((XCcyOvernightOvernightSwapCurveNode)bean).getDateOrder();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

