/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.node;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveNode;
import com.opengamma.strata.market.curve.CurveNodeDate;
import com.opengamma.strata.market.curve.CurveNodeDateOrder;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import com.opengamma.strata.market.param.LabelDateParameterMetadata;
import com.opengamma.strata.market.param.TenorDateParameterMetadata;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.rate.IborRateComputation;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.ResolvedSwapTrade;
import com.opengamma.strata.product.swap.SwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.OvernightIborSwapTemplate;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class OvernightIborSwapCurveNode
implements CurveNode,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final OvernightIborSwapTemplate template;
    @PropertyDefinition(validate="notNull")
    private final ObservableId rateId;
    @PropertyDefinition
    private final double additionalSpread;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    @PropertyDefinition
    private final CurveNodeDate date;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveNodeDateOrder dateOrder;
    private static final long serialVersionUID = 1L;

    public static OvernightIborSwapCurveNode of(OvernightIborSwapTemplate template, ObservableId rateId) {
        return OvernightIborSwapCurveNode.of(template, rateId, 0.0);
    }

    public static OvernightIborSwapCurveNode of(OvernightIborSwapTemplate template, ObservableId rateId, double additionalSpread) {
        return OvernightIborSwapCurveNode.builder().template(template).rateId(rateId).additionalSpread(additionalSpread).build();
    }

    public static OvernightIborSwapCurveNode of(OvernightIborSwapTemplate template, ObservableId rateId, double additionalSpread, String label) {
        return new OvernightIborSwapCurveNode(template, rateId, additionalSpread, label, CurveNodeDate.END, CurveNodeDateOrder.DEFAULT);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.date = CurveNodeDate.END;
        builder.dateOrder = CurveNodeDateOrder.DEFAULT;
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.label == null && builder.template != null) {
            builder.label = builder.template.getTenor().toString();
        }
    }

    public Set<ObservableId> requirements() {
        return ImmutableSet.of((Object)this.rateId);
    }

    @Override
    public LocalDate date(LocalDate valuationDate, ReferenceData refData) {
        return this.date.calculate(() -> this.calculateEnd(valuationDate, refData), () -> this.calculateLastFixingDate(valuationDate, refData));
    }

    @Override
    public DatedParameterMetadata metadata(LocalDate valuationDate, ReferenceData refData) {
        LocalDate nodeDate = this.date(valuationDate, refData);
        if (this.date.isFixed()) {
            return LabelDateParameterMetadata.of(nodeDate, this.label);
        }
        return TenorDateParameterMetadata.of(nodeDate, this.template.getTenor(), this.label);
    }

    private LocalDate calculateEnd(LocalDate valuationDate, ReferenceData refData) {
        SwapTrade trade = this.template.createTrade(valuationDate, BuySell.BUY, 1.0, 1.0, refData);
        return trade.getProduct().getEndDate().adjusted(refData);
    }

    private LocalDate calculateLastFixingDate(LocalDate valuationDate, ReferenceData refData) {
        SwapTrade trade = this.template.createTrade(valuationDate, BuySell.BUY, 1.0, 1.0, refData);
        SwapLeg iborLeg = (SwapLeg)trade.getProduct().getLegs(SwapLegType.IBOR).get(0);
        ResolvedSwapLeg iborLegExpanded = iborLeg.resolve(refData);
        ImmutableList periods = iborLegExpanded.getPaymentPeriods();
        int nbPeriods = periods.size();
        RatePaymentPeriod lastPeriod = (RatePaymentPeriod)periods.get(nbPeriods - 1);
        ImmutableList accruals = lastPeriod.getAccrualPeriods();
        int nbAccruals = accruals.size();
        IborRateComputation ibor = (IborRateComputation)((RateAccrualPeriod)accruals.get(nbAccruals - 1)).getRateComputation();
        return ibor.getFixingDate();
    }

    public SwapTrade trade(double quantity, MarketData marketData, ReferenceData refData) {
        double fixedRate = (Double)marketData.getValue((MarketDataId)this.rateId) + this.additionalSpread;
        BuySell buySell = quantity > 0.0 ? BuySell.SELL : BuySell.BUY;
        return this.template.createTrade(marketData.getValuationDate(), buySell, Math.abs(quantity), fixedRate, refData);
    }

    public ResolvedSwapTrade resolvedTrade(double quantity, MarketData marketData, ReferenceData refData) {
        return this.trade(quantity, marketData, refData).resolve(refData);
    }

    public ResolvedSwapTrade sampleResolvedTrade(LocalDate valuationDate, FxRateProvider fxProvider, ReferenceData refData) {
        SwapTrade trade = this.template.createTrade(valuationDate, BuySell.SELL, 1.0, this.additionalSpread, refData);
        return trade.resolve(refData);
    }

    @Override
    public double initialGuess(MarketData marketData, ValueType valueType) {
        if (ValueType.ZERO_RATE.equals((Object)valueType) || ValueType.FORWARD_RATE.equals((Object)valueType)) {
            return (Double)marketData.getValue((MarketDataId)this.rateId);
        }
        if (ValueType.DISCOUNT_FACTOR.equals((Object)valueType)) {
            double approximateMaturity = (double)this.template.getPeriodToStart().plus((TemporalAmount)this.template.getTenor()).toTotalMonths() / 12.0;
            return Math.exp(-approximateMaturity * (Double)marketData.getValue((MarketDataId)this.rateId));
        }
        return 0.0;
    }

    public OvernightIborSwapCurveNode withDate(CurveNodeDate date) {
        return new OvernightIborSwapCurveNode(this.template, this.rateId, this.additionalSpread, this.label, date, this.dateOrder);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OvernightIborSwapCurveNode(OvernightIborSwapTemplate template, ObservableId rateId, double additionalSpread, String label, CurveNodeDate date, CurveNodeDateOrder dateOrder) {
        JodaBeanUtils.notNull((Object)template, (String)"template");
        JodaBeanUtils.notNull((Object)rateId, (String)"rateId");
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        JodaBeanUtils.notNull((Object)dateOrder, (String)"dateOrder");
        this.template = template;
        this.rateId = rateId;
        this.additionalSpread = additionalSpread;
        this.label = label;
        this.date = date;
        this.dateOrder = dateOrder;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public OvernightIborSwapTemplate getTemplate() {
        return this.template;
    }

    public ObservableId getRateId() {
        return this.rateId;
    }

    public double getAdditionalSpread() {
        return this.additionalSpread;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public CurveNodeDate getDate() {
        return this.date;
    }

    @Override
    public CurveNodeDateOrder getDateOrder() {
        return this.dateOrder;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightIborSwapCurveNode other = (OvernightIborSwapCurveNode)obj;
            return JodaBeanUtils.equal((Object)this.template, (Object)other.template) && JodaBeanUtils.equal((Object)this.rateId, (Object)other.rateId) && JodaBeanUtils.equal((double)this.additionalSpread, (double)other.additionalSpread) && JodaBeanUtils.equal((Object)this.label, (Object)other.label) && JodaBeanUtils.equal((Object)this.date, (Object)other.date) && JodaBeanUtils.equal((Object)this.dateOrder, (Object)other.dateOrder);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.template);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rateId);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.additionalSpread);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dateOrder);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("OvernightIborSwapCurveNode{");
        buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
        buf.append("rateId").append('=').append(JodaBeanUtils.toString((Object)this.rateId)).append(',').append(' ');
        buf.append("additionalSpread").append('=').append(JodaBeanUtils.toString((Object)this.additionalSpread)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
        buf.append("dateOrder").append('=').append(JodaBeanUtils.toString((Object)this.dateOrder));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<OvernightIborSwapCurveNode> {
        private OvernightIborSwapTemplate template;
        private ObservableId rateId;
        private double additionalSpread;
        private String label;
        private CurveNodeDate date;
        private CurveNodeDateOrder dateOrder;

        private Builder() {
            OvernightIborSwapCurveNode.applyDefaults(this);
        }

        private Builder(OvernightIborSwapCurveNode beanToCopy) {
            this.template = beanToCopy.getTemplate();
            this.rateId = beanToCopy.getRateId();
            this.additionalSpread = beanToCopy.getAdditionalSpread();
            this.label = beanToCopy.getLabel();
            this.date = beanToCopy.getDate();
            this.dateOrder = beanToCopy.getDateOrder();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case -938107365: {
                    return this.rateId;
                }
                case 291232890: {
                    return this.additionalSpread;
                }
                case 102727412: {
                    return this.label;
                }
                case 3076014: {
                    return this.date;
                }
                case -263699392: {
                    return this.dateOrder;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    this.template = (OvernightIborSwapTemplate)newValue;
                    break;
                }
                case -938107365: {
                    this.rateId = (ObservableId)newValue;
                    break;
                }
                case 291232890: {
                    this.additionalSpread = (Double)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                case 3076014: {
                    this.date = (CurveNodeDate)newValue;
                    break;
                }
                case -263699392: {
                    this.dateOrder = (CurveNodeDateOrder)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public OvernightIborSwapCurveNode build() {
            OvernightIborSwapCurveNode.preBuild(this);
            return new OvernightIborSwapCurveNode(this.template, this.rateId, this.additionalSpread, this.label, this.date, this.dateOrder);
        }

        public Builder template(OvernightIborSwapTemplate template) {
            JodaBeanUtils.notNull((Object)template, (String)"template");
            this.template = template;
            return this;
        }

        public Builder rateId(ObservableId rateId) {
            JodaBeanUtils.notNull((Object)rateId, (String)"rateId");
            this.rateId = rateId;
            return this;
        }

        public Builder additionalSpread(double additionalSpread) {
            this.additionalSpread = additionalSpread;
            return this;
        }

        public Builder label(String label) {
            JodaBeanUtils.notEmpty((String)label, (String)"label");
            this.label = label;
            return this;
        }

        public Builder date(CurveNodeDate date) {
            this.date = date;
            return this;
        }

        public Builder dateOrder(CurveNodeDateOrder dateOrder) {
            JodaBeanUtils.notNull((Object)dateOrder, (String)"dateOrder");
            this.dateOrder = dateOrder;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("OvernightIborSwapCurveNode.Builder{");
            buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
            buf.append("rateId").append('=').append(JodaBeanUtils.toString((Object)this.rateId)).append(',').append(' ');
            buf.append("additionalSpread").append('=').append(JodaBeanUtils.toString((Object)this.additionalSpread)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
            buf.append("dateOrder").append('=').append(JodaBeanUtils.toString((Object)this.dateOrder));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<OvernightIborSwapTemplate> template = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"template", OvernightIborSwapCurveNode.class, OvernightIborSwapTemplate.class);
        private final MetaProperty<ObservableId> rateId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rateId", OvernightIborSwapCurveNode.class, ObservableId.class);
        private final MetaProperty<Double> additionalSpread = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"additionalSpread", OvernightIborSwapCurveNode.class, Double.TYPE);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", OvernightIborSwapCurveNode.class, String.class);
        private final MetaProperty<CurveNodeDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", OvernightIborSwapCurveNode.class, CurveNodeDate.class);
        private final MetaProperty<CurveNodeDateOrder> dateOrder = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dateOrder", OvernightIborSwapCurveNode.class, CurveNodeDateOrder.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"template", "rateId", "additionalSpread", "label", "date", "dateOrder"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case -938107365: {
                    return this.rateId;
                }
                case 291232890: {
                    return this.additionalSpread;
                }
                case 102727412: {
                    return this.label;
                }
                case 3076014: {
                    return this.date;
                }
                case -263699392: {
                    return this.dateOrder;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends OvernightIborSwapCurveNode> beanType() {
            return OvernightIborSwapCurveNode.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<OvernightIborSwapTemplate> template() {
            return this.template;
        }

        public MetaProperty<ObservableId> rateId() {
            return this.rateId;
        }

        public MetaProperty<Double> additionalSpread() {
            return this.additionalSpread;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        public MetaProperty<CurveNodeDate> date() {
            return this.date;
        }

        public MetaProperty<CurveNodeDateOrder> dateOrder() {
            return this.dateOrder;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return ((OvernightIborSwapCurveNode)bean).getTemplate();
                }
                case -938107365: {
                    return ((OvernightIborSwapCurveNode)bean).getRateId();
                }
                case 291232890: {
                    return ((OvernightIborSwapCurveNode)bean).getAdditionalSpread();
                }
                case 102727412: {
                    return ((OvernightIborSwapCurveNode)bean).getLabel();
                }
                case 3076014: {
                    return ((OvernightIborSwapCurveNode)bean).getDate();
                }
                case -263699392: {
                    return ((OvernightIborSwapCurveNode)bean).getDateOrder();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

