/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.node;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveNode;
import com.opengamma.strata.market.curve.CurveNodeDate;
import com.opengamma.strata.market.curve.CurveNodeDateOrder;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import com.opengamma.strata.market.param.YearMonthDateParameterMetadata;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.index.OvernightFutureTrade;
import com.opengamma.strata.product.index.ResolvedOvernightFutureTrade;
import com.opengamma.strata.product.index.type.OvernightFutureTemplate;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class OvernightFutureCurveNode
implements CurveNode,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final OvernightFutureTemplate template;
    @PropertyDefinition(validate="notNull")
    private final QuoteId rateId;
    @PropertyDefinition
    private final double additionalSpread;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String label;
    @PropertyDefinition
    private final CurveNodeDate date;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveNodeDateOrder dateOrder;
    private static final long serialVersionUID = 1L;

    public static OvernightFutureCurveNode of(OvernightFutureTemplate template, QuoteId rateId) {
        return OvernightFutureCurveNode.of(template, rateId, 0.0);
    }

    public static OvernightFutureCurveNode of(OvernightFutureTemplate template, QuoteId rateId, double additionalSpread) {
        return OvernightFutureCurveNode.of(template, rateId, additionalSpread, "");
    }

    public static OvernightFutureCurveNode of(OvernightFutureTemplate template, QuoteId rateId, double additionalSpread, String label) {
        return new OvernightFutureCurveNode(template, rateId, additionalSpread, label, CurveNodeDate.END, CurveNodeDateOrder.DEFAULT);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.date = CurveNodeDate.END;
        builder.dateOrder = CurveNodeDateOrder.DEFAULT;
    }

    public Set<ObservableId> requirements() {
        return ImmutableSet.of((Object)this.rateId);
    }

    @Override
    public LocalDate date(LocalDate valuationDate, ReferenceData refData) {
        LocalDate lastFixingDate = this.template.calculateLastFixingDateFromTradeDate(valuationDate, refData);
        return this.date.calculate(() -> this.template.getIndex().calculateMaturityFromEffective(lastFixingDate, refData), () -> lastFixingDate);
    }

    @Override
    public DatedParameterMetadata metadata(LocalDate valuationDate, ReferenceData refData) {
        LocalDate nodeDate = this.date(valuationDate, refData);
        LocalDate referenceDate = this.template.calculateReferenceDateFromTradeDate(valuationDate, refData);
        if (this.label.isEmpty()) {
            return YearMonthDateParameterMetadata.of(nodeDate, YearMonth.from(referenceDate));
        }
        return YearMonthDateParameterMetadata.of(nodeDate, YearMonth.from(referenceDate), this.label);
    }

    public OvernightFutureTrade trade(double quantity, MarketData marketData, ReferenceData refData) {
        LocalDate valuationDate = marketData.getValuationDate();
        double price = this.marketPrice(marketData) + this.additionalSpread;
        SecurityId secId = SecurityId.of((StandardId)this.rateId.getStandardId());
        return this.template.createTrade(valuationDate, secId, quantity, price, refData);
    }

    public ResolvedOvernightFutureTrade resolvedTrade(double quantity, MarketData marketData, ReferenceData refData) {
        return this.trade(quantity, marketData, refData).resolve(refData);
    }

    public ResolvedOvernightFutureTrade sampleResolvedTrade(LocalDate valuationDate, FxRateProvider fxProvider, ReferenceData refData) {
        SecurityId secId = SecurityId.of((StandardId)this.rateId.getStandardId());
        OvernightFutureTrade trade = this.template.createTrade(valuationDate, secId, 1.0, 1.0, refData);
        return trade.resolve(refData);
    }

    @Override
    public double initialGuess(MarketData marketData, ValueType valueType) {
        double rate = 1.0 - this.marketPrice(marketData);
        if (ValueType.ZERO_RATE.equals((Object)valueType) || ValueType.FORWARD_RATE.equals((Object)valueType)) {
            return rate;
        }
        if (ValueType.DISCOUNT_FACTOR.equals((Object)valueType)) {
            return 1.0;
        }
        return 0.0;
    }

    private double marketPrice(MarketData marketData) {
        double price = (Double)marketData.getValue((MarketDataId)this.rateId);
        ArgChecker.isTrue((price < 2.0 ? 1 : 0) != 0, (String)"Price must be in decimal form, such as 0.993 for a 0.7% rate, but was: {}", (double)price);
        return price;
    }

    public OvernightFutureCurveNode withDate(CurveNodeDate date) {
        return new OvernightFutureCurveNode(this.template, this.rateId, this.additionalSpread, this.label, date, this.dateOrder);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OvernightFutureCurveNode(OvernightFutureTemplate template, QuoteId rateId, double additionalSpread, String label, CurveNodeDate date, CurveNodeDateOrder dateOrder) {
        JodaBeanUtils.notNull((Object)template, (String)"template");
        JodaBeanUtils.notNull((Object)rateId, (String)"rateId");
        JodaBeanUtils.notNull((Object)label, (String)"label");
        JodaBeanUtils.notNull((Object)dateOrder, (String)"dateOrder");
        this.template = template;
        this.rateId = rateId;
        this.additionalSpread = additionalSpread;
        this.label = label;
        this.date = date;
        this.dateOrder = dateOrder;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public OvernightFutureTemplate getTemplate() {
        return this.template;
    }

    public QuoteId getRateId() {
        return this.rateId;
    }

    public double getAdditionalSpread() {
        return this.additionalSpread;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public CurveNodeDate getDate() {
        return this.date;
    }

    @Override
    public CurveNodeDateOrder getDateOrder() {
        return this.dateOrder;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightFutureCurveNode other = (OvernightFutureCurveNode)obj;
            return JodaBeanUtils.equal((Object)this.template, (Object)other.template) && JodaBeanUtils.equal((Object)this.rateId, (Object)other.rateId) && JodaBeanUtils.equal((double)this.additionalSpread, (double)other.additionalSpread) && JodaBeanUtils.equal((Object)this.label, (Object)other.label) && JodaBeanUtils.equal((Object)this.date, (Object)other.date) && JodaBeanUtils.equal((Object)this.dateOrder, (Object)other.dateOrder);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.template);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rateId);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.additionalSpread);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dateOrder);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("OvernightFutureCurveNode{");
        buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
        buf.append("rateId").append('=').append(JodaBeanUtils.toString((Object)this.rateId)).append(',').append(' ');
        buf.append("additionalSpread").append('=').append(JodaBeanUtils.toString((Object)this.additionalSpread)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
        buf.append("dateOrder").append('=').append(JodaBeanUtils.toString((Object)this.dateOrder));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<OvernightFutureCurveNode> {
        private OvernightFutureTemplate template;
        private QuoteId rateId;
        private double additionalSpread;
        private String label;
        private CurveNodeDate date;
        private CurveNodeDateOrder dateOrder;

        private Builder() {
            OvernightFutureCurveNode.applyDefaults(this);
        }

        private Builder(OvernightFutureCurveNode beanToCopy) {
            this.template = beanToCopy.getTemplate();
            this.rateId = beanToCopy.getRateId();
            this.additionalSpread = beanToCopy.getAdditionalSpread();
            this.label = beanToCopy.getLabel();
            this.date = beanToCopy.getDate();
            this.dateOrder = beanToCopy.getDateOrder();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case -938107365: {
                    return this.rateId;
                }
                case 291232890: {
                    return this.additionalSpread;
                }
                case 102727412: {
                    return this.label;
                }
                case 3076014: {
                    return this.date;
                }
                case -263699392: {
                    return this.dateOrder;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    this.template = (OvernightFutureTemplate)newValue;
                    break;
                }
                case -938107365: {
                    this.rateId = (QuoteId)newValue;
                    break;
                }
                case 291232890: {
                    this.additionalSpread = (Double)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                case 3076014: {
                    this.date = (CurveNodeDate)newValue;
                    break;
                }
                case -263699392: {
                    this.dateOrder = (CurveNodeDateOrder)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public OvernightFutureCurveNode build() {
            return new OvernightFutureCurveNode(this.template, this.rateId, this.additionalSpread, this.label, this.date, this.dateOrder);
        }

        public Builder template(OvernightFutureTemplate template) {
            JodaBeanUtils.notNull((Object)template, (String)"template");
            this.template = template;
            return this;
        }

        public Builder rateId(QuoteId rateId) {
            JodaBeanUtils.notNull((Object)rateId, (String)"rateId");
            this.rateId = rateId;
            return this;
        }

        public Builder additionalSpread(double additionalSpread) {
            this.additionalSpread = additionalSpread;
            return this;
        }

        public Builder label(String label) {
            JodaBeanUtils.notNull((Object)label, (String)"label");
            this.label = label;
            return this;
        }

        public Builder date(CurveNodeDate date) {
            this.date = date;
            return this;
        }

        public Builder dateOrder(CurveNodeDateOrder dateOrder) {
            JodaBeanUtils.notNull((Object)dateOrder, (String)"dateOrder");
            this.dateOrder = dateOrder;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("OvernightFutureCurveNode.Builder{");
            buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
            buf.append("rateId").append('=').append(JodaBeanUtils.toString((Object)this.rateId)).append(',').append(' ');
            buf.append("additionalSpread").append('=').append(JodaBeanUtils.toString((Object)this.additionalSpread)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
            buf.append("dateOrder").append('=').append(JodaBeanUtils.toString((Object)this.dateOrder));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<OvernightFutureTemplate> template = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"template", OvernightFutureCurveNode.class, OvernightFutureTemplate.class);
        private final MetaProperty<QuoteId> rateId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rateId", OvernightFutureCurveNode.class, QuoteId.class);
        private final MetaProperty<Double> additionalSpread = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"additionalSpread", OvernightFutureCurveNode.class, Double.TYPE);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", OvernightFutureCurveNode.class, String.class);
        private final MetaProperty<CurveNodeDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", OvernightFutureCurveNode.class, CurveNodeDate.class);
        private final MetaProperty<CurveNodeDateOrder> dateOrder = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dateOrder", OvernightFutureCurveNode.class, CurveNodeDateOrder.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"template", "rateId", "additionalSpread", "label", "date", "dateOrder"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case -938107365: {
                    return this.rateId;
                }
                case 291232890: {
                    return this.additionalSpread;
                }
                case 102727412: {
                    return this.label;
                }
                case 3076014: {
                    return this.date;
                }
                case -263699392: {
                    return this.dateOrder;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends OvernightFutureCurveNode> beanType() {
            return OvernightFutureCurveNode.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<OvernightFutureTemplate> template() {
            return this.template;
        }

        public MetaProperty<QuoteId> rateId() {
            return this.rateId;
        }

        public MetaProperty<Double> additionalSpread() {
            return this.additionalSpread;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        public MetaProperty<CurveNodeDate> date() {
            return this.date;
        }

        public MetaProperty<CurveNodeDateOrder> dateOrder() {
            return this.dateOrder;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return ((OvernightFutureCurveNode)bean).getTemplate();
                }
                case -938107365: {
                    return ((OvernightFutureCurveNode)bean).getRateId();
                }
                case 291232890: {
                    return ((OvernightFutureCurveNode)bean).getAdditionalSpread();
                }
                case 102727412: {
                    return ((OvernightFutureCurveNode)bean).getLabel();
                }
                case 3076014: {
                    return ((OvernightFutureCurveNode)bean).getDate();
                }
                case -263699392: {
                    return ((OvernightFutureCurveNode)bean).getDateOrder();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

