/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import java.io.Serializable;

final class QuadraticLeftCurveExtrapolator
implements CurveExtrapolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "QuadraticLeft";
    public static final CurveExtrapolator INSTANCE = new QuadraticLeftCurveExtrapolator();
    private static final double EPS = 1.0E-8;

    private QuadraticLeftCurveExtrapolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveExtrapolator bind(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
        return new Bound(xValues, yValues, interpolator);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    implements BoundCurveExtrapolator {
        private final int nodeCount;
        private final double firstXValue;
        private final double firstYValue;
        private final double lastXValue;
        private final double eps;
        private final double leftQuadCoef;
        private final double leftLinCoef;
        private final Supplier<DoubleArray> leftSens;

        Bound(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
            this.nodeCount = xValues.size();
            this.firstXValue = xValues.get(0);
            this.firstYValue = yValues.get(0);
            this.lastXValue = xValues.get(this.nodeCount - 1);
            double gradient = interpolator.firstDerivative(this.firstXValue);
            this.eps = 1.0E-8 * (this.lastXValue - this.firstXValue);
            this.leftQuadCoef = gradient / this.firstXValue - (this.firstYValue - 1.0) / this.firstXValue / this.firstXValue;
            this.leftLinCoef = -gradient + 2.0 * (this.firstYValue - 1.0) / this.firstXValue;
            this.leftSens = Suppliers.memoize(() -> interpolator.parameterSensitivity(this.firstXValue + this.eps));
        }

        @Override
        public double leftExtrapolate(double xValue) {
            if (this.firstXValue == 0.0) {
                throw new IllegalArgumentException("The trivial point at x = 0 is already included");
            }
            return this.leftQuadCoef * xValue * xValue + this.leftLinCoef * xValue + 1.0;
        }

        @Override
        public double leftExtrapolateFirstDerivative(double xValue) {
            if (this.firstXValue == 0.0) {
                throw new IllegalArgumentException("The trivial point at x = 0 is already included");
            }
            return 2.0 * this.leftQuadCoef * xValue + this.leftLinCoef;
        }

        @Override
        public DoubleArray leftExtrapolateParameterSensitivity(double xValue) {
            if (this.firstXValue == 0.0) {
                throw new IllegalArgumentException("The trivial point at x = 0 is already included");
            }
            double[] result = ((DoubleArray)this.leftSens.get()).toArray();
            for (int i = 1; i < this.nodeCount; ++i) {
                double tmp = result[i] * xValue / this.eps;
                result[i] = tmp / this.firstXValue * xValue - tmp;
            }
            double tmp = (result[0] - 1.0) / this.eps;
            result[0] = (tmp / this.firstXValue - 1.0 / this.firstXValue / this.firstXValue) * xValue * xValue + (2.0 / this.firstXValue - tmp) * xValue;
            return DoubleArray.ofUnsafe((double[])result);
        }

        @Override
        public double rightExtrapolate(double xValue) {
            throw new IllegalArgumentException("QuadraticLeft extrapolator cannot be used for right extrapolation");
        }

        @Override
        public double rightExtrapolateFirstDerivative(double xValue) {
            throw new IllegalArgumentException("QuadraticLeft extrapolator cannot be used for right extrapolation");
        }

        @Override
        public DoubleArray rightExtrapolateParameterSensitivity(double xValue) {
            throw new IllegalArgumentException("QuadraticLeft extrapolator cannot be used for right extrapolation");
        }
    }
}

