/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.math.impl.function.PiecewisePolynomialWithSensitivityFunction1D;
import com.opengamma.strata.math.impl.interpolation.LinearInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.io.Serializable;

final class ProductLinearCurveInterpolator
implements CurveInterpolator,
Serializable {
    public static final String NAME = "ProductLinear";
    public static final CurveInterpolator INSTANCE = new ProductLinearCurveInterpolator();
    private static final long serialVersionUID = 1L;
    private static final double SMALL = 1.0E-10;
    private static final PiecewisePolynomialWithSensitivityFunction1D FUNCTION = new PiecewisePolynomialWithSensitivityFunction1D();

    private ProductLinearCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final PiecewisePolynomialResult poly;
        private final Supplier<PiecewisePolynomialResultsWithSensitivity> polySens;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            ArgChecker.isTrue((xValues.get(0) > 0.0 || xValues.get(xValues.size() - 1) < 0.0 ? 1 : 0) != 0, (String)"xValues must have the same sign");
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            LinearInterpolator underlying = new LinearInterpolator();
            this.poly = underlying.interpolate(xValues.toArray(), Bound.getProduct(this.xValues, this.yValues));
            this.polySens = Suppliers.memoize(() -> underlying.interpolateWithSensitivity(xValues.toArray(), Bound.getProduct(this.xValues, this.yValues)));
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.poly = base.poly;
            this.polySens = base.polySens;
        }

        private static double[] getProduct(double[] xValues, double[] yValues) {
            int nData = yValues.length;
            double[] xyValues = new double[nData];
            for (int i = 0; i < nData; ++i) {
                xyValues[i] = xValues[i] * yValues[i];
            }
            return xyValues;
        }

        @Override
        protected double doInterpolate(double xValue) {
            ArgChecker.isTrue((Math.abs(xValue) > 1.0E-10 ? 1 : 0) != 0, (String)"magnitude of xValue must not be small");
            double resValue = FUNCTION.evaluate(this.poly, xValue).get(0);
            return resValue / xValue;
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            ArgChecker.isTrue((Math.abs(xValue) > 1.0E-10 ? 1 : 0) != 0, (String)"magnitude of xValue must not be small");
            ValueDerivatives resValue = FUNCTION.evaluateAndDifferentiate(this.poly, xValue);
            return -resValue.getValue() / (xValue * xValue) + resValue.getDerivative(0) / xValue;
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            ArgChecker.isTrue((Math.abs(xValue) > 1.0E-10 ? 1 : 0) != 0, (String)"magnitude of xValue must not be small");
            DoubleArray resSense = FUNCTION.nodeSensitivity((PiecewisePolynomialResultsWithSensitivity)this.polySens.get(), xValue);
            return resSense.multipliedBy(DoubleArray.of((int)resSense.size(), i -> this.xValues[i] / xValue));
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }
    }
}

