/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.math.impl.FunctionUtils;
import com.opengamma.strata.math.impl.interpolation.NaturalSplineInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import java.io.Serializable;

final class NaturalSplineCurveInterpolator
implements CurveInterpolator,
Serializable {
    public static final String NAME = "NaturalSpline";
    public static final CurveInterpolator INSTANCE = new NaturalSplineCurveInterpolator();
    private static final long serialVersionUID = 1L;
    private static final MatrixAlgebra MA = new OGMatrixAlgebra();

    private NaturalSplineCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final PiecewisePolynomialResult poly;
        private final Supplier<PiecewisePolynomialResultsWithSensitivity> polySens;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            NaturalSplineInterpolator underlying = new NaturalSplineInterpolator();
            this.poly = underlying.interpolate(xValues.toArray(), yValues.toArray());
            this.polySens = Suppliers.memoize(() -> Bound.lambda$new$0((PiecewisePolynomialInterpolator)underlying, xValues, yValues));
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.poly = base.poly;
            this.polySens = base.polySens;
        }

        private static double evaluate(double xValue, DoubleArray knots, DoubleMatrix coefMatrix, int dimensions) {
            int lowerBound = FunctionUtils.getLowerBoundIndex((DoubleArray)knots, (double)xValue);
            int indicator = lowerBound == knots.size() - 1 ? lowerBound - 1 : lowerBound;
            DoubleArray coefs = coefMatrix.row(dimensions * indicator);
            return Bound.getValue(coefs.toArrayUnsafe(), xValue, knots.get(indicator));
        }

        private static double differentiate(double xValue, DoubleArray knots, DoubleMatrix coefMatrix, int dimensions, int nCoefs, int numberOfIntervals) {
            int rowCount = dimensions * numberOfIntervals;
            int colCount = nCoefs - 1;
            DoubleMatrix coef = DoubleMatrix.of((int)rowCount, (int)colCount, (i, j) -> coefMatrix.get(i, j) * (double)(nCoefs - j - 1));
            return Bound.evaluate(xValue, knots, coef, dimensions);
        }

        private static double getValue(double[] coefs, double x, double leftknot) {
            int nCoefs = coefs.length;
            double s = x - leftknot;
            double res = coefs[0];
            for (int i = 1; i < nCoefs; ++i) {
                res *= s;
                res += coefs[i];
            }
            return res;
        }

        @Override
        protected double doInterpolate(double xValue) {
            return Bound.evaluate(xValue, this.poly.getKnots(), this.poly.getCoefMatrix(), this.poly.getDimensions());
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            int nCoefs = this.poly.getOrder();
            int numberOfIntervals = this.poly.getNumberOfIntervals();
            return Bound.differentiate(xValue, this.poly.getKnots(), this.poly.getCoefMatrix(), this.poly.getDimensions(), nCoefs, numberOfIntervals);
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            int interval = FunctionUtils.getLowerBoundIndex((DoubleArray)this.poly.getKnots(), (double)xValue);
            if (interval == this.poly.getKnots().size() - 1) {
                --interval;
            }
            DoubleMatrix coefficientSensitivity = ((PiecewisePolynomialResultsWithSensitivity)this.polySens.get()).getCoefficientSensitivity(interval);
            int nCoefs = coefficientSensitivity.rowCount();
            double s = xValue - this.poly.getKnots().get(interval);
            DoubleArray res = coefficientSensitivity.row(0);
            for (int i = 1; i < nCoefs; ++i) {
                res = (DoubleArray)MA.scale((Matrix)res, s);
                res = (DoubleArray)MA.add((Matrix)res, (Matrix)coefficientSensitivity.row(i));
            }
            return res;
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }

        private static /* synthetic */ PiecewisePolynomialResultsWithSensitivity lambda$new$0(PiecewisePolynomialInterpolator underlying, DoubleArray xValues, DoubleArray yValues) {
            return underlying.interpolateWithSensitivity(xValues.toArray(), yValues.toArray());
        }
    }
}

