/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import java.io.Serializable;

final class LogLinearCurveExtrapolator
implements CurveExtrapolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "LogLinear";
    public static final CurveExtrapolator INSTANCE = new LogLinearCurveExtrapolator();
    private static final double EPS = 1.0E-8;

    private LogLinearCurveExtrapolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveExtrapolator bind(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
        return new Bound(xValues, yValues, interpolator);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    implements BoundCurveExtrapolator {
        private final int nodeCount;
        private final double firstXValue;
        private final double firstYValue;
        private final double firstYValueLog;
        private final double lastXValue;
        private final double lastYValue;
        private final double lastYValueLog;
        private final double eps;
        private final double leftGradient;
        private final double leftResValueInterpolator;
        private final DoubleArray leftSens;
        private final double rightGradient;
        private final double rightResValueInterpolator;
        private final DoubleArray rightSens;

        Bound(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
            this.nodeCount = xValues.size();
            this.firstXValue = xValues.get(0);
            this.firstYValue = yValues.get(0);
            this.firstYValueLog = Math.log(this.firstYValue);
            this.lastXValue = xValues.get(this.nodeCount - 1);
            this.lastYValue = yValues.get(this.nodeCount - 1);
            this.lastYValueLog = Math.log(this.lastYValue);
            this.eps = 1.0E-8 * (this.lastXValue - this.firstXValue);
            this.leftGradient = interpolator.firstDerivative(this.firstXValue) / interpolator.interpolate(this.firstXValue);
            this.leftResValueInterpolator = interpolator.interpolate(this.firstXValue + this.eps);
            this.leftSens = interpolator.parameterSensitivity(this.firstXValue + this.eps);
            this.rightGradient = interpolator.firstDerivative(this.lastXValue) / interpolator.interpolate(this.lastXValue);
            this.rightResValueInterpolator = interpolator.interpolate(this.lastXValue - this.eps);
            this.rightSens = interpolator.parameterSensitivity(this.lastXValue - this.eps);
        }

        @Override
        public double leftExtrapolate(double xValue) {
            return Math.exp(this.firstYValueLog + (xValue - this.firstXValue) * this.leftGradient);
        }

        @Override
        public double leftExtrapolateFirstDerivative(double xValue) {
            return this.leftGradient * Math.exp(this.firstYValueLog + (xValue - this.firstXValue) * this.leftGradient);
        }

        @Override
        public DoubleArray leftExtrapolateParameterSensitivity(double xValue) {
            double[] result = this.leftSens.toArray();
            double resValueExtrapolator = this.leftExtrapolate(xValue);
            double factor1 = (xValue - this.firstXValue) / this.eps;
            double factor2 = factor1 * resValueExtrapolator / this.leftResValueInterpolator;
            int n = result.length;
            int i = 1;
            while (i < n) {
                int n2 = i++;
                result[n2] = result[n2] * factor2;
            }
            result[0] = result[0] * factor2 + (1.0 - factor1) * resValueExtrapolator / this.firstYValue;
            return DoubleArray.ofUnsafe((double[])result);
        }

        @Override
        public double rightExtrapolate(double xValue) {
            return Math.exp(this.lastYValueLog + (xValue - this.lastXValue) * this.rightGradient);
        }

        @Override
        public double rightExtrapolateFirstDerivative(double xValue) {
            return this.rightGradient * Math.exp(this.lastYValueLog + (xValue - this.lastXValue) * this.rightGradient);
        }

        @Override
        public DoubleArray rightExtrapolateParameterSensitivity(double xValue) {
            double[] result = this.rightSens.toArray();
            double resValueExtrapolator = this.rightExtrapolate(xValue);
            double factor1 = (xValue - this.lastXValue) / this.eps;
            double factor2 = factor1 * resValueExtrapolator / this.rightResValueInterpolator;
            int n = result.length;
            int i = 0;
            while (i < n - 1) {
                int n2 = i++;
                result[n2] = result[n2] * -factor2;
            }
            result[n - 1] = (1.0 + factor1) * resValueExtrapolator / this.lastYValue - result[n - 1] * factor2;
            return DoubleArray.ofUnsafe((double[])result);
        }
    }
}

