/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import java.io.Serializable;

final class LinearCurveInterpolator
implements CurveInterpolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Linear";
    public static final CurveInterpolator INSTANCE = new LinearCurveInterpolator();

    private LinearCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final int intervalCount;
        private final double[] gradients;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            this.intervalCount = xValues.size() - 1;
            this.gradients = new double[this.intervalCount];
            for (int i = 0; i < this.intervalCount; ++i) {
                double gradient;
                double x1 = xValues.get(i);
                double y1 = yValues.get(i);
                double x2 = xValues.get(i + 1);
                double y2 = yValues.get(i + 1);
                this.gradients[i] = gradient = (y2 - y1) / (x2 - x1);
            }
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.intervalCount = base.intervalCount;
            this.gradients = base.gradients;
        }

        @Override
        protected double doInterpolate(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            double x1 = this.xValues[lowerIndex];
            double y1 = this.yValues[lowerIndex];
            return y1 + (xValue - x1) * this.gradients[lowerIndex];
        }

        @Override
        protected double doInterpolateFromExtrapolator(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            if (lowerIndex == this.intervalCount) {
                --lowerIndex;
            }
            double x1 = this.xValues[lowerIndex];
            double y1 = this.yValues[lowerIndex];
            return y1 + (xValue - x1) * this.gradients[lowerIndex];
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            if (lowerIndex == this.intervalCount) {
                --lowerIndex;
            }
            return this.gradients[lowerIndex];
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            double[] result = new double[this.yValues.length];
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            if (lowerIndex == this.intervalCount) {
                result[this.intervalCount] = 1.0;
            } else {
                double a;
                double x1 = this.xValues[lowerIndex];
                double x2 = this.xValues[lowerIndex + 1];
                double dx = x2 - x1;
                result[lowerIndex] = a = (x2 - xValue) / dx;
                result[lowerIndex + 1] = 1.0 - a;
            }
            return DoubleArray.ofUnsafe((double[])result);
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }
    }
}

