/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import java.io.Serializable;

final class FlatCurveExtrapolator
implements CurveExtrapolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Flat";
    public static final CurveExtrapolator INSTANCE = new FlatCurveExtrapolator();

    private FlatCurveExtrapolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveExtrapolator bind(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    implements BoundCurveExtrapolator {
        private final int nodeCount;
        private final double firstYValue;
        private final double lastYValue;
        private final DoubleArray leftSensitivity;
        private final DoubleArray rightSensitivity;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            this.nodeCount = xValues.size();
            this.firstYValue = yValues.get(0);
            this.lastYValue = yValues.get(this.nodeCount - 1);
            double[] left = new double[this.nodeCount];
            left[0] = 1.0;
            this.leftSensitivity = DoubleArray.ofUnsafe((double[])left);
            double[] right = new double[this.nodeCount];
            right[this.nodeCount - 1] = 1.0;
            this.rightSensitivity = DoubleArray.ofUnsafe((double[])right);
        }

        @Override
        public double leftExtrapolate(double xValue) {
            return this.firstYValue;
        }

        @Override
        public double leftExtrapolateFirstDerivative(double xValue) {
            return 0.0;
        }

        @Override
        public DoubleArray leftExtrapolateParameterSensitivity(double xValue) {
            return this.leftSensitivity;
        }

        @Override
        public double rightExtrapolate(double xValue) {
            return this.lastYValue;
        }

        @Override
        public double rightExtrapolateFirstDerivative(double xValue) {
            return 0.0;
        }

        @Override
        public DoubleArray rightExtrapolateParameterSensitivity(double xValue) {
            return this.rightSensitivity;
        }
    }
}

