/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.math.impl.function.RealPolynomialFunction1D;
import com.opengamma.strata.math.impl.interpolation.WeightingFunction;
import com.opengamma.strata.math.impl.interpolation.WeightingFunctions;
import java.io.Serializable;

final class DoubleQuadraticCurveInterpolator
implements CurveInterpolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "DoubleQuadratic";
    public static final CurveInterpolator INSTANCE = new DoubleQuadraticCurveInterpolator();
    private static final WeightingFunction WEIGHT_FUNCTION = WeightingFunctions.LINEAR;

    private DoubleQuadraticCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final int intervalCount;
        private final RealPolynomialFunction1D[] quadratics;
        private final Supplier<RealPolynomialFunction1D[]> quadraticsFirstDerivative;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            this.intervalCount = xValues.size() - 1;
            this.quadratics = Bound.quadratics(this.xValues, this.yValues, this.intervalCount);
            this.quadraticsFirstDerivative = Suppliers.memoize(() -> Bound.quadraticsFirstDerivative(this.xValues, this.yValues, this.intervalCount));
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.intervalCount = base.intervalCount;
            this.quadratics = base.quadratics;
            this.quadraticsFirstDerivative = base.quadraticsFirstDerivative;
        }

        private static RealPolynomialFunction1D[] quadratics(double[] x, double[] y, int intervalCount) {
            if (intervalCount == 1) {
                double a = y[1];
                double b = (y[1] - y[0]) / (x[1] - x[0]);
                return new RealPolynomialFunction1D[]{new RealPolynomialFunction1D(new double[]{a, b})};
            }
            RealPolynomialFunction1D[] quadratic = new RealPolynomialFunction1D[intervalCount - 1];
            for (int i = 1; i < intervalCount; ++i) {
                quadratic[i - 1] = Bound.quadratic(x, y, i);
            }
            return quadratic;
        }

        private static RealPolynomialFunction1D quadratic(double[] x, double[] y, int index) {
            double a = y[index];
            double dx1 = x[index] - x[index - 1];
            double dx2 = x[index + 1] - x[index];
            double dy1 = y[index] - y[index - 1];
            double dy2 = y[index + 1] - y[index];
            double b = (dx1 * dy2 / dx2 + dx2 * dy1 / dx1) / (dx1 + dx2);
            double c = (dy2 / dx2 - dy1 / dx1) / (dx1 + dx2);
            return new RealPolynomialFunction1D(new double[]{a, b, c});
        }

        private static RealPolynomialFunction1D[] quadraticsFirstDerivative(double[] x, double[] y, int intervalCount) {
            if (intervalCount == 1) {
                double b = (y[1] - y[0]) / (x[1] - x[0]);
                return new RealPolynomialFunction1D[]{new RealPolynomialFunction1D(new double[]{b})};
            }
            RealPolynomialFunction1D[] quadraticFirstDerivative = new RealPolynomialFunction1D[intervalCount - 1];
            for (int i = 1; i < intervalCount; ++i) {
                quadraticFirstDerivative[i - 1] = Bound.quadraticFirstDerivative(x, y, i);
            }
            return quadraticFirstDerivative;
        }

        private static RealPolynomialFunction1D quadraticFirstDerivative(double[] x, double[] y, int index) {
            double dx1 = x[index] - x[index - 1];
            double dx2 = x[index + 1] - x[index];
            double dy1 = y[index] - y[index - 1];
            double dy2 = y[index + 1] - y[index];
            double b = (dx1 * dy2 / dx2 + dx2 * dy1 / dx1) / (dx1 + dx2);
            double c = (dy2 / dx2 - dy1 / dx1) / (dx1 + dx2);
            return new RealPolynomialFunction1D(new double[]{b, 2.0 * c});
        }

        @Override
        protected double doInterpolate(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            int higherIndex = lowerIndex + 1;
            if (lowerIndex == 0) {
                RealPolynomialFunction1D quadratic = this.quadratics[0];
                double x = xValue - this.xValues[1];
                return quadratic.applyAsDouble(x);
            }
            if (higherIndex == this.intervalCount) {
                RealPolynomialFunction1D quadratic = this.quadratics[this.intervalCount - 2];
                double x = xValue - this.xValues[this.intervalCount - 1];
                return quadratic.applyAsDouble(x);
            }
            RealPolynomialFunction1D quadratic1 = this.quadratics[lowerIndex - 1];
            RealPolynomialFunction1D quadratic2 = this.quadratics[higherIndex - 1];
            double w = WEIGHT_FUNCTION.getWeight((this.xValues[higherIndex] - xValue) / (this.xValues[higherIndex] - this.xValues[lowerIndex]));
            return w * quadratic1.applyAsDouble(xValue - this.xValues[lowerIndex]) + (1.0 - w) * quadratic2.applyAsDouble(xValue - this.xValues[higherIndex]);
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            int higherIndex = lowerIndex + 1;
            RealPolynomialFunction1D[] quadFirstDerivative = (RealPolynomialFunction1D[])this.quadraticsFirstDerivative.get();
            if (lowerIndex == 0 || this.intervalCount == 1) {
                RealPolynomialFunction1D quadraticFirstDerivative = quadFirstDerivative[0];
                double x = xValue - this.xValues[1];
                return quadraticFirstDerivative.applyAsDouble(x);
            }
            if (higherIndex >= this.intervalCount) {
                RealPolynomialFunction1D quadraticFirstDerivative = quadFirstDerivative[this.intervalCount - 2];
                double x = xValue - this.xValues[this.intervalCount - 1];
                return quadraticFirstDerivative.applyAsDouble(x);
            }
            RealPolynomialFunction1D quadratic1 = this.quadratics[lowerIndex - 1];
            RealPolynomialFunction1D quadratic2 = this.quadratics[higherIndex - 1];
            RealPolynomialFunction1D quadratic1FirstDerivative = quadFirstDerivative[lowerIndex - 1];
            RealPolynomialFunction1D quadratic2FirstDerivative = quadFirstDerivative[higherIndex - 1];
            double w = WEIGHT_FUNCTION.getWeight((this.xValues[higherIndex] - xValue) / (this.xValues[higherIndex] - this.xValues[lowerIndex]));
            return w * quadratic1FirstDerivative.applyAsDouble(xValue - this.xValues[lowerIndex]) + (1.0 - w) * quadratic2FirstDerivative.applyAsDouble(xValue - this.xValues[higherIndex]) + (quadratic2.applyAsDouble(xValue - this.xValues[higherIndex]) - quadratic1.applyAsDouble(xValue - this.xValues[lowerIndex])) / (this.xValues[higherIndex] - this.xValues[lowerIndex]);
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            int higherIndex = lowerIndex + 1;
            int n = this.xValues.length;
            double[] result = new double[n];
            if (lowerIndex == 0) {
                double[] temp = Bound.quadraticSensitivities(this.xValues, xValue, 1);
                result[0] = temp[0];
                result[1] = temp[1];
                result[2] = temp[2];
                return DoubleArray.ofUnsafe((double[])result);
            }
            if (higherIndex == this.intervalCount) {
                double[] temp = Bound.quadraticSensitivities(this.xValues, xValue, n - 2);
                result[n - 3] = temp[0];
                result[n - 2] = temp[1];
                result[n - 1] = temp[2];
                return DoubleArray.ofUnsafe((double[])result);
            }
            if (lowerIndex == this.intervalCount) {
                result[n - 1] = 1.0;
                return DoubleArray.ofUnsafe((double[])result);
            }
            double[] temp1 = Bound.quadraticSensitivities(this.xValues, xValue, lowerIndex);
            double[] temp2 = Bound.quadraticSensitivities(this.xValues, xValue, higherIndex);
            double w = WEIGHT_FUNCTION.getWeight((this.xValues[higherIndex] - xValue) / (this.xValues[higherIndex] - this.xValues[lowerIndex]));
            result[lowerIndex - 1] = w * temp1[0];
            result[lowerIndex] = w * temp1[1] + (1.0 - w) * temp2[0];
            result[higherIndex] = w * temp1[2] + (1.0 - w) * temp2[1];
            result[higherIndex + 1] = (1.0 - w) * temp2[2];
            return DoubleArray.ofUnsafe((double[])result);
        }

        private static double[] quadraticSensitivities(double[] xValues, double x, int i) {
            double[] result = new double[3];
            double deltaX = x - xValues[i];
            double h1 = xValues[i] - xValues[i - 1];
            double h2 = xValues[i + 1] - xValues[i];
            result[0] = deltaX * (deltaX - h2) / h1 / (h1 + h2);
            result[1] = 1.0 + deltaX * (h2 - h1 - deltaX) / h1 / h2;
            result[2] = deltaX * (h1 + deltaX) / (h1 + h2) / h2;
            return result;
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }
    }
}

