/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.market.curve.CurveMetadata;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class RatesCurveInputs
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", builderType="Map<? extends MarketDataId<?>, ?>")
    private final ImmutableMap<? extends MarketDataId<?>, ?> marketData;
    @PropertyDefinition(validate="notNull")
    private final CurveMetadata curveMetadata;
    private static final long serialVersionUID = 1L;

    public static RatesCurveInputs of(Map<? extends MarketDataId<?>, ?> marketData, CurveMetadata metadata) {
        return new RatesCurveInputs(marketData, metadata);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private RatesCurveInputs(Map<? extends MarketDataId<?>, ?> marketData, CurveMetadata curveMetadata) {
        JodaBeanUtils.notNull(marketData, (String)"marketData");
        JodaBeanUtils.notNull((Object)curveMetadata, (String)"curveMetadata");
        this.marketData = ImmutableMap.copyOf(marketData);
        this.curveMetadata = curveMetadata;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableMap<? extends MarketDataId<?>, ?> getMarketData() {
        return this.marketData;
    }

    public CurveMetadata getCurveMetadata() {
        return this.curveMetadata;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RatesCurveInputs other = (RatesCurveInputs)obj;
            return JodaBeanUtils.equal(this.marketData, other.marketData) && JodaBeanUtils.equal((Object)this.curveMetadata, (Object)other.curveMetadata);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.marketData);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curveMetadata);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("RatesCurveInputs{");
        buf.append("marketData").append('=').append(JodaBeanUtils.toString(this.marketData)).append(',').append(' ');
        buf.append("curveMetadata").append('=').append(JodaBeanUtils.toString((Object)this.curveMetadata));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<RatesCurveInputs> {
        private Map<? extends MarketDataId<?>, ?> marketData = ImmutableMap.of();
        private CurveMetadata curveMetadata;

        private Builder() {
        }

        private Builder(RatesCurveInputs beanToCopy) {
            this.marketData = beanToCopy.getMarketData();
            this.curveMetadata = beanToCopy.getCurveMetadata();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1116764678: {
                    return this.marketData;
                }
                case 278233406: {
                    return this.curveMetadata;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1116764678: {
                    this.marketData = (Map)newValue;
                    break;
                }
                case 278233406: {
                    this.curveMetadata = (CurveMetadata)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public RatesCurveInputs build() {
            return new RatesCurveInputs(this.marketData, this.curveMetadata);
        }

        public Builder marketData(Map<? extends MarketDataId<?>, ?> marketData) {
            JodaBeanUtils.notNull(marketData, (String)"marketData");
            this.marketData = marketData;
            return this;
        }

        public Builder curveMetadata(CurveMetadata curveMetadata) {
            JodaBeanUtils.notNull((Object)curveMetadata, (String)"curveMetadata");
            this.curveMetadata = curveMetadata;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("RatesCurveInputs.Builder{");
            buf.append("marketData").append('=').append(JodaBeanUtils.toString(this.marketData)).append(',').append(' ');
            buf.append("curveMetadata").append('=').append(JodaBeanUtils.toString((Object)this.curveMetadata));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableMap<? extends MarketDataId<?>, ?>> marketData = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"marketData", RatesCurveInputs.class, ImmutableMap.class);
        private final MetaProperty<CurveMetadata> curveMetadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveMetadata", RatesCurveInputs.class, CurveMetadata.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"marketData", "curveMetadata"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1116764678: {
                    return this.marketData;
                }
                case 278233406: {
                    return this.curveMetadata;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends RatesCurveInputs> beanType() {
            return RatesCurveInputs.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableMap<? extends MarketDataId<?>, ?>> marketData() {
            return this.marketData;
        }

        public MetaProperty<CurveMetadata> curveMetadata() {
            return this.curveMetadata;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1116764678: {
                    return ((RatesCurveInputs)bean).getMarketData();
                }
                case 278233406: {
                    return ((RatesCurveInputs)bean).getCurveMetadata();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

