/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.RatesCurveGroup;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light", cacheHashCode=true)
public final class RatesCurveGroupId
implements MarketDataId<RatesCurveGroup>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurveGroupName curveGroupName;
    @PropertyDefinition(validate="notNull")
    private final ObservableSource observableSource;
    private static final TypedMetaBean<RatesCurveGroupId> META_BEAN = LightMetaBean.of(RatesCurveGroupId.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"curveGroupName", "observableSource"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;
    private transient int cacheHashCode;

    public static RatesCurveGroupId of(String groupName) {
        return new RatesCurveGroupId(CurveGroupName.of(groupName), ObservableSource.NONE);
    }

    public static RatesCurveGroupId of(CurveGroupName groupName) {
        return new RatesCurveGroupId(groupName, ObservableSource.NONE);
    }

    public static RatesCurveGroupId of(CurveGroupName groupName, ObservableSource obsSource) {
        return new RatesCurveGroupId(groupName, obsSource);
    }

    public Class<RatesCurveGroup> getMarketDataType() {
        return RatesCurveGroup.class;
    }

    public String toString() {
        return new StringBuilder(32).append("RatesCurveGroupId:").append((Object)this.curveGroupName).append(this.observableSource.equals((Object)ObservableSource.NONE) ? "" : "/" + this.observableSource).toString();
    }

    public static TypedMetaBean<RatesCurveGroupId> meta() {
        return META_BEAN;
    }

    private RatesCurveGroupId(CurveGroupName curveGroupName, ObservableSource observableSource) {
        JodaBeanUtils.notNull((Object)((Object)curveGroupName), (String)"curveGroupName");
        JodaBeanUtils.notNull((Object)observableSource, (String)"observableSource");
        this.curveGroupName = curveGroupName;
        this.observableSource = observableSource;
    }

    public TypedMetaBean<RatesCurveGroupId> metaBean() {
        return META_BEAN;
    }

    public CurveGroupName getCurveGroupName() {
        return this.curveGroupName;
    }

    public ObservableSource getObservableSource() {
        return this.observableSource;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RatesCurveGroupId other = (RatesCurveGroupId)obj;
            return JodaBeanUtils.equal((Object)((Object)this.curveGroupName), (Object)((Object)other.curveGroupName)) && JodaBeanUtils.equal((Object)this.observableSource, (Object)other.observableSource);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.cacheHashCode;
        if (hash == 0) {
            hash = this.getClass().hashCode();
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.curveGroupName));
            this.cacheHashCode = hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableSource);
        }
        return hash;
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

