/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.curve.CurveName;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class RatesCurveGroupEntry
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurveName curveName;
    @PropertyDefinition(validate="notNull")
    private final ImmutableSet<Currency> discountCurrencies;
    @PropertyDefinition(validate="notNull")
    private final ImmutableSet<Index> indices;
    private static final long serialVersionUID = 1L;

    RatesCurveGroupEntry merge(RatesCurveGroupEntry newEntry) {
        if (!this.curveName.equals(newEntry.curveName)) {
            throw new IllegalArgumentException(Messages.format((String)"A CurveGroupEntry can only be merged with an entry with the same curve name. name: {}, other name: {}", (Object[])new Object[]{this.curveName, newEntry.curveName}));
        }
        return RatesCurveGroupEntry.builder().curveName(this.curveName).discountCurrencies((Set<Currency>)Sets.union(this.discountCurrencies, newEntry.discountCurrencies)).indices((Set<Index>)Sets.union(this.indices, newEntry.indices)).build();
    }

    public <T extends Index> ImmutableSet<T> getIndices(Class<T> indexType) {
        return (ImmutableSet)this.indices.stream().filter(indexType::isInstance).map(indexType::cast).collect(Guavate.toImmutableSet());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private RatesCurveGroupEntry(CurveName curveName, Set<Currency> discountCurrencies, Set<Index> indices) {
        JodaBeanUtils.notNull((Object)curveName, (String)"curveName");
        JodaBeanUtils.notNull(discountCurrencies, (String)"discountCurrencies");
        JodaBeanUtils.notNull(indices, (String)"indices");
        this.curveName = curveName;
        this.discountCurrencies = ImmutableSet.copyOf(discountCurrencies);
        this.indices = ImmutableSet.copyOf(indices);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurveName getCurveName() {
        return this.curveName;
    }

    public ImmutableSet<Currency> getDiscountCurrencies() {
        return this.discountCurrencies;
    }

    public ImmutableSet<Index> getIndices() {
        return this.indices;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RatesCurveGroupEntry other = (RatesCurveGroupEntry)obj;
            return JodaBeanUtils.equal((Object)this.curveName, (Object)other.curveName) && JodaBeanUtils.equal(this.discountCurrencies, other.discountCurrencies) && JodaBeanUtils.equal(this.indices, other.indices);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curveName);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.discountCurrencies);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.indices);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("RatesCurveGroupEntry{");
        buf.append("curveName").append('=').append(JodaBeanUtils.toString((Object)this.curveName)).append(',').append(' ');
        buf.append("discountCurrencies").append('=').append(JodaBeanUtils.toString(this.discountCurrencies)).append(',').append(' ');
        buf.append("indices").append('=').append(JodaBeanUtils.toString(this.indices));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<RatesCurveGroupEntry> {
        private CurveName curveName;
        private Set<Currency> discountCurrencies = ImmutableSet.of();
        private Set<Index> indices = ImmutableSet.of();

        private Builder() {
        }

        private Builder(RatesCurveGroupEntry beanToCopy) {
            this.curveName = beanToCopy.getCurveName();
            this.discountCurrencies = beanToCopy.getDiscountCurrencies();
            this.indices = beanToCopy.getIndices();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 771153946: {
                    return this.curveName;
                }
                case -538086256: {
                    return this.discountCurrencies;
                }
                case 1943391143: {
                    return this.indices;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 771153946: {
                    this.curveName = (CurveName)newValue;
                    break;
                }
                case -538086256: {
                    this.discountCurrencies = (Set)newValue;
                    break;
                }
                case 1943391143: {
                    this.indices = (Set)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public RatesCurveGroupEntry build() {
            return new RatesCurveGroupEntry(this.curveName, this.discountCurrencies, this.indices);
        }

        public Builder curveName(CurveName curveName) {
            JodaBeanUtils.notNull((Object)curveName, (String)"curveName");
            this.curveName = curveName;
            return this;
        }

        public Builder discountCurrencies(Set<Currency> discountCurrencies) {
            JodaBeanUtils.notNull(discountCurrencies, (String)"discountCurrencies");
            this.discountCurrencies = discountCurrencies;
            return this;
        }

        public Builder discountCurrencies(Currency ... discountCurrencies) {
            return this.discountCurrencies((Set<Currency>)ImmutableSet.copyOf((Object[])discountCurrencies));
        }

        public Builder indices(Set<Index> indices) {
            JodaBeanUtils.notNull(indices, (String)"indices");
            this.indices = indices;
            return this;
        }

        public Builder indices(Index ... indices) {
            return this.indices((Set<Index>)ImmutableSet.copyOf((Object[])indices));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("RatesCurveGroupEntry.Builder{");
            buf.append("curveName").append('=').append(JodaBeanUtils.toString((Object)this.curveName)).append(',').append(' ');
            buf.append("discountCurrencies").append('=').append(JodaBeanUtils.toString(this.discountCurrencies)).append(',').append(' ');
            buf.append("indices").append('=').append(JodaBeanUtils.toString(this.indices));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveName> curveName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveName", RatesCurveGroupEntry.class, CurveName.class);
        private final MetaProperty<ImmutableSet<Currency>> discountCurrencies = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountCurrencies", RatesCurveGroupEntry.class, ImmutableSet.class);
        private final MetaProperty<ImmutableSet<Index>> indices = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"indices", RatesCurveGroupEntry.class, ImmutableSet.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"curveName", "discountCurrencies", "indices"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 771153946: {
                    return this.curveName;
                }
                case -538086256: {
                    return this.discountCurrencies;
                }
                case 1943391143: {
                    return this.indices;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends RatesCurveGroupEntry> beanType() {
            return RatesCurveGroupEntry.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveName> curveName() {
            return this.curveName;
        }

        public MetaProperty<ImmutableSet<Currency>> discountCurrencies() {
            return this.discountCurrencies;
        }

        public MetaProperty<ImmutableSet<Index>> indices() {
            return this.indices;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 771153946: {
                    return ((RatesCurveGroupEntry)bean).getCurveName();
                }
                case -538086256: {
                    return ((RatesCurveGroupEntry)bean).getDiscountCurrencies();
                }
                case 1943391143: {
                    return ((RatesCurveGroupEntry)bean).getIndices();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

