/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.curve.CurveDefinition;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.RatesCurveGroupDefinition;
import com.opengamma.strata.market.curve.RatesCurveGroupEntry;
import com.opengamma.strata.market.curve.SeasonalityDefinition;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class RatesCurveGroupDefinitionBuilder {
    private CurveGroupName name;
    private final Map<CurveName, RatesCurveGroupEntry> entries;
    private final Map<CurveName, CurveDefinition> curveDefinitions;
    private final Map<CurveName, SeasonalityDefinition> seasonalityDefinitions;
    private boolean computeJacobian = true;
    private boolean computePvSensitivityToMarketQuote;

    RatesCurveGroupDefinitionBuilder() {
        this.entries = new LinkedHashMap<CurveName, RatesCurveGroupEntry>();
        this.curveDefinitions = new LinkedHashMap<CurveName, CurveDefinition>();
        this.seasonalityDefinitions = new LinkedHashMap<CurveName, SeasonalityDefinition>();
    }

    RatesCurveGroupDefinitionBuilder(CurveGroupName name, Map<CurveName, RatesCurveGroupEntry> entries, Map<CurveName, CurveDefinition> curveDefinitions, Map<CurveName, SeasonalityDefinition> seasonalityDefinitions, boolean computeJacobian, boolean computePvSensitivityToMarketQuote) {
        this.name = name;
        this.entries = new LinkedHashMap<CurveName, RatesCurveGroupEntry>(entries);
        this.curveDefinitions = new LinkedHashMap<CurveName, CurveDefinition>(curveDefinitions);
        this.seasonalityDefinitions = new LinkedHashMap<CurveName, SeasonalityDefinition>(seasonalityDefinitions);
        this.computeJacobian = computeJacobian;
        this.computePvSensitivityToMarketQuote = computePvSensitivityToMarketQuote;
    }

    public RatesCurveGroupDefinitionBuilder name(CurveGroupName name) {
        this.name = (CurveGroupName)((Object)ArgChecker.notNull((Object)((Object)name), (String)"name"));
        return this;
    }

    public RatesCurveGroupDefinitionBuilder computeJacobian(boolean computeJacobian) {
        this.computeJacobian = computeJacobian;
        return this;
    }

    public RatesCurveGroupDefinitionBuilder computePvSensitivityToMarketQuote(boolean computePvSensitivityToMarketQuote) {
        this.computePvSensitivityToMarketQuote = computePvSensitivityToMarketQuote;
        return this;
    }

    public RatesCurveGroupDefinitionBuilder addDiscountCurve(CurveDefinition curveDefinition, Currency currency, Currency ... otherCurrencies) {
        ArgChecker.notNull((Object)curveDefinition, (String)"curveDefinition");
        ArgChecker.notNull((Object)currency, (String)"currency");
        RatesCurveGroupEntry entry = RatesCurveGroupEntry.builder().curveName(curveDefinition.getName()).discountCurrencies((Set<Currency>)ImmutableSet.copyOf((Collection)Lists.asList((Object)currency, (Object[])otherCurrencies))).build();
        return this.merge(entry, curveDefinition);
    }

    public RatesCurveGroupDefinitionBuilder addDiscountCurve(CurveName curveName, Currency currency, Currency ... otherCurrencies) {
        ArgChecker.notNull((Object)curveName, (String)"curveName");
        ArgChecker.notNull((Object)currency, (String)"currency");
        RatesCurveGroupEntry entry = RatesCurveGroupEntry.builder().curveName(curveName).discountCurrencies((Set<Currency>)ImmutableSet.copyOf((Collection)Lists.asList((Object)currency, (Object[])otherCurrencies))).build();
        return this.mergeEntry(entry);
    }

    public RatesCurveGroupDefinitionBuilder addForwardCurve(CurveDefinition curveDefinition, Index index, Index ... otherIndices) {
        ArgChecker.notNull((Object)curveDefinition, (String)"curveDefinition");
        ArgChecker.notNull((Object)index, (String)"index");
        RatesCurveGroupEntry entry = RatesCurveGroupEntry.builder().curveName(curveDefinition.getName()).indices(RatesCurveGroupDefinitionBuilder.indices(index, otherIndices)).build();
        return this.merge(entry, curveDefinition);
    }

    public RatesCurveGroupDefinitionBuilder addForwardCurve(CurveName curveName, Index index, Index ... otherIndices) {
        ArgChecker.notNull((Object)curveName, (String)"curveName");
        ArgChecker.notNull((Object)index, (String)"index");
        RatesCurveGroupEntry entry = RatesCurveGroupEntry.builder().curveName(curveName).indices(RatesCurveGroupDefinitionBuilder.indices(index, otherIndices)).build();
        return this.mergeEntry(entry);
    }

    public RatesCurveGroupDefinitionBuilder addCurve(CurveDefinition curveDefinition, Currency currency, RateIndex index, RateIndex ... otherIndices) {
        ArgChecker.notNull((Object)curveDefinition, (String)"curveDefinition");
        ArgChecker.notNull((Object)currency, (String)"currency");
        ArgChecker.notNull((Object)index, (String)"index");
        RatesCurveGroupEntry entry = RatesCurveGroupEntry.builder().curveName(curveDefinition.getName()).discountCurrencies((Set<Currency>)ImmutableSet.of((Object)currency)).indices(RatesCurveGroupDefinitionBuilder.indices((Index)index, (Index[])otherIndices)).build();
        return this.merge(entry, curveDefinition);
    }

    public RatesCurveGroupDefinitionBuilder addCurve(CurveName curveName, Currency currency, RateIndex index, RateIndex ... otherIndices) {
        RatesCurveGroupEntry entry = RatesCurveGroupEntry.builder().curveName(curveName).discountCurrencies((Set<Currency>)ImmutableSet.of((Object)currency)).indices(RatesCurveGroupDefinitionBuilder.indices((Index)index, (Index[])otherIndices)).build();
        return this.mergeEntry(entry);
    }

    public RatesCurveGroupDefinitionBuilder addSeasonality(CurveName curveName, SeasonalityDefinition seasonalityDefinition) {
        this.seasonalityDefinitions.put(curveName, seasonalityDefinition);
        return this;
    }

    private RatesCurveGroupDefinitionBuilder merge(RatesCurveGroupEntry newEntry, CurveDefinition curveDefinition) {
        this.curveDefinitions.put(curveDefinition.getName(), curveDefinition);
        return this.mergeEntry(newEntry);
    }

    private RatesCurveGroupDefinitionBuilder mergeEntry(RatesCurveGroupEntry newEntry) {
        CurveName curveName = newEntry.getCurveName();
        RatesCurveGroupEntry existingEntry = this.entries.get(curveName);
        RatesCurveGroupEntry entry = existingEntry == null ? newEntry : existingEntry.merge(newEntry);
        this.entries.put(curveName, entry);
        return this;
    }

    private static Set<Index> indices(Index index, Index ... otherIndices) {
        return ImmutableSet.builder().add((Object)index).add((Object[])otherIndices).build();
    }

    public RatesCurveGroupDefinition build() {
        return new RatesCurveGroupDefinition(this.name, this.entries.values(), this.curveDefinitions.values(), this.seasonalityDefinitions, this.computeJacobian || this.computePvSensitivityToMarketQuote, this.computePvSensitivityToMarketQuote);
    }
}

