/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.FloatingRateIndex;
import com.opengamma.strata.basics.index.FloatingRateName;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.market.curve.CurveDefinition;
import com.opengamma.strata.market.curve.CurveGroupDefinition;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.InflationNodalCurveDefinition;
import com.opengamma.strata.market.curve.NodalCurveDefinition;
import com.opengamma.strata.market.curve.RatesCurveGroupDefinitionBuilder;
import com.opengamma.strata.market.curve.RatesCurveGroupEntry;
import com.opengamma.strata.market.curve.RatesCurveGroupId;
import com.opengamma.strata.market.curve.SeasonalityDefinition;
import com.opengamma.strata.product.ResolvedTrade;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class RatesCurveGroupDefinition
implements CurveGroupDefinition,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveGroupName name;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<RatesCurveGroupEntry> entries;
    @PropertyDefinition(validate="notNull", builderType="List<? extends CurveDefinition>")
    private final ImmutableList<CurveDefinition> curveDefinitions;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<CurveName, SeasonalityDefinition> seasonalityDefinitions;
    @PropertyDefinition
    private final boolean computeJacobian;
    @PropertyDefinition
    private final boolean computePvSensitivityToMarketQuote;
    private final transient ImmutableMap<CurveName, RatesCurveGroupEntry> entriesByName;
    private final transient ImmutableMap<CurveName, CurveDefinition> curveDefinitionsByName;
    private static final long serialVersionUID = 1L;

    public static RatesCurveGroupDefinitionBuilder builder() {
        return new RatesCurveGroupDefinitionBuilder();
    }

    public static RatesCurveGroupDefinition of(CurveGroupName name, Collection<RatesCurveGroupEntry> entries, Collection<CurveDefinition> curveDefinitions) {
        return new RatesCurveGroupDefinition(name, entries, curveDefinitions, (Map<CurveName, SeasonalityDefinition>)ImmutableMap.of(), true, false);
    }

    public static RatesCurveGroupDefinition of(CurveGroupName name, Collection<RatesCurveGroupEntry> entries, Collection<CurveDefinition> curveDefinitions, Map<CurveName, SeasonalityDefinition> seasonalityDefinitions) {
        return new RatesCurveGroupDefinition(name, entries, curveDefinitions, seasonalityDefinitions, true, false);
    }

    @ImmutableConstructor
    RatesCurveGroupDefinition(CurveGroupName name, Collection<RatesCurveGroupEntry> entries, Collection<? extends CurveDefinition> curveDefinitions, Map<CurveName, SeasonalityDefinition> seasonalityDefinitions, boolean computeJacobian, boolean computePvSensitivityToMarketQuote) {
        this.name = (CurveGroupName)((Object)ArgChecker.notNull((Object)((Object)name), (String)"name"));
        this.entries = ImmutableList.copyOf(entries);
        this.curveDefinitions = ImmutableList.copyOf(curveDefinitions);
        this.entriesByName = (ImmutableMap)entries.stream().collect(Guavate.toImmutableMap(entry -> entry.getCurveName(), entry -> entry));
        this.curveDefinitionsByName = (ImmutableMap)curveDefinitions.stream().collect(Guavate.toImmutableMap(def -> def.getName(), def -> def));
        this.computeJacobian = computeJacobian;
        this.computePvSensitivityToMarketQuote = computePvSensitivityToMarketQuote;
        this.seasonalityDefinitions = ImmutableMap.copyOf(seasonalityDefinitions);
        this.validate();
    }

    @ImmutableValidator
    private void validate() {
        Sets.SetView missingEntries = Sets.difference((Set)this.curveDefinitionsByName.keySet(), (Set)this.entriesByName.keySet());
        if (!missingEntries.isEmpty()) {
            throw new IllegalArgumentException("An entry must be provided for every curve definition but the following curves have a definition but no entry: " + missingEntries);
        }
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.computePvSensitivityToMarketQuote) {
            builder.computeJacobian = true;
        }
    }

    private Object readResolve() {
        return new RatesCurveGroupDefinition(this.name, (Collection<RatesCurveGroupEntry>)this.entries, (Collection<? extends CurveDefinition>)this.curveDefinitions, (Map<CurveName, SeasonalityDefinition>)this.seasonalityDefinitions, this.computeJacobian, this.computePvSensitivityToMarketQuote);
    }

    public RatesCurveGroupId createGroupId(ObservableSource source) {
        return RatesCurveGroupId.of(this.name, source);
    }

    public RatesCurveGroupDefinition filtered(LocalDate valuationDate, ReferenceData refData) {
        List filtered = (List)this.curveDefinitions.stream().map(ncd -> ncd.filtered(valuationDate, refData)).collect(Guavate.toImmutableList());
        return new RatesCurveGroupDefinition(this.name, (Collection<RatesCurveGroupEntry>)this.entries, filtered, (Map<CurveName, SeasonalityDefinition>)this.seasonalityDefinitions, this.computeJacobian, this.computePvSensitivityToMarketQuote);
    }

    public RatesCurveGroupDefinition bindTimeSeries(LocalDate valuationDate, Map<Index, LocalDateDoubleTimeSeries> tsMap) {
        ImmutableList.Builder boundCurveDefinitions = ImmutableList.builder();
        for (RatesCurveGroupEntry entry : this.entries) {
            CurveName name = entry.getCurveName();
            CurveDefinition curveDef = (CurveDefinition)this.curveDefinitionsByName.get((Object)name);
            ImmutableSet<Index> indices = entry.getIndices();
            boolean containsPriceIndex = indices.stream().anyMatch(i -> i instanceof PriceIndex);
            if (containsPriceIndex) {
                ArgChecker.isTrue((indices.size() == 1 ? 1 : 0) != 0, (String)("Price index curve must not relate to another index or discounting: " + name));
                Index index = (Index)indices.iterator().next();
                LocalDateDoubleTimeSeries ts = tsMap.get(index);
                ArgChecker.notNull((Object)ts, (String)("Price index curve must have associated time-series: " + index.toString()));
                LocalDateDoubleTimeSeries tsPast = ts.subSeries(ts.getEarliestDate(), valuationDate);
                ArgChecker.isFalse((boolean)ts.isEmpty(), (String)("Price index curve must have associated time-series with at least one element in the past:" + index.toString()));
                ArgChecker.isTrue((boolean)(curveDef instanceof NodalCurveDefinition), (String)"curve definition for inflation curve must be NodalCurveDefinition");
                YearMonth lastFixingMonth = YearMonth.from(tsPast.getLatestDate());
                double lastFixingValue = tsPast.getLatestValue();
                InflationNodalCurveDefinition seasonalCurveDef = new InflationNodalCurveDefinition((NodalCurveDefinition)curveDef, lastFixingMonth, lastFixingValue, (SeasonalityDefinition)this.seasonalityDefinitions.get((Object)name));
                boundCurveDefinitions.add((Object)seasonalCurveDef);
                continue;
            }
            boundCurveDefinitions.add((Object)curveDef);
        }
        return this.withCurveDefinitions((List<CurveDefinition>)boundCurveDefinitions.build());
    }

    public Optional<CurveName> findDiscountCurveName(Currency discountCurrency) {
        return this.entries.stream().filter(entry -> entry.getDiscountCurrencies().contains((Object)discountCurrency)).findFirst().map(entry -> entry.getCurveName());
    }

    public Optional<CurveName> findForwardCurveName(Index forwardIndex) {
        return this.entries.stream().filter(entry -> entry.getIndices().contains((Object)forwardIndex)).findFirst().map(entry -> entry.getCurveName());
    }

    public ImmutableSet<CurveName> findForwardCurveNames(FloatingRateName forwardName) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        FloatingRateName normalized = forwardName.normalized();
        block0: for (RatesCurveGroupEntry entry : this.entries) {
            for (Index index : entry.getIndices()) {
                FloatingRateName frName;
                if (!(index instanceof FloatingRateIndex) || !(frName = ((FloatingRateIndex)index).getFloatingRateName()).equals(normalized)) continue;
                result.add((Object)entry.getCurveName());
                continue block0;
            }
        }
        return result.build();
    }

    public Optional<RatesCurveGroupEntry> findEntry(CurveName curveName) {
        return Optional.ofNullable(this.entriesByName.get((Object)curveName));
    }

    public Optional<CurveDefinition> findCurveDefinition(CurveName curveName) {
        return Optional.ofNullable(this.curveDefinitionsByName.get((Object)curveName));
    }

    public ImmutableList<CurveMetadata> metadata(LocalDate valuationDate, ReferenceData refData) {
        return (ImmutableList)this.curveDefinitionsByName.values().stream().map(curveDef -> curveDef.metadata(valuationDate, refData)).collect(Guavate.toImmutableList());
    }

    public int getTotalParameterCount() {
        return this.curveDefinitionsByName.entrySet().stream().mapToInt(entry -> ((CurveDefinition)entry.getValue()).getParameterCount()).sum();
    }

    public ImmutableList<ResolvedTrade> resolvedTrades(MarketData marketData, ReferenceData refData) {
        return (ImmutableList)this.curveDefinitionsByName.values().stream().flatMap(curveDef -> curveDef.getNodes().stream()).map(node -> node.resolvedTrade(1.0, marketData, refData)).collect(Guavate.toImmutableList());
    }

    public ImmutableList<Double> initialGuesses(MarketData marketData) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (CurveDefinition defn : this.curveDefinitions) {
            result.addAll(defn.initialGuess(marketData));
        }
        return result.build();
    }

    public RatesCurveGroupDefinition withCurveDefinitions(List<CurveDefinition> curveDefinitions) {
        Set curveNames = this.entries.stream().map(entry -> entry.getCurveName()).collect(Collectors.toSet());
        List filteredDefinitions = (List)curveDefinitions.stream().filter(def -> curveNames.contains(def.getName())).collect(Guavate.toImmutableList());
        return new RatesCurveGroupDefinition(this.name, (Collection<RatesCurveGroupEntry>)this.entries, filteredDefinitions, (Map<CurveName, SeasonalityDefinition>)this.seasonalityDefinitions, this.computeJacobian, this.computePvSensitivityToMarketQuote);
    }

    public RatesCurveGroupDefinition withSeasonalityDefinitions(Map<CurveName, SeasonalityDefinition> seasonalityDefinitions) {
        Set curveNames = this.entries.stream().map(entry -> entry.getCurveName()).collect(Collectors.toSet());
        ImmutableMap filteredDefinitions = MapStream.of(seasonalityDefinitions).filterKeys(cn -> curveNames.contains(cn)).toMap();
        return new RatesCurveGroupDefinition(this.name, (Collection<RatesCurveGroupEntry>)this.entries, (Collection<? extends CurveDefinition>)this.curveDefinitions, (Map<CurveName, SeasonalityDefinition>)filteredDefinitions, this.computeJacobian, this.computePvSensitivityToMarketQuote);
    }

    public RatesCurveGroupDefinition withName(CurveGroupName name) {
        return new RatesCurveGroupDefinition(name, (Collection<RatesCurveGroupEntry>)this.entries, (Collection<? extends CurveDefinition>)this.curveDefinitions, (Map<CurveName, SeasonalityDefinition>)this.seasonalityDefinitions, this.computeJacobian, this.computePvSensitivityToMarketQuote);
    }

    public RatesCurveGroupDefinition combinedWith(RatesCurveGroupDefinition other) {
        LinkedHashMap<CurveName, CurveDefinition> combinedDefinitions = new LinkedHashMap<CurveName, CurveDefinition>((Map<CurveName, CurveDefinition>)this.curveDefinitionsByName);
        for (CurveDefinition otherDefn : other.curveDefinitions) {
            CurveDefinition thisDefn = (CurveDefinition)this.curveDefinitionsByName.get((Object)otherDefn.getName());
            if (thisDefn == null) {
                combinedDefinitions.put(otherDefn.getName(), otherDefn);
                continue;
            }
            if (thisDefn.equals(otherDefn)) continue;
            throw new IllegalArgumentException("Curve definitions clash: " + thisDefn.getName());
        }
        LinkedHashMap<CurveName, RatesCurveGroupEntry> combinedEntries = new LinkedHashMap<CurveName, RatesCurveGroupEntry>((Map<CurveName, RatesCurveGroupEntry>)this.entriesByName);
        for (RatesCurveGroupEntry otherEntry : other.entries) {
            RatesCurveGroupEntry thisEntry = (RatesCurveGroupEntry)this.entriesByName.get((Object)otherEntry.getCurveName());
            if (thisEntry == null) {
                combinedEntries.put(otherEntry.getCurveName(), otherEntry);
                continue;
            }
            combinedEntries.put(otherEntry.getCurveName(), thisEntry.merge(otherEntry));
        }
        LinkedHashMap<CurveName, SeasonalityDefinition> combinedSeasonality = new LinkedHashMap<CurveName, SeasonalityDefinition>((Map<CurveName, SeasonalityDefinition>)this.seasonalityDefinitions);
        for (Map.Entry otherEntry : other.seasonalityDefinitions.entrySet()) {
            SeasonalityDefinition thisDefn = (SeasonalityDefinition)this.seasonalityDefinitions.get(otherEntry.getKey());
            if (thisDefn == null) {
                combinedSeasonality.put((CurveName)otherEntry.getKey(), (SeasonalityDefinition)otherEntry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Curve definitions clash: " + otherEntry.getKey());
        }
        return new RatesCurveGroupDefinition(this.name, combinedEntries.values(), combinedDefinitions.values(), combinedSeasonality, this.computeJacobian | other.computeJacobian, this.computePvSensitivityToMarketQuote | other.computePvSensitivityToMarketQuote);
    }

    public RatesCurveGroupDefinitionBuilder toBuilder() {
        return new RatesCurveGroupDefinitionBuilder(this.name, (Map<CurveName, RatesCurveGroupEntry>)this.entriesByName, (Map<CurveName, CurveDefinition>)this.curveDefinitionsByName, (Map<CurveName, SeasonalityDefinition>)this.seasonalityDefinitions, this.computeJacobian, this.computePvSensitivityToMarketQuote);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveGroupName getName() {
        return this.name;
    }

    public ImmutableList<RatesCurveGroupEntry> getEntries() {
        return this.entries;
    }

    public ImmutableList<CurveDefinition> getCurveDefinitions() {
        return this.curveDefinitions;
    }

    public ImmutableMap<CurveName, SeasonalityDefinition> getSeasonalityDefinitions() {
        return this.seasonalityDefinitions;
    }

    public boolean isComputeJacobian() {
        return this.computeJacobian;
    }

    public boolean isComputePvSensitivityToMarketQuote() {
        return this.computePvSensitivityToMarketQuote;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RatesCurveGroupDefinition other = (RatesCurveGroupDefinition)obj;
            return JodaBeanUtils.equal((Object)((Object)this.name), (Object)((Object)other.name)) && JodaBeanUtils.equal(this.entries, other.entries) && JodaBeanUtils.equal(this.curveDefinitions, other.curveDefinitions) && JodaBeanUtils.equal(this.seasonalityDefinitions, other.seasonalityDefinitions) && this.computeJacobian == other.computeJacobian && this.computePvSensitivityToMarketQuote == other.computePvSensitivityToMarketQuote;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.name));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.entries);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.curveDefinitions);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.seasonalityDefinitions);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.computeJacobian);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.computePvSensitivityToMarketQuote);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("RatesCurveGroupDefinition{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
        buf.append("entries").append('=').append(JodaBeanUtils.toString(this.entries)).append(',').append(' ');
        buf.append("curveDefinitions").append('=').append(JodaBeanUtils.toString(this.curveDefinitions)).append(',').append(' ');
        buf.append("seasonalityDefinitions").append('=').append(JodaBeanUtils.toString(this.seasonalityDefinitions)).append(',').append(' ');
        buf.append("computeJacobian").append('=').append(JodaBeanUtils.toString((Object)this.computeJacobian)).append(',').append(' ');
        buf.append("computePvSensitivityToMarketQuote").append('=').append(JodaBeanUtils.toString((Object)this.computePvSensitivityToMarketQuote));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<RatesCurveGroupDefinition> {
        private CurveGroupName name;
        private List<RatesCurveGroupEntry> entries = ImmutableList.of();
        private List<? extends CurveDefinition> curveDefinitions = ImmutableList.of();
        private Map<CurveName, SeasonalityDefinition> seasonalityDefinitions = ImmutableMap.of();
        private boolean computeJacobian;
        private boolean computePvSensitivityToMarketQuote;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -1591573360: {
                    return this.entries;
                }
                case -336166639: {
                    return this.curveDefinitions;
                }
                case 1051792832: {
                    return this.seasonalityDefinitions;
                }
                case -1730091410: {
                    return this.computeJacobian;
                }
                case -2061625469: {
                    return this.computePvSensitivityToMarketQuote;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (CurveGroupName)((Object)newValue);
                    break;
                }
                case -1591573360: {
                    this.entries = (List)newValue;
                    break;
                }
                case -336166639: {
                    this.curveDefinitions = (List)newValue;
                    break;
                }
                case 1051792832: {
                    this.seasonalityDefinitions = (Map)newValue;
                    break;
                }
                case -1730091410: {
                    this.computeJacobian = (Boolean)newValue;
                    break;
                }
                case -2061625469: {
                    this.computePvSensitivityToMarketQuote = (Boolean)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public RatesCurveGroupDefinition build() {
            RatesCurveGroupDefinition.preBuild(this);
            return new RatesCurveGroupDefinition(this.name, this.entries, this.curveDefinitions, this.seasonalityDefinitions, this.computeJacobian, this.computePvSensitivityToMarketQuote);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("RatesCurveGroupDefinition.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
            buf.append("entries").append('=').append(JodaBeanUtils.toString(this.entries)).append(',').append(' ');
            buf.append("curveDefinitions").append('=').append(JodaBeanUtils.toString(this.curveDefinitions)).append(',').append(' ');
            buf.append("seasonalityDefinitions").append('=').append(JodaBeanUtils.toString(this.seasonalityDefinitions)).append(',').append(' ');
            buf.append("computeJacobian").append('=').append(JodaBeanUtils.toString((Object)this.computeJacobian)).append(',').append(' ');
            buf.append("computePvSensitivityToMarketQuote").append('=').append(JodaBeanUtils.toString((Object)this.computePvSensitivityToMarketQuote));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveGroupName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", RatesCurveGroupDefinition.class, CurveGroupName.class);
        private final MetaProperty<ImmutableList<RatesCurveGroupEntry>> entries = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"entries", RatesCurveGroupDefinition.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<CurveDefinition>> curveDefinitions = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveDefinitions", RatesCurveGroupDefinition.class, ImmutableList.class);
        private final MetaProperty<ImmutableMap<CurveName, SeasonalityDefinition>> seasonalityDefinitions = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"seasonalityDefinitions", RatesCurveGroupDefinition.class, ImmutableMap.class);
        private final MetaProperty<Boolean> computeJacobian = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"computeJacobian", RatesCurveGroupDefinition.class, Boolean.TYPE);
        private final MetaProperty<Boolean> computePvSensitivityToMarketQuote = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"computePvSensitivityToMarketQuote", RatesCurveGroupDefinition.class, Boolean.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "entries", "curveDefinitions", "seasonalityDefinitions", "computeJacobian", "computePvSensitivityToMarketQuote"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -1591573360: {
                    return this.entries;
                }
                case -336166639: {
                    return this.curveDefinitions;
                }
                case 1051792832: {
                    return this.seasonalityDefinitions;
                }
                case -1730091410: {
                    return this.computeJacobian;
                }
                case -2061625469: {
                    return this.computePvSensitivityToMarketQuote;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends RatesCurveGroupDefinition> builder() {
            return new Builder();
        }

        public Class<? extends RatesCurveGroupDefinition> beanType() {
            return RatesCurveGroupDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveGroupName> name() {
            return this.name;
        }

        public MetaProperty<ImmutableList<RatesCurveGroupEntry>> entries() {
            return this.entries;
        }

        public MetaProperty<ImmutableList<CurveDefinition>> curveDefinitions() {
            return this.curveDefinitions;
        }

        public MetaProperty<ImmutableMap<CurveName, SeasonalityDefinition>> seasonalityDefinitions() {
            return this.seasonalityDefinitions;
        }

        public MetaProperty<Boolean> computeJacobian() {
            return this.computeJacobian;
        }

        public MetaProperty<Boolean> computePvSensitivityToMarketQuote() {
            return this.computePvSensitivityToMarketQuote;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((RatesCurveGroupDefinition)bean).getName();
                }
                case -1591573360: {
                    return ((RatesCurveGroupDefinition)bean).getEntries();
                }
                case -336166639: {
                    return ((RatesCurveGroupDefinition)bean).getCurveDefinitions();
                }
                case 1051792832: {
                    return ((RatesCurveGroupDefinition)bean).getSeasonalityDefinitions();
                }
                case -1730091410: {
                    return ((RatesCurveGroupDefinition)bean).isComputeJacobian();
                }
                case -2061625469: {
                    return ((RatesCurveGroupDefinition)bean).isComputePvSensitivityToMarketQuote();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

