/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveGroup;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.RatesCurveGroupDefinition;
import com.opengamma.strata.market.curve.RatesCurveGroupEntry;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BeanDefinition
public final class RatesCurveGroup
implements CurveGroup,
ImmutableBean,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(RatesCurveGroup.class);
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveGroupName name;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Currency, Curve> discountCurves;
    @PropertyDefinition(validate="notNull", builderType="Map<? extends Index, ? extends Curve>")
    private final ImmutableMap<Index, Curve> forwardCurves;
    private static final long serialVersionUID = 1L;

    public static RatesCurveGroup of(CurveGroupName name, Map<Currency, Curve> discountCurves, Map<Index, Curve> forwardCurves) {
        return new RatesCurveGroup(name, discountCurves, forwardCurves);
    }

    public static RatesCurveGroup ofCurves(RatesCurveGroupDefinition curveGroupDefinition, Curve ... curves) {
        return RatesCurveGroup.ofCurves(curveGroupDefinition, Arrays.asList(curves));
    }

    public static RatesCurveGroup ofCurves(RatesCurveGroupDefinition curveGroupDefinition, Collection<? extends Curve> curves) {
        HashMap<Currency, Curve> discountCurves = new HashMap<Currency, Curve>();
        HashMap<Index, Curve> forwardCurves = new HashMap<Index, Curve>();
        Map<CurveName, Curve> curveMap = curves.stream().collect(Collectors.toMap(curve -> curve.getMetadata().getCurveName(), curve -> curve, (curve1, curve2) -> curve1));
        for (RatesCurveGroupEntry entry : curveGroupDefinition.getEntries()) {
            CurveName curveName = entry.getCurveName();
            Curve curve3 = curveMap.get(curveName);
            if (curve3 == null) {
                log.debug("No curve found named '{}' when building curve group '{}'", (Object)curveName, (Object)curveGroupDefinition.getName());
                continue;
            }
            for (Currency currency : entry.getDiscountCurrencies()) {
                discountCurves.put(currency, curve3);
            }
            for (Index index : entry.getIndices()) {
                forwardCurves.put(index, curve3);
            }
        }
        return RatesCurveGroup.of(curveGroupDefinition.getName(), discountCurves, forwardCurves);
    }

    @Override
    public Optional<Curve> findCurve(CurveName name) {
        return Stream.concat(this.discountCurves.values().stream(), this.forwardCurves.values().stream()).filter(c -> c.getName().equals(name)).findFirst();
    }

    public Optional<Curve> findDiscountCurve(Currency currency) {
        return Optional.ofNullable(this.discountCurves.get((Object)currency));
    }

    public Optional<Curve> findForwardCurve(Index index) {
        return Optional.ofNullable(this.forwardCurves.get((Object)index));
    }

    @Override
    public Stream<Curve> stream() {
        return Stream.concat(this.discountCurves.values().stream(), this.forwardCurves.values().stream());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private RatesCurveGroup(CurveGroupName name, Map<Currency, Curve> discountCurves, Map<? extends Index, ? extends Curve> forwardCurves) {
        JodaBeanUtils.notNull((Object)((Object)name), (String)"name");
        JodaBeanUtils.notNull(discountCurves, (String)"discountCurves");
        JodaBeanUtils.notNull(forwardCurves, (String)"forwardCurves");
        this.name = name;
        this.discountCurves = ImmutableMap.copyOf(discountCurves);
        this.forwardCurves = ImmutableMap.copyOf(forwardCurves);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveGroupName getName() {
        return this.name;
    }

    public ImmutableMap<Currency, Curve> getDiscountCurves() {
        return this.discountCurves;
    }

    public ImmutableMap<Index, Curve> getForwardCurves() {
        return this.forwardCurves;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RatesCurveGroup other = (RatesCurveGroup)obj;
            return JodaBeanUtils.equal((Object)((Object)this.name), (Object)((Object)other.name)) && JodaBeanUtils.equal(this.discountCurves, other.discountCurves) && JodaBeanUtils.equal(this.forwardCurves, other.forwardCurves);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.name));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.discountCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.forwardCurves);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("RatesCurveGroup{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
        buf.append("discountCurves").append('=').append(JodaBeanUtils.toString(this.discountCurves)).append(',').append(' ');
        buf.append("forwardCurves").append('=').append(JodaBeanUtils.toString(this.forwardCurves));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<RatesCurveGroup> {
        private CurveGroupName name;
        private Map<Currency, Curve> discountCurves = ImmutableMap.of();
        private Map<? extends Index, ? extends Curve> forwardCurves = ImmutableMap.of();

        private Builder() {
        }

        private Builder(RatesCurveGroup beanToCopy) {
            this.name = beanToCopy.getName();
            this.discountCurves = beanToCopy.getDiscountCurves();
            this.forwardCurves = beanToCopy.getForwardCurves();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -624113147: {
                    return this.discountCurves;
                }
                case -850086775: {
                    return this.forwardCurves;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (CurveGroupName)((Object)newValue);
                    break;
                }
                case -624113147: {
                    this.discountCurves = (Map)newValue;
                    break;
                }
                case -850086775: {
                    this.forwardCurves = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public RatesCurveGroup build() {
            return new RatesCurveGroup(this.name, this.discountCurves, this.forwardCurves);
        }

        public Builder name(CurveGroupName name) {
            JodaBeanUtils.notNull((Object)((Object)name), (String)"name");
            this.name = name;
            return this;
        }

        public Builder discountCurves(Map<Currency, Curve> discountCurves) {
            JodaBeanUtils.notNull(discountCurves, (String)"discountCurves");
            this.discountCurves = discountCurves;
            return this;
        }

        public Builder forwardCurves(Map<? extends Index, ? extends Curve> forwardCurves) {
            JodaBeanUtils.notNull(forwardCurves, (String)"forwardCurves");
            this.forwardCurves = forwardCurves;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("RatesCurveGroup.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
            buf.append("discountCurves").append('=').append(JodaBeanUtils.toString(this.discountCurves)).append(',').append(' ');
            buf.append("forwardCurves").append('=').append(JodaBeanUtils.toString(this.forwardCurves));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveGroupName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", RatesCurveGroup.class, CurveGroupName.class);
        private final MetaProperty<ImmutableMap<Currency, Curve>> discountCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountCurves", RatesCurveGroup.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<Index, Curve>> forwardCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"forwardCurves", RatesCurveGroup.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "discountCurves", "forwardCurves"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -624113147: {
                    return this.discountCurves;
                }
                case -850086775: {
                    return this.forwardCurves;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends RatesCurveGroup> beanType() {
            return RatesCurveGroup.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveGroupName> name() {
            return this.name;
        }

        public MetaProperty<ImmutableMap<Currency, Curve>> discountCurves() {
            return this.discountCurves;
        }

        public MetaProperty<ImmutableMap<Index, Curve>> forwardCurves() {
            return this.forwardCurves;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((RatesCurveGroup)bean).getName();
                }
                case -624113147: {
                    return ((RatesCurveGroup)bean).getDiscountCurves();
                }
                case -850086775: {
                    return ((RatesCurveGroup)bean).getForwardCurves();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

