/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ParameterizedFunctionalCurve
implements Curve,
ImmutableBean {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveMetadata metadata;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray parameters;
    @PropertyDefinition(validate="notNull")
    private final BiFunction<DoubleArray, Double, Double> valueFunction;
    @PropertyDefinition(validate="notNull")
    private final BiFunction<DoubleArray, Double, Double> derivativeFunction;
    @PropertyDefinition(validate="notNull")
    private final BiFunction<DoubleArray, Double, DoubleArray> sensitivityFunction;
    private final transient List<ParameterMetadata> parameterMetadata;

    public static ParameterizedFunctionalCurve of(CurveMetadata metadata, DoubleArray parameters, BiFunction<DoubleArray, Double, Double> valueFunction, BiFunction<DoubleArray, Double, Double> derivativeFunction, BiFunction<DoubleArray, Double, DoubleArray> sensitivityFunction) {
        return ParameterizedFunctionalCurve.builder().metadata(metadata).parameters(parameters).valueFunction(valueFunction).derivativeFunction(derivativeFunction).sensitivityFunction(sensitivityFunction).build();
    }

    @ImmutableConstructor
    private ParameterizedFunctionalCurve(CurveMetadata metadata, DoubleArray parameters, BiFunction<DoubleArray, Double, Double> valueFunction, BiFunction<DoubleArray, Double, Double> derivativeFunction, BiFunction<DoubleArray, Double, DoubleArray> sensitivityFunction) {
        JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
        JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
        JodaBeanUtils.notNull(valueFunction, (String)"valueFunction");
        JodaBeanUtils.notNull(derivativeFunction, (String)"derivativeFunction");
        JodaBeanUtils.notNull(sensitivityFunction, (String)"sensitivityFunction");
        this.metadata = metadata;
        this.parameters = parameters;
        this.valueFunction = valueFunction;
        this.derivativeFunction = derivativeFunction;
        this.sensitivityFunction = sensitivityFunction;
        this.parameterMetadata = (List)IntStream.range(0, this.getParameterCount()).mapToObj(i -> this.getParameterMetadata(i)).collect(Guavate.toImmutableList());
    }

    @Override
    public int getParameterCount() {
        return this.parameters.size();
    }

    @Override
    public double getParameter(int parameterIndex) {
        return this.parameters.get(parameterIndex);
    }

    @Override
    public ParameterizedFunctionalCurve withParameter(int parameterIndex, double newValue) {
        return this.withParameters(this.parameters.with(parameterIndex, newValue));
    }

    @Override
    public ParameterizedFunctionalCurve withPerturbation(ParameterPerturbation perturbation) {
        int size = this.parameters.size();
        DoubleArray perturbedValues = DoubleArray.of((int)size, i -> perturbation.perturbParameter(i, this.parameters.get(i), this.getParameterMetadata(i)));
        return this.withParameters(perturbedValues);
    }

    @Override
    public double yValue(double x) {
        return this.valueFunction.apply(this.parameters, x);
    }

    @Override
    public UnitParameterSensitivity yValueParameterSensitivity(double x) {
        return this.createParameterSensitivity(this.sensitivityFunction.apply(this.parameters, x));
    }

    @Override
    public double firstDerivative(double x) {
        return this.derivativeFunction.apply(this.parameters, x);
    }

    @Override
    public ParameterizedFunctionalCurve withMetadata(CurveMetadata metadata) {
        return new ParameterizedFunctionalCurve(metadata, this.parameters, this.valueFunction, this.derivativeFunction, this.sensitivityFunction);
    }

    public ParameterizedFunctionalCurve withParameters(DoubleArray parameters) {
        ArgChecker.isTrue((parameters.size() == this.parameters.size() ? 1 : 0) != 0, (String)"the new parameters size must be the same as the initial parameter size");
        return new ParameterizedFunctionalCurve(this.metadata, parameters, this.valueFunction, this.derivativeFunction, this.sensitivityFunction);
    }

    @Override
    public UnitParameterSensitivity createParameterSensitivity(DoubleArray sensitivities) {
        return UnitParameterSensitivity.of(this.getName(), this.parameterMetadata, sensitivities);
    }

    @Override
    public CurrencyParameterSensitivity createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return CurrencyParameterSensitivity.of(this.getName(), this.parameterMetadata, currency, sensitivities);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveMetadata getMetadata() {
        return this.metadata;
    }

    public DoubleArray getParameters() {
        return this.parameters;
    }

    public BiFunction<DoubleArray, Double, Double> getValueFunction() {
        return this.valueFunction;
    }

    public BiFunction<DoubleArray, Double, Double> getDerivativeFunction() {
        return this.derivativeFunction;
    }

    public BiFunction<DoubleArray, Double, DoubleArray> getSensitivityFunction() {
        return this.sensitivityFunction;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ParameterizedFunctionalCurve other = (ParameterizedFunctionalCurve)obj;
            return JodaBeanUtils.equal((Object)this.metadata, (Object)other.metadata) && JodaBeanUtils.equal((Object)this.parameters, (Object)other.parameters) && JodaBeanUtils.equal(this.valueFunction, other.valueFunction) && JodaBeanUtils.equal(this.derivativeFunction, other.derivativeFunction) && JodaBeanUtils.equal(this.sensitivityFunction, other.sensitivityFunction);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.metadata);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.parameters);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.valueFunction);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.derivativeFunction);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.sensitivityFunction);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("ParameterizedFunctionalCurve{");
        buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
        buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters)).append(',').append(' ');
        buf.append("valueFunction").append('=').append(JodaBeanUtils.toString(this.valueFunction)).append(',').append(' ');
        buf.append("derivativeFunction").append('=').append(JodaBeanUtils.toString(this.derivativeFunction)).append(',').append(' ');
        buf.append("sensitivityFunction").append('=').append(JodaBeanUtils.toString(this.sensitivityFunction));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ParameterizedFunctionalCurve> {
        private CurveMetadata metadata;
        private DoubleArray parameters;
        private BiFunction<DoubleArray, Double, Double> valueFunction;
        private BiFunction<DoubleArray, Double, Double> derivativeFunction;
        private BiFunction<DoubleArray, Double, DoubleArray> sensitivityFunction;

        private Builder() {
        }

        private Builder(ParameterizedFunctionalCurve beanToCopy) {
            this.metadata = beanToCopy.getMetadata();
            this.parameters = beanToCopy.getParameters();
            this.valueFunction = beanToCopy.getValueFunction();
            this.derivativeFunction = beanToCopy.getDerivativeFunction();
            this.sensitivityFunction = beanToCopy.getSensitivityFunction();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case 458736106: {
                    return this.parameters;
                }
                case 636119145: {
                    return this.valueFunction;
                }
                case 1663351423: {
                    return this.derivativeFunction;
                }
                case -1353652329: {
                    return this.sensitivityFunction;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    this.metadata = (CurveMetadata)newValue;
                    break;
                }
                case 458736106: {
                    this.parameters = (DoubleArray)newValue;
                    break;
                }
                case 636119145: {
                    this.valueFunction = (BiFunction)newValue;
                    break;
                }
                case 1663351423: {
                    this.derivativeFunction = (BiFunction)newValue;
                    break;
                }
                case -1353652329: {
                    this.sensitivityFunction = (BiFunction)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ParameterizedFunctionalCurve build() {
            return new ParameterizedFunctionalCurve(this.metadata, this.parameters, this.valueFunction, this.derivativeFunction, this.sensitivityFunction);
        }

        public Builder metadata(CurveMetadata metadata) {
            JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
            this.metadata = metadata;
            return this;
        }

        public Builder parameters(DoubleArray parameters) {
            JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
            this.parameters = parameters;
            return this;
        }

        public Builder valueFunction(BiFunction<DoubleArray, Double, Double> valueFunction) {
            JodaBeanUtils.notNull(valueFunction, (String)"valueFunction");
            this.valueFunction = valueFunction;
            return this;
        }

        public Builder derivativeFunction(BiFunction<DoubleArray, Double, Double> derivativeFunction) {
            JodaBeanUtils.notNull(derivativeFunction, (String)"derivativeFunction");
            this.derivativeFunction = derivativeFunction;
            return this;
        }

        public Builder sensitivityFunction(BiFunction<DoubleArray, Double, DoubleArray> sensitivityFunction) {
            JodaBeanUtils.notNull(sensitivityFunction, (String)"sensitivityFunction");
            this.sensitivityFunction = sensitivityFunction;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ParameterizedFunctionalCurve.Builder{");
            buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
            buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters)).append(',').append(' ');
            buf.append("valueFunction").append('=').append(JodaBeanUtils.toString(this.valueFunction)).append(',').append(' ');
            buf.append("derivativeFunction").append('=').append(JodaBeanUtils.toString(this.derivativeFunction)).append(',').append(' ');
            buf.append("sensitivityFunction").append('=').append(JodaBeanUtils.toString(this.sensitivityFunction));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveMetadata> metadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"metadata", ParameterizedFunctionalCurve.class, CurveMetadata.class);
        private final MetaProperty<DoubleArray> parameters = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameters", ParameterizedFunctionalCurve.class, DoubleArray.class);
        private final MetaProperty<BiFunction<DoubleArray, Double, Double>> valueFunction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valueFunction", ParameterizedFunctionalCurve.class, BiFunction.class);
        private final MetaProperty<BiFunction<DoubleArray, Double, Double>> derivativeFunction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"derivativeFunction", ParameterizedFunctionalCurve.class, BiFunction.class);
        private final MetaProperty<BiFunction<DoubleArray, Double, DoubleArray>> sensitivityFunction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivityFunction", ParameterizedFunctionalCurve.class, BiFunction.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"metadata", "parameters", "valueFunction", "derivativeFunction", "sensitivityFunction"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case 458736106: {
                    return this.parameters;
                }
                case 636119145: {
                    return this.valueFunction;
                }
                case 1663351423: {
                    return this.derivativeFunction;
                }
                case -1353652329: {
                    return this.sensitivityFunction;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ParameterizedFunctionalCurve> beanType() {
            return ParameterizedFunctionalCurve.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveMetadata> metadata() {
            return this.metadata;
        }

        public MetaProperty<DoubleArray> parameters() {
            return this.parameters;
        }

        public MetaProperty<BiFunction<DoubleArray, Double, Double>> valueFunction() {
            return this.valueFunction;
        }

        public MetaProperty<BiFunction<DoubleArray, Double, Double>> derivativeFunction() {
            return this.derivativeFunction;
        }

        public MetaProperty<BiFunction<DoubleArray, Double, DoubleArray>> sensitivityFunction() {
            return this.sensitivityFunction;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return ((ParameterizedFunctionalCurve)bean).getMetadata();
                }
                case 458736106: {
                    return ((ParameterizedFunctionalCurve)bean).getParameters();
                }
                case 636119145: {
                    return ((ParameterizedFunctionalCurve)bean).getValueFunction();
                }
                case 1663351423: {
                    return ((ParameterizedFunctionalCurve)bean).getDerivativeFunction();
                }
                case -1353652329: {
                    return ((ParameterizedFunctionalCurve)bean).getSensitivityFunction();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

