/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveGroup;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.LegalEntityGroup;
import com.opengamma.strata.market.curve.RepoGroup;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class LegalEntityCurveGroup
implements CurveGroup,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveGroupName name;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Pair<RepoGroup, Currency>, Curve> repoCurves;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Pair<LegalEntityGroup, Currency>, Curve> issuerCurves;
    private static final long serialVersionUID = 1L;

    public static LegalEntityCurveGroup of(CurveGroupName name, Map<Pair<RepoGroup, Currency>, Curve> repoCurves, Map<Pair<LegalEntityGroup, Currency>, Curve> issuerCurves) {
        return new LegalEntityCurveGroup(name, repoCurves, issuerCurves);
    }

    @Override
    public Optional<Curve> findCurve(CurveName name) {
        return Stream.concat(this.repoCurves.values().stream(), this.issuerCurves.values().stream()).filter(c -> c.getName().equals(name)).findFirst();
    }

    public Optional<Curve> findRepoCurve(RepoGroup repoGroup, Currency currency) {
        return Optional.ofNullable(this.repoCurves.get((Object)Pair.of((Object)((Object)repoGroup), (Object)currency)));
    }

    public Optional<Curve> findIssuerCurve(LegalEntityGroup legalEntityGroup, Currency currency) {
        return Optional.ofNullable(this.issuerCurves.get((Object)Pair.of((Object)((Object)legalEntityGroup), (Object)currency)));
    }

    @Override
    public Stream<Curve> stream() {
        return Stream.concat(this.repoCurves.values().stream(), this.issuerCurves.values().stream());
    }

    public Stream<Curve> repoCurveStream() {
        return this.repoCurves.values().stream();
    }

    public Stream<Curve> issuerCurveStream() {
        return this.issuerCurves.values().stream();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private LegalEntityCurveGroup(CurveGroupName name, Map<Pair<RepoGroup, Currency>, Curve> repoCurves, Map<Pair<LegalEntityGroup, Currency>, Curve> issuerCurves) {
        JodaBeanUtils.notNull((Object)((Object)name), (String)"name");
        JodaBeanUtils.notNull(repoCurves, (String)"repoCurves");
        JodaBeanUtils.notNull(issuerCurves, (String)"issuerCurves");
        this.name = name;
        this.repoCurves = ImmutableMap.copyOf(repoCurves);
        this.issuerCurves = ImmutableMap.copyOf(issuerCurves);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveGroupName getName() {
        return this.name;
    }

    public ImmutableMap<Pair<RepoGroup, Currency>, Curve> getRepoCurves() {
        return this.repoCurves;
    }

    public ImmutableMap<Pair<LegalEntityGroup, Currency>, Curve> getIssuerCurves() {
        return this.issuerCurves;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            LegalEntityCurveGroup other = (LegalEntityCurveGroup)obj;
            return JodaBeanUtils.equal((Object)((Object)this.name), (Object)((Object)other.name)) && JodaBeanUtils.equal(this.repoCurves, other.repoCurves) && JodaBeanUtils.equal(this.issuerCurves, other.issuerCurves);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.name));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.repoCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.issuerCurves);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("LegalEntityCurveGroup{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
        buf.append("repoCurves").append('=').append(JodaBeanUtils.toString(this.repoCurves)).append(',').append(' ');
        buf.append("issuerCurves").append('=').append(JodaBeanUtils.toString(this.issuerCurves));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<LegalEntityCurveGroup> {
        private CurveGroupName name;
        private Map<Pair<RepoGroup, Currency>, Curve> repoCurves = ImmutableMap.of();
        private Map<Pair<LegalEntityGroup, Currency>, Curve> issuerCurves = ImmutableMap.of();

        private Builder() {
        }

        private Builder(LegalEntityCurveGroup beanToCopy) {
            this.name = beanToCopy.getName();
            this.repoCurves = beanToCopy.getRepoCurves();
            this.issuerCurves = beanToCopy.getIssuerCurves();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 587630454: {
                    return this.repoCurves;
                }
                case -1909076611: {
                    return this.issuerCurves;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (CurveGroupName)((Object)newValue);
                    break;
                }
                case 587630454: {
                    this.repoCurves = (Map)newValue;
                    break;
                }
                case -1909076611: {
                    this.issuerCurves = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public LegalEntityCurveGroup build() {
            return new LegalEntityCurveGroup(this.name, this.repoCurves, this.issuerCurves);
        }

        public Builder name(CurveGroupName name) {
            JodaBeanUtils.notNull((Object)((Object)name), (String)"name");
            this.name = name;
            return this;
        }

        public Builder repoCurves(Map<Pair<RepoGroup, Currency>, Curve> repoCurves) {
            JodaBeanUtils.notNull(repoCurves, (String)"repoCurves");
            this.repoCurves = repoCurves;
            return this;
        }

        public Builder issuerCurves(Map<Pair<LegalEntityGroup, Currency>, Curve> issuerCurves) {
            JodaBeanUtils.notNull(issuerCurves, (String)"issuerCurves");
            this.issuerCurves = issuerCurves;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("LegalEntityCurveGroup.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
            buf.append("repoCurves").append('=').append(JodaBeanUtils.toString(this.repoCurves)).append(',').append(' ');
            buf.append("issuerCurves").append('=').append(JodaBeanUtils.toString(this.issuerCurves));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveGroupName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", LegalEntityCurveGroup.class, CurveGroupName.class);
        private final MetaProperty<ImmutableMap<Pair<RepoGroup, Currency>, Curve>> repoCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"repoCurves", LegalEntityCurveGroup.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<Pair<LegalEntityGroup, Currency>, Curve>> issuerCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"issuerCurves", LegalEntityCurveGroup.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "repoCurves", "issuerCurves"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 587630454: {
                    return this.repoCurves;
                }
                case -1909076611: {
                    return this.issuerCurves;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends LegalEntityCurveGroup> beanType() {
            return LegalEntityCurveGroup.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveGroupName> name() {
            return this.name;
        }

        public MetaProperty<ImmutableMap<Pair<RepoGroup, Currency>, Curve>> repoCurves() {
            return this.repoCurves;
        }

        public MetaProperty<ImmutableMap<Pair<LegalEntityGroup, Currency>, Curve>> issuerCurves() {
            return this.issuerCurves;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((LegalEntityCurveGroup)bean).getName();
                }
                case 587630454: {
                    return ((LegalEntityCurveGroup)bean).getRepoCurves();
                }
                case -1909076611: {
                    return ((LegalEntityCurveGroup)bean).getIssuerCurves();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

