/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.Curves;
import com.opengamma.strata.market.curve.InterpolatedNodalCurve;
import com.opengamma.strata.market.curve.IsdaCreditCurveNode;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolators;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IsdaCreditCurveDefinition
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurveName name;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final LocalDate curveValuationDate;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull", builderType="List<? extends IsdaCreditCurveNode>")
    private final ImmutableList<IsdaCreditCurveNode> curveNodes;
    @PropertyDefinition(validate="notNull")
    private final boolean computeJacobian;
    @PropertyDefinition(validate="notNull")
    private final boolean storeNodeTrade;
    private static final long serialVersionUID = 1L;

    public static IsdaCreditCurveDefinition of(CurveName name, Currency currency, LocalDate curveValuationDate, DayCount dayCount, List<? extends IsdaCreditCurveNode> curveNodes, boolean computeJacobian, boolean storeNodeTrade) {
        return new IsdaCreditCurveDefinition(name, currency, curveValuationDate, dayCount, curveNodes, computeJacobian, storeNodeTrade);
    }

    public InterpolatedNodalCurve curve(DoubleArray yearFractions, DoubleArray zeroRates) {
        CurveMetadata baseMetadata = Curves.zeroRates(this.name, this.dayCount);
        return InterpolatedNodalCurve.of(baseMetadata, yearFractions, zeroRates, CurveInterpolators.PRODUCT_LINEAR, CurveExtrapolators.FLAT, CurveExtrapolators.PRODUCT_LINEAR);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private IsdaCreditCurveDefinition(CurveName name, Currency currency, LocalDate curveValuationDate, DayCount dayCount, List<? extends IsdaCreditCurveNode> curveNodes, boolean computeJacobian, boolean storeNodeTrade) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)curveValuationDate, (String)"curveValuationDate");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull(curveNodes, (String)"curveNodes");
        JodaBeanUtils.notNull((Object)computeJacobian, (String)"computeJacobian");
        JodaBeanUtils.notNull((Object)storeNodeTrade, (String)"storeNodeTrade");
        this.name = name;
        this.currency = currency;
        this.curveValuationDate = curveValuationDate;
        this.dayCount = dayCount;
        this.curveNodes = ImmutableList.copyOf(curveNodes);
        this.computeJacobian = computeJacobian;
        this.storeNodeTrade = storeNodeTrade;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurveName getName() {
        return this.name;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public LocalDate getCurveValuationDate() {
        return this.curveValuationDate;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public ImmutableList<IsdaCreditCurveNode> getCurveNodes() {
        return this.curveNodes;
    }

    public boolean isComputeJacobian() {
        return this.computeJacobian;
    }

    public boolean isStoreNodeTrade() {
        return this.storeNodeTrade;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IsdaCreditCurveDefinition other = (IsdaCreditCurveDefinition)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.curveValuationDate, (Object)other.curveValuationDate) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal(this.curveNodes, other.curveNodes) && this.computeJacobian == other.computeJacobian && this.storeNodeTrade == other.storeNodeTrade;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curveValuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.curveNodes);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.computeJacobian);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.storeNodeTrade);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("IsdaCreditCurveDefinition{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("curveValuationDate").append('=').append(JodaBeanUtils.toString((Object)this.curveValuationDate)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("curveNodes").append('=').append(JodaBeanUtils.toString(this.curveNodes)).append(',').append(' ');
        buf.append("computeJacobian").append('=').append(JodaBeanUtils.toString((Object)this.computeJacobian)).append(',').append(' ');
        buf.append("storeNodeTrade").append('=').append(JodaBeanUtils.toString((Object)this.storeNodeTrade));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IsdaCreditCurveDefinition> {
        private CurveName name;
        private Currency currency;
        private LocalDate curveValuationDate;
        private DayCount dayCount;
        private List<? extends IsdaCreditCurveNode> curveNodes = ImmutableList.of();
        private boolean computeJacobian;
        private boolean storeNodeTrade;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case 318917792: {
                    return this.curveValuationDate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1863622910: {
                    return this.curveNodes;
                }
                case -1730091410: {
                    return this.computeJacobian;
                }
                case 561141921: {
                    return this.storeNodeTrade;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (CurveName)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 318917792: {
                    this.curveValuationDate = (LocalDate)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -1863622910: {
                    this.curveNodes = (List)newValue;
                    break;
                }
                case -1730091410: {
                    this.computeJacobian = (Boolean)newValue;
                    break;
                }
                case 561141921: {
                    this.storeNodeTrade = (Boolean)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IsdaCreditCurveDefinition build() {
            return new IsdaCreditCurveDefinition(this.name, this.currency, this.curveValuationDate, this.dayCount, this.curveNodes, this.computeJacobian, this.storeNodeTrade);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("IsdaCreditCurveDefinition.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("curveValuationDate").append('=').append(JodaBeanUtils.toString((Object)this.curveValuationDate)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("curveNodes").append('=').append(JodaBeanUtils.toString(this.curveNodes)).append(',').append(' ');
            buf.append("computeJacobian").append('=').append(JodaBeanUtils.toString((Object)this.computeJacobian)).append(',').append(' ');
            buf.append("storeNodeTrade").append('=').append(JodaBeanUtils.toString((Object)this.storeNodeTrade));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", IsdaCreditCurveDefinition.class, CurveName.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IsdaCreditCurveDefinition.class, Currency.class);
        private final MetaProperty<LocalDate> curveValuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveValuationDate", IsdaCreditCurveDefinition.class, LocalDate.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", IsdaCreditCurveDefinition.class, DayCount.class);
        private final MetaProperty<ImmutableList<IsdaCreditCurveNode>> curveNodes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveNodes", IsdaCreditCurveDefinition.class, ImmutableList.class);
        private final MetaProperty<Boolean> computeJacobian = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"computeJacobian", IsdaCreditCurveDefinition.class, Boolean.TYPE);
        private final MetaProperty<Boolean> storeNodeTrade = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"storeNodeTrade", IsdaCreditCurveDefinition.class, Boolean.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currency", "curveValuationDate", "dayCount", "curveNodes", "computeJacobian", "storeNodeTrade"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case 318917792: {
                    return this.curveValuationDate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1863622910: {
                    return this.curveNodes;
                }
                case -1730091410: {
                    return this.computeJacobian;
                }
                case 561141921: {
                    return this.storeNodeTrade;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IsdaCreditCurveDefinition> builder() {
            return new Builder();
        }

        public Class<? extends IsdaCreditCurveDefinition> beanType() {
            return IsdaCreditCurveDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveName> name() {
            return this.name;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<LocalDate> curveValuationDate() {
            return this.curveValuationDate;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<ImmutableList<IsdaCreditCurveNode>> curveNodes() {
            return this.curveNodes;
        }

        public MetaProperty<Boolean> computeJacobian() {
            return this.computeJacobian;
        }

        public MetaProperty<Boolean> storeNodeTrade() {
            return this.storeNodeTrade;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((IsdaCreditCurveDefinition)bean).getName();
                }
                case 575402001: {
                    return ((IsdaCreditCurveDefinition)bean).getCurrency();
                }
                case 318917792: {
                    return ((IsdaCreditCurveDefinition)bean).getCurveValuationDate();
                }
                case 1905311443: {
                    return ((IsdaCreditCurveDefinition)bean).getDayCount();
                }
                case -1863622910: {
                    return ((IsdaCreditCurveDefinition)bean).getCurveNodes();
                }
                case -1730091410: {
                    return ((IsdaCreditCurveDefinition)bean).isComputeJacobian();
                }
                case 561141921: {
                    return ((IsdaCreditCurveDefinition)bean).isStoreNodeTrade();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

