/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.CurveNode;
import com.opengamma.strata.market.curve.CurveNodeDateOrder;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.curve.InterpolatedNodalCurve;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.NodalCurveDefinition;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class InterpolatedNodalCurveDefinition
implements NodalCurveDefinition,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveName name;
    @PropertyDefinition(validate="notNull")
    private final ValueType xValueType;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ValueType yValueType;
    @PropertyDefinition(get="optional")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull", builderType="List<? extends CurveNode>", overrideGet=true)
    private final ImmutableList<CurveNode> nodes;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator interpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorRight;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.xValueType = ValueType.UNKNOWN;
        builder.yValueType = ValueType.UNKNOWN;
    }

    @ImmutableValidator
    private void validate() {
        if (this.nodes.size() < 2) {
            throw new IllegalArgumentException("Curve must have at least two nodes");
        }
    }

    @Override
    public InterpolatedNodalCurveDefinition filtered(LocalDate valuationDate, ReferenceData refData) {
        Pair pairAfter;
        Pair pairBefore;
        CurveNodeDateOrder restriction;
        Pair pair;
        int i;
        ArrayList nodeDates = this.nodes.stream().map(node -> Pair.of((Object)node.date(valuationDate, refData), (Object)node)).collect(Collectors.toCollection(ArrayList::new));
        block10: for (i = 0; i < nodeDates.size(); ++i) {
            pair = (Pair)nodeDates.get(i);
            restriction = ((CurveNode)pair.getSecond()).getDateOrder();
            if (i > 0 && ChronoUnit.DAYS.between((Temporal)(pairBefore = (Pair)nodeDates.get(i - 1)).getFirst(), (Temporal)pair.getFirst()) < (long)restriction.getMinGapInDays()) {
                switch (restriction.getAction()) {
                    case DROP_THIS: {
                        nodeDates.remove(i);
                        i = -1;
                        continue block10;
                    }
                    case DROP_OTHER: {
                        nodeDates.remove(i - 1);
                        i = -1;
                        continue block10;
                    }
                    case EXCEPTION: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected enum value");
                    }
                }
            }
            if (i >= nodeDates.size() - 1) continue;
            pairAfter = (Pair)nodeDates.get(i + 1);
            if (ChronoUnit.DAYS.between((Temporal)pair.getFirst(), (Temporal)pairAfter.getFirst()) >= (long)restriction.getMinGapInDays()) continue;
            switch (restriction.getAction()) {
                case DROP_THIS: {
                    nodeDates.remove(i);
                    i = -1;
                    continue block10;
                }
                case DROP_OTHER: {
                    nodeDates.remove(i + 1);
                    i = -1;
                    continue block10;
                }
                case EXCEPTION: {
                    continue block10;
                }
                default: {
                    throw new IllegalStateException("Unexpected enum value");
                }
            }
        }
        for (i = 0; i < nodeDates.size(); ++i) {
            pair = (Pair)nodeDates.get(i);
            restriction = ((CurveNode)pair.getSecond()).getDateOrder();
            if (i > 0 && ChronoUnit.DAYS.between((Temporal)(pairBefore = (Pair)nodeDates.get(i - 1)).getFirst(), (Temporal)pair.getFirst()) < (long)restriction.getMinGapInDays()) {
                throw new IllegalArgumentException(Messages.format((String)"Curve node dates clash, node '{}' and '{}' resolved to dates '{}' and '{}' respectively", (Object[])new Object[]{((CurveNode)pairBefore.getSecond()).getLabel(), ((CurveNode)pair.getSecond()).getLabel(), pairBefore.getFirst(), pair.getFirst()}));
            }
            if (i >= nodeDates.size() - 1) continue;
            pairAfter = (Pair)nodeDates.get(i + 1);
            if (ChronoUnit.DAYS.between((Temporal)pair.getFirst(), (Temporal)pairAfter.getFirst()) >= (long)restriction.getMinGapInDays()) continue;
            throw new IllegalArgumentException(Messages.format((String)"Curve node dates clash, node '{}' and '{}' resolved to dates '{}' and '{}' respectively", (Object[])new Object[]{((CurveNode)pair.getSecond()).getLabel(), ((CurveNode)pairAfter.getSecond()).getLabel(), pair.getFirst(), pairAfter.getFirst()}));
        }
        List filteredNodes = (List)nodeDates.stream().map(p -> (CurveNode)p.getSecond()).collect(Guavate.toImmutableList());
        return new InterpolatedNodalCurveDefinition(this.name, this.xValueType, this.yValueType, this.dayCount, filteredNodes, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
    }

    @Override
    public CurveMetadata metadata(LocalDate valuationDate, ReferenceData refData) {
        List nodeMetadata = (List)this.nodes.stream().map(node -> node.metadata(valuationDate, refData)).collect(Guavate.toImmutableList());
        return DefaultCurveMetadata.builder().curveName(this.name).xValueType(this.xValueType).yValueType(this.yValueType).dayCount(this.dayCount).parameterMetadata(nodeMetadata).build();
    }

    @Override
    public NodalCurve curve(LocalDate valuationDate, CurveMetadata metadata, DoubleArray parameters) {
        DoubleArray nodeTimes = this.buildNodeTimes(valuationDate, metadata);
        return InterpolatedNodalCurve.builder().metadata(metadata).xValues(nodeTimes).yValues(parameters).extrapolatorLeft(this.extrapolatorLeft).interpolator(this.interpolator).extrapolatorRight(this.extrapolatorRight).build();
    }

    private DoubleArray buildNodeTimes(LocalDate valuationDate, CurveMetadata metadata) {
        if (metadata.getXValueType().equals((Object)ValueType.YEAR_FRACTION)) {
            return DoubleArray.of((int)this.getParameterCount(), i -> {
                LocalDate nodeDate = ((DatedParameterMetadata)metadata.getParameterMetadata().get().get(i)).getDate();
                return this.getDayCount().get().yearFraction(valuationDate, nodeDate);
            });
        }
        if (metadata.getXValueType().equals((Object)ValueType.MONTHS)) {
            return DoubleArray.of((int)this.getParameterCount(), i -> {
                LocalDate nodeDate = ((DatedParameterMetadata)metadata.getParameterMetadata().get().get(i)).getDate();
                return YearMonth.from(valuationDate).until(YearMonth.from(nodeDate), ChronoUnit.MONTHS);
            });
        }
        throw new IllegalArgumentException("Metadata XValueType should be YearFraction or Months in curve definition");
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private InterpolatedNodalCurveDefinition(CurveName name, ValueType xValueType, ValueType yValueType, DayCount dayCount, List<? extends CurveNode> nodes, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)((Object)xValueType), (String)"xValueType");
        JodaBeanUtils.notNull((Object)((Object)yValueType), (String)"yValueType");
        JodaBeanUtils.notNull(nodes, (String)"nodes");
        JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
        JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
        JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
        this.name = name;
        this.xValueType = xValueType;
        this.yValueType = yValueType;
        this.dayCount = dayCount;
        this.nodes = ImmutableList.copyOf(nodes);
        this.interpolator = interpolator;
        this.extrapolatorLeft = extrapolatorLeft;
        this.extrapolatorRight = extrapolatorRight;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveName getName() {
        return this.name;
    }

    public ValueType getXValueType() {
        return this.xValueType;
    }

    @Override
    public ValueType getYValueType() {
        return this.yValueType;
    }

    public Optional<DayCount> getDayCount() {
        return Optional.ofNullable(this.dayCount);
    }

    @Override
    public ImmutableList<CurveNode> getNodes() {
        return this.nodes;
    }

    public CurveInterpolator getInterpolator() {
        return this.interpolator;
    }

    public CurveExtrapolator getExtrapolatorLeft() {
        return this.extrapolatorLeft;
    }

    public CurveExtrapolator getExtrapolatorRight() {
        return this.extrapolatorRight;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InterpolatedNodalCurveDefinition other = (InterpolatedNodalCurveDefinition)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)((Object)this.xValueType), (Object)((Object)other.xValueType)) && JodaBeanUtils.equal((Object)((Object)this.yValueType), (Object)((Object)other.yValueType)) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal(this.nodes, other.nodes) && JodaBeanUtils.equal((Object)this.interpolator, (Object)other.interpolator) && JodaBeanUtils.equal((Object)this.extrapolatorLeft, (Object)other.extrapolatorLeft) && JodaBeanUtils.equal((Object)this.extrapolatorRight, (Object)other.extrapolatorRight);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.xValueType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.yValueType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.nodes);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.interpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorRight);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(288);
        buf.append("InterpolatedNodalCurveDefinition{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("xValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.xValueType))).append(',').append(' ');
        buf.append("yValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yValueType))).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("nodes").append('=').append(JodaBeanUtils.toString(this.nodes)).append(',').append(' ');
        buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
        buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
        buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<InterpolatedNodalCurveDefinition> {
        private CurveName name;
        private ValueType xValueType;
        private ValueType yValueType;
        private DayCount dayCount;
        private List<? extends CurveNode> nodes = ImmutableList.of();
        private CurveInterpolator interpolator;
        private CurveExtrapolator extrapolatorLeft;
        private CurveExtrapolator extrapolatorRight;

        private Builder() {
            InterpolatedNodalCurveDefinition.applyDefaults(this);
        }

        private Builder(InterpolatedNodalCurveDefinition beanToCopy) {
            this.name = beanToCopy.getName();
            this.xValueType = beanToCopy.getXValueType();
            this.yValueType = beanToCopy.getYValueType();
            this.dayCount = beanToCopy.dayCount;
            this.nodes = beanToCopy.getNodes();
            this.interpolator = beanToCopy.getInterpolator();
            this.extrapolatorLeft = beanToCopy.getExtrapolatorLeft();
            this.extrapolatorRight = beanToCopy.getExtrapolatorRight();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -868509005: {
                    return this.xValueType;
                }
                case -1065022510: {
                    return this.yValueType;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 104993457: {
                    return this.nodes;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (CurveName)newValue;
                    break;
                }
                case -868509005: {
                    this.xValueType = (ValueType)((Object)newValue);
                    break;
                }
                case -1065022510: {
                    this.yValueType = (ValueType)((Object)newValue);
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 104993457: {
                    this.nodes = (List)newValue;
                    break;
                }
                case 2096253127: {
                    this.interpolator = (CurveInterpolator)newValue;
                    break;
                }
                case 1271703994: {
                    this.extrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case 773779145: {
                    this.extrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public InterpolatedNodalCurveDefinition build() {
            return new InterpolatedNodalCurveDefinition(this.name, this.xValueType, this.yValueType, this.dayCount, this.nodes, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
        }

        public Builder name(CurveName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder xValueType(ValueType xValueType) {
            JodaBeanUtils.notNull((Object)((Object)xValueType), (String)"xValueType");
            this.xValueType = xValueType;
            return this;
        }

        public Builder yValueType(ValueType yValueType) {
            JodaBeanUtils.notNull((Object)((Object)yValueType), (String)"yValueType");
            this.yValueType = yValueType;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            this.dayCount = dayCount;
            return this;
        }

        public Builder nodes(List<? extends CurveNode> nodes) {
            JodaBeanUtils.notNull(nodes, (String)"nodes");
            this.nodes = nodes;
            return this;
        }

        public Builder nodes(CurveNode ... nodes) {
            return this.nodes((List<? extends CurveNode>)ImmutableList.copyOf((Object[])nodes));
        }

        public Builder interpolator(CurveInterpolator interpolator) {
            JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
            this.interpolator = interpolator;
            return this;
        }

        public Builder extrapolatorLeft(CurveExtrapolator extrapolatorLeft) {
            JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
            this.extrapolatorLeft = extrapolatorLeft;
            return this;
        }

        public Builder extrapolatorRight(CurveExtrapolator extrapolatorRight) {
            JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
            this.extrapolatorRight = extrapolatorRight;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("InterpolatedNodalCurveDefinition.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("xValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.xValueType))).append(',').append(' ');
            buf.append("yValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yValueType))).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("nodes").append('=').append(JodaBeanUtils.toString(this.nodes)).append(',').append(' ');
            buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
            buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
            buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", InterpolatedNodalCurveDefinition.class, CurveName.class);
        private final MetaProperty<ValueType> xValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xValueType", InterpolatedNodalCurveDefinition.class, ValueType.class);
        private final MetaProperty<ValueType> yValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yValueType", InterpolatedNodalCurveDefinition.class, ValueType.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", InterpolatedNodalCurveDefinition.class, DayCount.class);
        private final MetaProperty<ImmutableList<CurveNode>> nodes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nodes", InterpolatedNodalCurveDefinition.class, ImmutableList.class);
        private final MetaProperty<CurveInterpolator> interpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"interpolator", InterpolatedNodalCurveDefinition.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorLeft", InterpolatedNodalCurveDefinition.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorRight", InterpolatedNodalCurveDefinition.class, CurveExtrapolator.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "xValueType", "yValueType", "dayCount", "nodes", "interpolator", "extrapolatorLeft", "extrapolatorRight"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -868509005: {
                    return this.xValueType;
                }
                case -1065022510: {
                    return this.yValueType;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 104993457: {
                    return this.nodes;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends InterpolatedNodalCurveDefinition> beanType() {
            return InterpolatedNodalCurveDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveName> name() {
            return this.name;
        }

        public MetaProperty<ValueType> xValueType() {
            return this.xValueType;
        }

        public MetaProperty<ValueType> yValueType() {
            return this.yValueType;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<ImmutableList<CurveNode>> nodes() {
            return this.nodes;
        }

        public MetaProperty<CurveInterpolator> interpolator() {
            return this.interpolator;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorLeft() {
            return this.extrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorRight() {
            return this.extrapolatorRight;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((InterpolatedNodalCurveDefinition)bean).getName();
                }
                case -868509005: {
                    return ((InterpolatedNodalCurveDefinition)bean).getXValueType();
                }
                case -1065022510: {
                    return ((InterpolatedNodalCurveDefinition)bean).getYValueType();
                }
                case 1905311443: {
                    return ((InterpolatedNodalCurveDefinition)bean).dayCount;
                }
                case 104993457: {
                    return ((InterpolatedNodalCurveDefinition)bean).getNodes();
                }
                case 2096253127: {
                    return ((InterpolatedNodalCurveDefinition)bean).getInterpolator();
                }
                case 1271703994: {
                    return ((InterpolatedNodalCurveDefinition)bean).getExtrapolatorLeft();
                }
                case 773779145: {
                    return ((InterpolatedNodalCurveDefinition)bean).getExtrapolatorRight();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

