/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.ShiftType;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.CurveNode;
import com.opengamma.strata.market.curve.InflationNodalCurve;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.NodalCurveDefinition;
import com.opengamma.strata.market.curve.SeasonalityDefinition;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", metaScope="private")
final class InflationNodalCurveDefinition
implements NodalCurveDefinition,
ImmutableBean,
Serializable {
    private static final SeasonalityDefinition NO_SEASONALITY_DEFINITION = SeasonalityDefinition.of(DoubleArray.filled((int)12, (double)1.0), ShiftType.SCALED);
    @PropertyDefinition(validate="notNull")
    private final NodalCurveDefinition curveWithoutFixingDefinition;
    @PropertyDefinition(validate="notNull")
    private final YearMonth lastFixingMonth;
    @PropertyDefinition
    private final double lastFixingValue;
    @PropertyDefinition(validate="notNull")
    private final SeasonalityDefinition seasonalityDefinition;
    private static final long serialVersionUID = 1L;

    @ImmutableConstructor
    InflationNodalCurveDefinition(NodalCurveDefinition curveWithoutFixing, YearMonth lastFixingMonth, double lastFixingValue, SeasonalityDefinition seasonalityDefinition) {
        this.curveWithoutFixingDefinition = curveWithoutFixing;
        this.lastFixingMonth = lastFixingMonth;
        this.lastFixingValue = lastFixingValue;
        this.seasonalityDefinition = seasonalityDefinition == null ? NO_SEASONALITY_DEFINITION : seasonalityDefinition;
    }

    @Override
    public CurveName getName() {
        return this.curveWithoutFixingDefinition.getName();
    }

    @Override
    public ValueType getYValueType() {
        return this.curveWithoutFixingDefinition.getYValueType();
    }

    @Override
    public ImmutableList<CurveNode> getNodes() {
        return this.curveWithoutFixingDefinition.getNodes();
    }

    @Override
    public NodalCurveDefinition filtered(LocalDate valuationDate, ReferenceData refData) {
        return this.curveWithoutFixingDefinition.filtered(valuationDate, refData);
    }

    @Override
    public CurveMetadata metadata(LocalDate valuationDate, ReferenceData refData) {
        return this.curveWithoutFixingDefinition.metadata(valuationDate, refData);
    }

    @Override
    public NodalCurve curve(LocalDate valuationDate, CurveMetadata metadata, DoubleArray parameters) {
        NodalCurve curveWithoutFixing = this.curveWithoutFixingDefinition.curve(valuationDate, metadata, parameters);
        return InflationNodalCurve.of(curveWithoutFixing, valuationDate, this.lastFixingMonth, this.lastFixingValue, this.seasonalityDefinition);
    }

    public static MetaBean meta() {
        return Meta.INSTANCE;
    }

    public MetaBean metaBean() {
        return Meta.INSTANCE;
    }

    public NodalCurveDefinition getCurveWithoutFixingDefinition() {
        return this.curveWithoutFixingDefinition;
    }

    public YearMonth getLastFixingMonth() {
        return this.lastFixingMonth;
    }

    public double getLastFixingValue() {
        return this.lastFixingValue;
    }

    public SeasonalityDefinition getSeasonalityDefinition() {
        return this.seasonalityDefinition;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InflationNodalCurveDefinition other = (InflationNodalCurveDefinition)obj;
            return JodaBeanUtils.equal((Object)this.curveWithoutFixingDefinition, (Object)other.curveWithoutFixingDefinition) && JodaBeanUtils.equal((Object)this.lastFixingMonth, (Object)other.lastFixingMonth) && JodaBeanUtils.equal((double)this.lastFixingValue, (double)other.lastFixingValue) && JodaBeanUtils.equal((Object)this.seasonalityDefinition, (Object)other.seasonalityDefinition);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curveWithoutFixingDefinition);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastFixingMonth);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.lastFixingValue);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.seasonalityDefinition);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("InflationNodalCurveDefinition{");
        buf.append("curveWithoutFixingDefinition").append('=').append(JodaBeanUtils.toString((Object)this.curveWithoutFixingDefinition)).append(',').append(' ');
        buf.append("lastFixingMonth").append('=').append(JodaBeanUtils.toString((Object)this.lastFixingMonth)).append(',').append(' ');
        buf.append("lastFixingValue").append('=').append(JodaBeanUtils.toString((Object)this.lastFixingValue)).append(',').append(' ');
        buf.append("seasonalityDefinition").append('=').append(JodaBeanUtils.toString((Object)this.seasonalityDefinition));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<InflationNodalCurveDefinition> {
        private NodalCurveDefinition curveWithoutFixingDefinition;
        private YearMonth lastFixingMonth;
        private double lastFixingValue;
        private SeasonalityDefinition seasonalityDefinition;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -249814055: {
                    return this.curveWithoutFixingDefinition;
                }
                case -1842439587: {
                    return this.lastFixingMonth;
                }
                case -1834546866: {
                    return this.lastFixingValue;
                }
                case 1835044115: {
                    return this.seasonalityDefinition;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -249814055: {
                    this.curveWithoutFixingDefinition = (NodalCurveDefinition)newValue;
                    break;
                }
                case -1842439587: {
                    this.lastFixingMonth = (YearMonth)newValue;
                    break;
                }
                case -1834546866: {
                    this.lastFixingValue = (Double)newValue;
                    break;
                }
                case 1835044115: {
                    this.seasonalityDefinition = (SeasonalityDefinition)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public InflationNodalCurveDefinition build() {
            return new InflationNodalCurveDefinition(this.curveWithoutFixingDefinition, this.lastFixingMonth, this.lastFixingValue, this.seasonalityDefinition);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("InflationNodalCurveDefinition.Builder{");
            buf.append("curveWithoutFixingDefinition").append('=').append(JodaBeanUtils.toString((Object)this.curveWithoutFixingDefinition)).append(',').append(' ');
            buf.append("lastFixingMonth").append('=').append(JodaBeanUtils.toString((Object)this.lastFixingMonth)).append(',').append(' ');
            buf.append("lastFixingValue").append('=').append(JodaBeanUtils.toString((Object)this.lastFixingValue)).append(',').append(' ');
            buf.append("seasonalityDefinition").append('=').append(JodaBeanUtils.toString((Object)this.seasonalityDefinition));
            buf.append('}');
            return buf.toString();
        }
    }

    private static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<NodalCurveDefinition> curveWithoutFixingDefinition = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveWithoutFixingDefinition", InflationNodalCurveDefinition.class, NodalCurveDefinition.class);
        private final MetaProperty<YearMonth> lastFixingMonth = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastFixingMonth", InflationNodalCurveDefinition.class, YearMonth.class);
        private final MetaProperty<Double> lastFixingValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastFixingValue", InflationNodalCurveDefinition.class, Double.TYPE);
        private final MetaProperty<SeasonalityDefinition> seasonalityDefinition = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"seasonalityDefinition", InflationNodalCurveDefinition.class, SeasonalityDefinition.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"curveWithoutFixingDefinition", "lastFixingMonth", "lastFixingValue", "seasonalityDefinition"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -249814055: {
                    return this.curveWithoutFixingDefinition;
                }
                case -1842439587: {
                    return this.lastFixingMonth;
                }
                case -1834546866: {
                    return this.lastFixingValue;
                }
                case 1835044115: {
                    return this.seasonalityDefinition;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends InflationNodalCurveDefinition> builder() {
            return new Builder();
        }

        public Class<? extends InflationNodalCurveDefinition> beanType() {
            return InflationNodalCurveDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -249814055: {
                    return ((InflationNodalCurveDefinition)bean).getCurveWithoutFixingDefinition();
                }
                case -1842439587: {
                    return ((InflationNodalCurveDefinition)bean).getLastFixingMonth();
                }
                case -1834546866: {
                    return ((InflationNodalCurveDefinition)bean).getLastFixingValue();
                }
                case 1835044115: {
                    return ((InflationNodalCurveDefinition)bean).getSeasonalityDefinition();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

