/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.ShiftType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.SeasonalityDefinition;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class InflationNodalCurve
implements NodalCurve,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final NodalCurve underlying;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray seasonality;
    @PropertyDefinition(validate="notNull")
    private final ShiftType adjustmentType;
    private final transient double xFixing;
    private final transient double yFixing;
    private static final long serialVersionUID = 1L;

    public static InflationNodalCurve of(NodalCurve curve, DoubleArray seasonality, ShiftType adjustmentType) {
        return new InflationNodalCurve(curve, seasonality, adjustmentType);
    }

    public static InflationNodalCurve of(NodalCurve curveWithoutFixing, LocalDate valuationDate, YearMonth lastMonth, double lastFixingValue, SeasonalityDefinition seasonalityDefinition) {
        YearMonth valuationMonth = YearMonth.from(valuationDate);
        ArgChecker.isTrue((boolean)lastMonth.isBefore(valuationMonth), (String)"Last fixing month {} for curve '{}' must be before valuation date {}", (Object[])new Object[]{lastMonth, curveWithoutFixing.getName().getName(), valuationDate});
        double nbMonth = valuationMonth.until(lastMonth, ChronoUnit.MONTHS);
        DoubleArray x = curveWithoutFixing.getXValues();
        ArgChecker.isTrue((nbMonth < x.get(0) ? 1 : 0) != 0, (String)"First estimation month for curve '{}' must be after the last fixing month {}", (Object[])new Object[]{curveWithoutFixing.getName().getName(), lastMonth});
        NodalCurve extendedCurve = curveWithoutFixing.withNode(nbMonth, lastFixingValue, ParameterMetadata.empty());
        double[] seasonalityCompoundedArray = new double[12];
        int lastMonthIndex = lastMonth.getMonth().getValue() - 1;
        seasonalityCompoundedArray[(int)((nbMonth + 12.0 + 1.0) % 12.0)] = seasonalityDefinition.getSeasonalityMonthOnMonth().get(lastMonthIndex % 12);
        for (int i = 1; i < 12; ++i) {
            int j = (int)((nbMonth + 12.0 + 1.0 + (double)i) % 12.0);
            seasonalityCompoundedArray[j] = seasonalityDefinition.getAdjustmentType().applyShift(seasonalityCompoundedArray[(j - 1 + 12) % 12], seasonalityDefinition.getSeasonalityMonthOnMonth().get((lastMonthIndex + i) % 12));
        }
        return new InflationNodalCurve(extendedCurve, DoubleArray.ofUnsafe((double[])seasonalityCompoundedArray), seasonalityDefinition.getAdjustmentType());
    }

    @ImmutableConstructor
    private InflationNodalCurve(NodalCurve curve, DoubleArray seasonality, ShiftType adjustmentType) {
        this.underlying = curve;
        this.seasonality = seasonality;
        this.xFixing = curve.getXValues().get(0);
        this.yFixing = curve.getYValues().get(0);
        int i = this.seasonalityIndex(this.xFixing);
        ArgChecker.isTrue((Math.abs(adjustmentType.applyShift(this.yFixing, seasonality.get(i)) - this.yFixing) < 1.0E-12 ? 1 : 0) != 0, (String)"Fixing value should be unadjusted");
        this.adjustmentType = adjustmentType;
    }

    private Object readResolve() {
        return new InflationNodalCurve(this.underlying, this.seasonality, this.adjustmentType);
    }

    @Override
    public CurveMetadata getMetadata() {
        return this.underlying.getMetadata();
    }

    @Override
    public double yValue(double x) {
        int i = this.seasonalityIndex(x);
        double adjustment = this.seasonality.get(i);
        return this.adjustmentType.applyShift(this.underlying.yValue(x), adjustment);
    }

    private int seasonalityIndex(double x) {
        long xLong = Math.round(x);
        return (int)((xLong % 12L + 12L) % 12L);
    }

    @Override
    public int getParameterCount() {
        return this.underlying.getParameterCount() - 1;
    }

    @Override
    public double getParameter(int parameterIndex) {
        return this.underlying.getParameter(parameterIndex + 1);
    }

    @Override
    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.underlying.getParameterMetadata(parameterIndex + 1);
    }

    @Override
    public DoubleArray getXValues() {
        return this.underlying.getXValues().subArray(1);
    }

    @Override
    public DoubleArray getYValues() {
        return this.underlying.getYValues().subArray(1);
    }

    @Override
    public UnitParameterSensitivity yValueParameterSensitivity(double x) {
        int i = this.seasonalityIndex(x);
        double adjustment = this.seasonality.get(i);
        double derivativeFactor = 0.0;
        if (this.adjustmentType.equals((Object)ShiftType.ABSOLUTE)) {
            derivativeFactor = 1.0;
        } else if (this.adjustmentType.equals((Object)ShiftType.SCALED)) {
            derivativeFactor = adjustment;
        } else {
            throw new IllegalArgumentException("ShiftType " + (Object)((Object)this.adjustmentType) + " is not supported for sensitivities");
        }
        UnitParameterSensitivity u = this.underlying.yValueParameterSensitivity(x);
        UnitParameterSensitivity u2 = UnitParameterSensitivity.of(u.getMarketDataName(), (List<? extends ParameterMetadata>)u.getParameterMetadata().subList(1, u.getParameterMetadata().size()), u.getSensitivity().subArray(1));
        return u2.multipliedBy(derivativeFactor);
    }

    @Override
    public double firstDerivative(double x) {
        throw new UnsupportedOperationException("Value implemented only at discrete (monthly) values; no derivative available");
    }

    @Override
    public InflationNodalCurve withMetadata(CurveMetadata metadata) {
        return new InflationNodalCurve(this.underlying.withMetadata(metadata), this.seasonality, this.adjustmentType);
    }

    @Override
    public InflationNodalCurve withYValues(DoubleArray values) {
        DoubleArray yExtended = DoubleArray.of((double)this.yFixing).concat(values);
        return new InflationNodalCurve(this.underlying.withYValues(yExtended), this.seasonality, this.adjustmentType);
    }

    @Override
    public InflationNodalCurve withValues(DoubleArray xValues, DoubleArray yValues) {
        DoubleArray xExtended = DoubleArray.of((double)this.xFixing).concat(xValues);
        DoubleArray yExtended = DoubleArray.of((double)this.yFixing).concat(yValues);
        return new InflationNodalCurve(this.underlying.withValues(xExtended, yExtended), this.seasonality, this.adjustmentType);
    }

    @Override
    public InflationNodalCurve withParameter(int parameterIndex, double newValue) {
        return new InflationNodalCurve(this.underlying.withParameter(parameterIndex + 1, newValue), this.seasonality, this.adjustmentType);
    }

    @Override
    public InflationNodalCurve withNode(double x, double y, ParameterMetadata paramMetadata) {
        ArgChecker.isTrue((this.xFixing < x ? 1 : 0) != 0, (String)"node can be added only after the fixing anchor");
        return new InflationNodalCurve(this.underlying.withNode(x, y, paramMetadata), this.seasonality, this.adjustmentType);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public NodalCurve getUnderlying() {
        return this.underlying;
    }

    public DoubleArray getSeasonality() {
        return this.seasonality;
    }

    public ShiftType getAdjustmentType() {
        return this.adjustmentType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InflationNodalCurve other = (InflationNodalCurve)obj;
            return JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying) && JodaBeanUtils.equal((Object)this.seasonality, (Object)other.seasonality) && JodaBeanUtils.equal((Object)((Object)this.adjustmentType), (Object)((Object)other.adjustmentType));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.seasonality);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.adjustmentType));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("InflationNodalCurve{");
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying)).append(',').append(' ');
        buf.append("seasonality").append('=').append(JodaBeanUtils.toString((Object)this.seasonality)).append(',').append(' ');
        buf.append("adjustmentType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.adjustmentType)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<InflationNodalCurve> {
        private NodalCurve underlying;
        private DoubleArray seasonality;
        private ShiftType adjustmentType;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return this.underlying;
                }
                case -857898080: {
                    return this.seasonality;
                }
                case -1002343865: {
                    return this.adjustmentType;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    this.underlying = (NodalCurve)newValue;
                    break;
                }
                case -857898080: {
                    this.seasonality = (DoubleArray)newValue;
                    break;
                }
                case -1002343865: {
                    this.adjustmentType = (ShiftType)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public InflationNodalCurve build() {
            return new InflationNodalCurve(this.underlying, this.seasonality, this.adjustmentType);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("InflationNodalCurve.Builder{");
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying)).append(',').append(' ');
            buf.append("seasonality").append('=').append(JodaBeanUtils.toString((Object)this.seasonality)).append(',').append(' ');
            buf.append("adjustmentType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.adjustmentType)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<NodalCurve> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", InflationNodalCurve.class, NodalCurve.class);
        private final MetaProperty<DoubleArray> seasonality = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"seasonality", InflationNodalCurve.class, DoubleArray.class);
        private final MetaProperty<ShiftType> adjustmentType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"adjustmentType", InflationNodalCurve.class, ShiftType.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"underlying", "seasonality", "adjustmentType"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return this.underlying;
                }
                case -857898080: {
                    return this.seasonality;
                }
                case -1002343865: {
                    return this.adjustmentType;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends InflationNodalCurve> builder() {
            return new Builder();
        }

        public Class<? extends InflationNodalCurve> beanType() {
            return InflationNodalCurve.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<NodalCurve> underlying() {
            return this.underlying;
        }

        public MetaProperty<DoubleArray> seasonality() {
            return this.seasonality;
        }

        public MetaProperty<ShiftType> adjustmentType() {
            return this.adjustmentType;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return ((InflationNodalCurve)bean).getUnderlying();
                }
                case -857898080: {
                    return ((InflationNodalCurve)bean).getSeasonality();
                }
                case -1002343865: {
                    return ((InflationNodalCurve)bean).getAdjustmentType();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

