/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.InterpolatedNodalCurve;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class HybridNodalCurve
implements NodalCurve,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final NodalCurve leftCurve;
    @PropertyDefinition(validate="notNull")
    private final NodalCurve rightCurve;
    private final transient int spliceIndex;
    private final transient double xSplice;
    private final transient CurveMetadata combinedMetadata;
    private static final long serialVersionUID = 1L;

    public static HybridNodalCurve of(CurveMetadata metadata, DoubleArray xValues, DoubleArray yValues, int spliceIndex, CurveInterpolator interpolatorLeft, CurveInterpolator interpolatorRight, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight) {
        if (spliceIndex > xValues.size() - 1 || spliceIndex < 0) {
            throw new IllegalArgumentException(Messages.format((String)"Hybrid curve splice index [{}] must be less than number of parameters [{}] and non-negative", (Object[])new Object[]{spliceIndex, xValues.size()}));
        }
        DoubleArray xLeft = xValues.subArray(0, spliceIndex + 1);
        DoubleArray yLeft = yValues.subArray(0, spliceIndex + 1);
        DoubleArray xRight = xValues.subArray(spliceIndex, xValues.size());
        DoubleArray yRight = yValues.subArray(spliceIndex, yValues.size());
        Pair<CurveMetadata, CurveMetadata> splicedMetaData = HybridNodalCurve.splicedMetaData(metadata, spliceIndex);
        InterpolatedNodalCurve leftCurve = InterpolatedNodalCurve.builder().metadata((CurveMetadata)splicedMetaData.getFirst()).xValues(xLeft).yValues(yLeft).interpolator(interpolatorLeft).extrapolatorLeft(extrapolatorLeft).extrapolatorRight(extrapolatorRight).build();
        InterpolatedNodalCurve rightCurve = InterpolatedNodalCurve.builder().metadata((CurveMetadata)splicedMetaData.getSecond()).xValues(xRight).yValues(yRight).interpolator(interpolatorRight).extrapolatorLeft(extrapolatorLeft).extrapolatorRight(extrapolatorRight).build();
        return new HybridNodalCurve(leftCurve, rightCurve);
    }

    @ImmutableConstructor
    private HybridNodalCurve(NodalCurve leftCurve, NodalCurve rightCurve) {
        int i;
        this.leftCurve = (NodalCurve)ArgChecker.notNull((Object)leftCurve, (String)"leftCurve");
        this.rightCurve = (NodalCurve)ArgChecker.notNull((Object)rightCurve, (String)"rightCurve");
        this.xSplice = rightCurve.getXValues().get(0);
        this.spliceIndex = leftCurve.getParameterCount() - 1;
        ImmutableList.Builder combinedMetadataBuilder = ImmutableList.builder();
        for (i = 0; i < leftCurve.getParameterCount(); ++i) {
            combinedMetadataBuilder.add((Object)leftCurve.getParameterMetadata(i));
        }
        for (i = 1; i < rightCurve.getParameterCount(); ++i) {
            combinedMetadataBuilder.add((Object)rightCurve.getParameterMetadata(i));
        }
        this.combinedMetadata = leftCurve.getMetadata().withParameterMetadata((List<? extends ParameterMetadata>)combinedMetadataBuilder.build());
    }

    private static Pair<CurveMetadata, CurveMetadata> splicedMetaData(CurveMetadata curveMetadata, int spliceIndex) {
        CurveMetadata rightMetadata;
        CurveMetadata leftMetadata;
        if (curveMetadata.getParameterMetadata().isPresent()) {
            List<ParameterMetadata> parameterMetadata = curveMetadata.getParameterMetadata().get();
            leftMetadata = curveMetadata.withParameterMetadata(parameterMetadata.subList(0, spliceIndex + 1));
            rightMetadata = curveMetadata.withParameterMetadata(parameterMetadata.subList(spliceIndex, parameterMetadata.size()));
        } else {
            leftMetadata = curveMetadata;
            rightMetadata = curveMetadata;
        }
        return Pair.of((Object)leftMetadata, (Object)rightMetadata);
    }

    @Override
    public int getParameterCount() {
        return this.getYValues().size();
    }

    @Override
    public DoubleArray getXValues() {
        return this.leftCurve.getXValues().subArray(0, this.spliceIndex).concat(this.rightCurve.getXValues());
    }

    @Override
    public DoubleArray getYValues() {
        return this.leftCurve.getYValues().subArray(0, this.spliceIndex).concat(this.rightCurve.getYValues());
    }

    @Override
    public CurveMetadata getMetadata() {
        return this.combinedMetadata;
    }

    @Override
    public double getParameter(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.getYValues().size()) {
            throw new IllegalArgumentException(Messages.format((String)"Parameter index [] out of bounds of yValues array of size []", (Object[])new Object[]{parameterIndex, this.getYValues().size()}));
        }
        return this.getYValues().get(parameterIndex);
    }

    @Override
    public double yValue(double x) {
        return x < this.xSplice ? this.leftCurve.yValue(x) : this.rightCurve.yValue(x);
    }

    @Override
    public UnitParameterSensitivity yValueParameterSensitivity(double x) {
        if (x <= this.xSplice) {
            UnitParameterSensitivity leftSensi = this.leftCurve.yValueParameterSensitivity(x);
            DoubleArray rightArray = DoubleArray.filled((int)(this.rightCurve.getXValues().size() - 1));
            return UnitParameterSensitivity.of(this.getName(), leftSensi.getSensitivity().concat(rightArray));
        }
        DoubleArray leftArray = DoubleArray.filled((int)(this.leftCurve.getXValues().size() - 1));
        UnitParameterSensitivity rightSensi = this.rightCurve.yValueParameterSensitivity(x);
        return UnitParameterSensitivity.of(this.getName(), leftArray.concat(rightSensi.getSensitivity()));
    }

    @Override
    public double firstDerivative(double x) {
        if (x < this.xSplice) {
            return this.leftCurve.firstDerivative(x);
        }
        if (x > this.xSplice) {
            return this.rightCurve.firstDerivative(x);
        }
        return 0.5 * (this.leftCurve.firstDerivative(x) + this.rightCurve.firstDerivative(x));
    }

    @Override
    public HybridNodalCurve withNode(double x, double y, ParameterMetadata paramMetadata) {
        throw new IllegalArgumentException(Messages.format((String)"{} does not support withNode()", (Object)this.getClass().getSimpleName()));
    }

    @Override
    public HybridNodalCurve withYValues(DoubleArray yValues) {
        if (yValues.size() != this.getYValues().size()) {
            throw new IllegalArgumentException(Messages.format((String)"Size of new y values [] does not match current size []", (Object[])new Object[]{yValues.size(), this.getYValues().size()}));
        }
        NodalCurve updatedLeftCurve = this.leftCurve.withYValues(yValues.subArray(0, this.spliceIndex + 1));
        NodalCurve updatedRightCurve = this.rightCurve.withYValues(yValues.subArray(this.spliceIndex, yValues.size()));
        return new HybridNodalCurve(updatedLeftCurve, updatedRightCurve);
    }

    @Override
    public HybridNodalCurve withMetadata(CurveMetadata metadata) {
        Pair<CurveMetadata, CurveMetadata> splicedMetaData = HybridNodalCurve.splicedMetaData(metadata, this.spliceIndex);
        NodalCurve updatedLeftCurve = this.leftCurve.withMetadata((CurveMetadata)splicedMetaData.getFirst());
        NodalCurve updatedRightCurve = this.rightCurve.withMetadata((CurveMetadata)splicedMetaData.getSecond());
        return new HybridNodalCurve(updatedLeftCurve, updatedRightCurve);
    }

    @Override
    public HybridNodalCurve withParameter(int parameterIndex, double newValue) {
        NodalCurve updatedLeftCurve = parameterIndex <= this.spliceIndex ? this.leftCurve.withParameter(parameterIndex, newValue) : this.leftCurve;
        NodalCurve updatedRightCurve = parameterIndex >= this.spliceIndex ? this.rightCurve.withParameter(parameterIndex - this.spliceIndex, newValue) : this.rightCurve;
        return new HybridNodalCurve(updatedLeftCurve, updatedRightCurve);
    }

    @Override
    public UnitParameterSensitivity createParameterSensitivity(DoubleArray sensitivities) {
        return UnitParameterSensitivity.of(this.getName(), this.combinedMetadata.getParameterMetadata().orElse((List<ParameterMetadata>)ImmutableList.of()), sensitivities);
    }

    @Override
    public CurrencyParameterSensitivity createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return CurrencyParameterSensitivity.of(this.getName(), this.combinedMetadata.getParameterMetadata().orElse((List<ParameterMetadata>)ImmutableList.of()), currency, sensitivities);
    }

    @Override
    public HybridNodalCurve withPerturbation(ParameterPerturbation perturbation) {
        int size = this.getYValues().size();
        DoubleArray perturbedValues = DoubleArray.of((int)size, i -> perturbation.perturbParameter(i, this.getYValues().get(i), this.getParameterMetadata(i)));
        return this.withYValues(perturbedValues);
    }

    @Override
    public HybridNodalCurve withValues(DoubleArray xValues, DoubleArray yValues) {
        if (xValues.size() == this.getXValues().size()) {
            DoubleArray xValuesLeft = xValues.subArray(0, this.spliceIndex + 1);
            DoubleArray yValuesLeft = yValues.subArray(0, this.spliceIndex + 1);
            DoubleArray xValuesRight = xValues.subArray(this.spliceIndex, this.getXValues().size());
            DoubleArray yValuesRight = yValues.subArray(this.spliceIndex, this.getXValues().size());
            NodalCurve updatedLeftCurve = this.leftCurve.withValues(xValuesLeft, yValuesLeft);
            NodalCurve updatedRightCurve = this.rightCurve.withValues(xValuesRight, yValuesRight);
            return new HybridNodalCurve(updatedLeftCurve, updatedRightCurve);
        }
        throw new IllegalArgumentException(Messages.format((String)"{} does not support withValues() when the size of new x values [] does not match current size []; in this case a splice index must also be provided", (Object[])new Object[]{this.getClass().getSimpleName(), xValues.size(), this.getXValues().size()}));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public NodalCurve getLeftCurve() {
        return this.leftCurve;
    }

    public NodalCurve getRightCurve() {
        return this.rightCurve;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            HybridNodalCurve other = (HybridNodalCurve)obj;
            return JodaBeanUtils.equal((Object)this.leftCurve, (Object)other.leftCurve) && JodaBeanUtils.equal((Object)this.rightCurve, (Object)other.rightCurve);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.leftCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rightCurve);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("HybridNodalCurve{");
        buf.append("leftCurve").append('=').append(JodaBeanUtils.toString((Object)this.leftCurve)).append(',').append(' ');
        buf.append("rightCurve").append('=').append(JodaBeanUtils.toString((Object)this.rightCurve));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<HybridNodalCurve> {
        private NodalCurve leftCurve;
        private NodalCurve rightCurve;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1716149544: {
                    return this.leftCurve;
                }
                case -1413464013: {
                    return this.rightCurve;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1716149544: {
                    this.leftCurve = (NodalCurve)newValue;
                    break;
                }
                case -1413464013: {
                    this.rightCurve = (NodalCurve)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public HybridNodalCurve build() {
            return new HybridNodalCurve(this.leftCurve, this.rightCurve);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("HybridNodalCurve.Builder{");
            buf.append("leftCurve").append('=').append(JodaBeanUtils.toString((Object)this.leftCurve)).append(',').append(' ');
            buf.append("rightCurve").append('=').append(JodaBeanUtils.toString((Object)this.rightCurve));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<NodalCurve> leftCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"leftCurve", HybridNodalCurve.class, NodalCurve.class);
        private final MetaProperty<NodalCurve> rightCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rightCurve", HybridNodalCurve.class, NodalCurve.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"leftCurve", "rightCurve"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1716149544: {
                    return this.leftCurve;
                }
                case -1413464013: {
                    return this.rightCurve;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends HybridNodalCurve> builder() {
            return new Builder();
        }

        public Class<? extends HybridNodalCurve> beanType() {
            return HybridNodalCurve.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<NodalCurve> leftCurve() {
            return this.leftCurve;
        }

        public MetaProperty<NodalCurve> rightCurve() {
            return this.rightCurve;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1716149544: {
                    return ((HybridNodalCurve)bean).getLeftCurve();
                }
                case -1413464013: {
                    return ((HybridNodalCurve)bean).getRightCurve();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

