/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public interface CurveMetadata {
    public CurveName getCurveName();

    public ValueType getXValueType();

    public ValueType getYValueType();

    default public <T> T getInfo(CurveInfoType<T> type) {
        return this.findInfo(type).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"Curve info not found for type '{}'", (Object)type)));
    }

    public <T> Optional<T> findInfo(CurveInfoType<T> var1);

    default public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.getParameterMetadata().map(pm -> (ParameterMetadata)pm.get(parameterIndex)).orElse(ParameterMetadata.empty());
    }

    public Optional<List<ParameterMetadata>> getParameterMetadata();

    default public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        int index;
        Optional<List<ParameterMetadata>> pmOpt;
        if (!ParameterMetadata.empty().equals(metadata) && (pmOpt = this.getParameterMetadata()).isPresent() && (index = pmOpt.get().indexOf(metadata)) >= 0) {
            return OptionalInt.of(index);
        }
        return OptionalInt.empty();
    }

    public <T> DefaultCurveMetadata withInfo(CurveInfoType<T> var1, T var2);

    public CurveMetadata withParameterMetadata(List<? extends ParameterMetadata> var1);
}

