/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ConstantCurve
implements Curve,
ImmutableBean,
Serializable {
    private static final DoubleArray SENSITIVITY = DoubleArray.of((double)1.0);
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveMetadata metadata;
    @PropertyDefinition
    private final double yValue;
    private static final long serialVersionUID = 1L;

    public static ConstantCurve of(String name, double yValue) {
        return ConstantCurve.of(CurveName.of(name), yValue);
    }

    public static ConstantCurve of(CurveName name, double yValue) {
        return new ConstantCurve(DefaultCurveMetadata.of(name), yValue);
    }

    public static ConstantCurve of(CurveMetadata metadata, double yValue) {
        return new ConstantCurve(metadata, yValue);
    }

    private Object readResolve() {
        return new ConstantCurve(this.metadata, this.yValue);
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public double getParameter(int parameterIndex) {
        Preconditions.checkElementIndex((int)parameterIndex, (int)1);
        return this.yValue;
    }

    @Override
    public ConstantCurve withParameter(int parameterIndex, double newValue) {
        Preconditions.checkElementIndex((int)parameterIndex, (int)1);
        return new ConstantCurve(this.metadata, newValue);
    }

    @Override
    public ConstantCurve withPerturbation(ParameterPerturbation perturbation) {
        return new ConstantCurve(this.metadata, perturbation.perturbParameter(0, this.yValue, this.getParameterMetadata(0)));
    }

    @Override
    public double yValue(double x) {
        return this.yValue;
    }

    @Override
    public UnitParameterSensitivity yValueParameterSensitivity(double x) {
        ImmutableList paramMeta = ImmutableList.of((Object)this.getParameterMetadata(0));
        return UnitParameterSensitivity.of(this.metadata.getCurveName(), (List<? extends ParameterMetadata>)paramMeta, SENSITIVITY);
    }

    @Override
    public double firstDerivative(double x) {
        return 0.0;
    }

    @Override
    public ConstantCurve withMetadata(CurveMetadata metadata) {
        return new ConstantCurve(metadata.withParameterMetadata(null), this.yValue);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ConstantCurve(CurveMetadata metadata, double yValue) {
        JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
        this.metadata = metadata;
        this.yValue = yValue;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveMetadata getMetadata() {
        return this.metadata;
    }

    public double getYValue() {
        return this.yValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ConstantCurve other = (ConstantCurve)obj;
            return JodaBeanUtils.equal((Object)this.metadata, (Object)other.metadata) && JodaBeanUtils.equal((double)this.yValue, (double)other.yValue);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.metadata);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yValue);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ConstantCurve{");
        buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
        buf.append("yValue").append('=').append(JodaBeanUtils.toString((Object)this.yValue));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ConstantCurve> {
        private CurveMetadata metadata;
        private double yValue;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case -748419976: {
                    return this.yValue;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    this.metadata = (CurveMetadata)newValue;
                    break;
                }
                case -748419976: {
                    this.yValue = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ConstantCurve build() {
            return new ConstantCurve(this.metadata, this.yValue);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ConstantCurve.Builder{");
            buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
            buf.append("yValue").append('=').append(JodaBeanUtils.toString((Object)this.yValue));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveMetadata> metadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"metadata", ConstantCurve.class, CurveMetadata.class);
        private final MetaProperty<Double> yValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yValue", ConstantCurve.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"metadata", "yValue"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case -748419976: {
                    return this.yValue;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ConstantCurve> builder() {
            return new Builder();
        }

        public Class<? extends ConstantCurve> beanType() {
            return ConstantCurve.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveMetadata> metadata() {
            return this.metadata;
        }

        public MetaProperty<Double> yValue() {
            return this.yValue;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return ((ConstantCurve)bean).getMetadata();
                }
                case -748419976: {
                    return ((ConstantCurve)bean).getYValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

