/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.curve.DefaultCurveMetadataBuilder;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CombinedCurve
implements Curve,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Curve baseCurve;
    @PropertyDefinition(validate="notNull")
    private final Curve spreadCurve;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveMetadata metadata;
    private static final long serialVersionUID = 1L;

    public static CombinedCurve of(Curve baseCurve, Curve spreadCurve, CurveMetadata metadata) {
        return new CombinedCurve(baseCurve, spreadCurve, metadata);
    }

    public static CombinedCurve of(Curve baseCurve, Curve spreadCurve) {
        CurveMetadata baseMetadata = baseCurve.getMetadata();
        CurveMetadata spreadMetadata = spreadCurve.getMetadata();
        List paramMeta = (List)Stream.concat(IntStream.range(0, baseCurve.getParameterCount()).mapToObj(i -> baseCurve.getParameterMetadata(i)), IntStream.range(0, spreadCurve.getParameterCount()).mapToObj(i -> spreadCurve.getParameterMetadata(i))).collect(Guavate.toImmutableList());
        DefaultCurveMetadataBuilder metadataBuilder = DefaultCurveMetadata.builder().curveName(baseCurve.getName().getName() + "+" + spreadMetadata.getCurveName().getName()).xValueType(baseMetadata.getXValueType()).yValueType(baseMetadata.getYValueType()).parameterMetadata(paramMeta);
        if (baseMetadata.findInfo(CurveInfoType.DAY_COUNT).isPresent()) {
            metadataBuilder.addInfo(CurveInfoType.DAY_COUNT, baseMetadata.getInfo(CurveInfoType.DAY_COUNT));
        }
        return CombinedCurve.of(baseCurve, spreadCurve, metadataBuilder.build());
    }

    @ImmutableConstructor
    private CombinedCurve(Curve baseCurve, Curve spreadCurve, CurveMetadata metadata) {
        JodaBeanUtils.notNull((Object)baseCurve, (String)"baseCurve");
        JodaBeanUtils.notNull((Object)spreadCurve, (String)"spreadCurve");
        JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
        CurveMetadata baseMetadata = baseCurve.getMetadata();
        CurveMetadata spreadMetadata = spreadCurve.getMetadata();
        if (!baseMetadata.getXValueType().equals((Object)metadata.getXValueType())) {
            throw new IllegalArgumentException(Messages.format((String)"xValueType is {} in baseCurve, but {} in CombinedCurve", (Object[])new Object[]{baseMetadata.getXValueType(), metadata.getXValueType()}));
        }
        if (!spreadMetadata.getXValueType().equals((Object)metadata.getXValueType())) {
            throw new IllegalArgumentException(Messages.format((String)"xValueType is {} in spreadCurve, but {} in CombinedCurve", (Object[])new Object[]{spreadMetadata.getXValueType(), metadata.getXValueType()}));
        }
        if (!baseMetadata.getYValueType().equals((Object)metadata.getYValueType())) {
            throw new IllegalArgumentException(Messages.format((String)"yValueType is {} in baseCurve, but {} in CombinedCurve", (Object[])new Object[]{baseMetadata.getYValueType(), metadata.getYValueType()}));
        }
        if (!spreadMetadata.getYValueType().equals((Object)metadata.getYValueType())) {
            throw new IllegalArgumentException(Messages.format((String)"yValueType is {} in spreadCurve, but {} in CombinedCurve", (Object[])new Object[]{spreadMetadata.getYValueType(), metadata.getYValueType()}));
        }
        Optional<DayCount> dccOpt = metadata.findInfo(CurveInfoType.DAY_COUNT);
        if (dccOpt.isPresent()) {
            DayCount dcc = dccOpt.get();
            if (!baseMetadata.findInfo(CurveInfoType.DAY_COUNT).isPresent() || !baseMetadata.getInfo(CurveInfoType.DAY_COUNT).equals(dcc)) {
                throw new IllegalArgumentException(Messages.format((String)"DayCount in baseCurve should be {}", (Object)dcc));
            }
            if (!spreadMetadata.findInfo(CurveInfoType.DAY_COUNT).isPresent() || !spreadMetadata.getInfo(CurveInfoType.DAY_COUNT).equals(dcc)) {
                throw new IllegalArgumentException(Messages.format((String)"DayCount in spreadCurve should be {}", (Object)dcc));
            }
        }
        this.metadata = metadata;
        this.baseCurve = baseCurve;
        this.spreadCurve = spreadCurve;
    }

    @Override
    public CombinedCurve withMetadata(CurveMetadata metadata) {
        return new CombinedCurve(this.baseCurve, this.spreadCurve, metadata);
    }

    @Override
    public int getParameterCount() {
        return this.baseCurve.getParameterCount() + this.spreadCurve.getParameterCount();
    }

    @Override
    public double getParameter(int parameterIndex) {
        if (parameterIndex < this.baseCurve.getParameterCount()) {
            return this.baseCurve.getParameter(parameterIndex);
        }
        return this.spreadCurve.getParameter(parameterIndex - this.baseCurve.getParameterCount());
    }

    @Override
    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        if (parameterIndex < this.baseCurve.getParameterCount()) {
            return this.baseCurve.getParameterMetadata(parameterIndex);
        }
        return this.spreadCurve.getParameterMetadata(parameterIndex - this.baseCurve.getParameterCount());
    }

    @Override
    public CombinedCurve withParameter(int parameterIndex, double newValue) {
        if (parameterIndex < this.baseCurve.getParameterCount()) {
            return new CombinedCurve(this.baseCurve.withParameter(parameterIndex, newValue), this.spreadCurve, this.metadata);
        }
        return new CombinedCurve(this.baseCurve, this.spreadCurve.withParameter(parameterIndex - this.baseCurve.getParameterCount(), newValue), this.metadata);
    }

    @Override
    public CombinedCurve withPerturbation(ParameterPerturbation perturbation) {
        Curve newBaseCurve = this.baseCurve.withPerturbation((idx, value, meta) -> perturbation.perturbParameter(idx, this.baseCurve.getParameter(idx), this.baseCurve.getParameterMetadata(idx)));
        int offset = this.baseCurve.getParameterCount();
        Curve newSpreadCurve = this.spreadCurve.withPerturbation((idx, value, meta) -> perturbation.perturbParameter(idx + offset, this.spreadCurve.getParameter(idx), this.spreadCurve.getParameterMetadata(idx)));
        List newParamMeta = (List)Stream.concat(IntStream.range(0, newBaseCurve.getParameterCount()).mapToObj(i -> newBaseCurve.getParameterMetadata(i)), IntStream.range(0, newSpreadCurve.getParameterCount()).mapToObj(i -> newSpreadCurve.getParameterMetadata(i))).collect(Guavate.toImmutableList());
        return CombinedCurve.of(newBaseCurve, newSpreadCurve, this.metadata.withParameterMetadata(newParamMeta));
    }

    @Override
    public double yValue(double x) {
        return this.baseCurve.yValue(x) + this.spreadCurve.yValue(x);
    }

    @Override
    public UnitParameterSensitivity yValueParameterSensitivity(double x) {
        UnitParameterSensitivity baseSens = this.baseCurve.yValueParameterSensitivity(x);
        UnitParameterSensitivity spreadSens = this.spreadCurve.yValueParameterSensitivity(x);
        return UnitParameterSensitivity.combine(this.getName(), baseSens, spreadSens);
    }

    @Override
    public double firstDerivative(double x) {
        return this.baseCurve.firstDerivative(x) + this.spreadCurve.firstDerivative(x);
    }

    @Override
    public UnitParameterSensitivity createParameterSensitivity(DoubleArray sensitivities) {
        UnitParameterSensitivity baseSens = this.baseCurve.createParameterSensitivity(sensitivities.subArray(0, this.baseCurve.getParameterCount()));
        UnitParameterSensitivity spreadSens = this.spreadCurve.createParameterSensitivity(sensitivities.subArray(this.baseCurve.getParameterCount(), sensitivities.size()));
        return UnitParameterSensitivity.combine(this.getName(), baseSens, spreadSens);
    }

    @Override
    public CurrencyParameterSensitivity createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        CurrencyParameterSensitivity baseSensi = this.baseCurve.createParameterSensitivity(currency, sensitivities.subArray(0, this.baseCurve.getParameterCount()));
        CurrencyParameterSensitivity spreadSensi = this.spreadCurve.createParameterSensitivity(currency, sensitivities.subArray(this.baseCurve.getParameterCount(), sensitivities.size()));
        return CurrencyParameterSensitivity.combine(this.getName(), baseSensi, spreadSensi);
    }

    @Override
    public ImmutableList<Curve> split() {
        return ImmutableList.of((Object)this.baseCurve, (Object)this.spreadCurve);
    }

    @Override
    public CombinedCurve withUnderlyingCurve(int curveIndex, Curve curve) {
        if (curveIndex == 0) {
            return new CombinedCurve(curve, this.spreadCurve, this.metadata);
        }
        if (curveIndex == 1) {
            return new CombinedCurve(this.baseCurve, curve, this.metadata);
        }
        throw new IllegalArgumentException("curveIndex is outside the range");
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Curve getBaseCurve() {
        return this.baseCurve;
    }

    public Curve getSpreadCurve() {
        return this.spreadCurve;
    }

    @Override
    public CurveMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CombinedCurve other = (CombinedCurve)obj;
            return JodaBeanUtils.equal((Object)this.baseCurve, (Object)other.baseCurve) && JodaBeanUtils.equal((Object)this.spreadCurve, (Object)other.spreadCurve) && JodaBeanUtils.equal((Object)this.metadata, (Object)other.metadata);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.baseCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spreadCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.metadata);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("CombinedCurve{");
        buf.append("baseCurve").append('=').append(JodaBeanUtils.toString((Object)this.baseCurve)).append(',').append(' ');
        buf.append("spreadCurve").append('=').append(JodaBeanUtils.toString((Object)this.spreadCurve)).append(',').append(' ');
        buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CombinedCurve> {
        private Curve baseCurve;
        private Curve spreadCurve;
        private CurveMetadata metadata;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1842240354: {
                    return this.baseCurve;
                }
                case 2130054972: {
                    return this.spreadCurve;
                }
                case -450004177: {
                    return this.metadata;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1842240354: {
                    this.baseCurve = (Curve)newValue;
                    break;
                }
                case 2130054972: {
                    this.spreadCurve = (Curve)newValue;
                    break;
                }
                case -450004177: {
                    this.metadata = (CurveMetadata)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CombinedCurve build() {
            return new CombinedCurve(this.baseCurve, this.spreadCurve, this.metadata);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("CombinedCurve.Builder{");
            buf.append("baseCurve").append('=').append(JodaBeanUtils.toString((Object)this.baseCurve)).append(',').append(' ');
            buf.append("spreadCurve").append('=').append(JodaBeanUtils.toString((Object)this.spreadCurve)).append(',').append(' ');
            buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Curve> baseCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"baseCurve", CombinedCurve.class, Curve.class);
        private final MetaProperty<Curve> spreadCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spreadCurve", CombinedCurve.class, Curve.class);
        private final MetaProperty<CurveMetadata> metadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"metadata", CombinedCurve.class, CurveMetadata.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"baseCurve", "spreadCurve", "metadata"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1842240354: {
                    return this.baseCurve;
                }
                case 2130054972: {
                    return this.spreadCurve;
                }
                case -450004177: {
                    return this.metadata;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CombinedCurve> builder() {
            return new Builder();
        }

        public Class<? extends CombinedCurve> beanType() {
            return CombinedCurve.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Curve> baseCurve() {
            return this.baseCurve;
        }

        public MetaProperty<Curve> spreadCurve() {
            return this.spreadCurve;
        }

        public MetaProperty<CurveMetadata> metadata() {
            return this.metadata;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1842240354: {
                    return ((CombinedCurve)bean).getBaseCurve();
                }
                case 2130054972: {
                    return ((CombinedCurve)bean).getSpreadCurve();
                }
                case -450004177: {
                    return ((CombinedCurve)bean).getMetadata();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

