/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.amount;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.market.amount.LegAmount;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class LegAmounts
implements FxConvertible<LegAmounts>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<LegAmount> amounts;
    private static final long serialVersionUID = 1L;

    public static LegAmounts of(List<LegAmount> amounts) {
        return new LegAmounts(amounts);
    }

    public static LegAmounts of(LegAmount ... amounts) {
        return new LegAmounts((List<LegAmount>)ImmutableList.copyOf((Object[])amounts));
    }

    public LegAmounts convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        List convertedAmounts = (List)this.amounts.stream().map(amount -> (LegAmount)amount.convertedTo(resultCurrency, rateProvider)).collect(Guavate.toImmutableList());
        return LegAmounts.of(convertedAmounts);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private LegAmounts(List<LegAmount> amounts) {
        JodaBeanUtils.notNull(amounts, (String)"amounts");
        this.amounts = ImmutableList.copyOf(amounts);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<LegAmount> getAmounts() {
        return this.amounts;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            LegAmounts other = (LegAmounts)obj;
            return JodaBeanUtils.equal(this.amounts, other.amounts);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.amounts);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("LegAmounts{");
        buf.append("amounts").append('=').append(JodaBeanUtils.toString(this.amounts));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<LegAmounts> {
        private List<LegAmount> amounts = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    this.amounts = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public LegAmounts build() {
            return new LegAmounts(this.amounts);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("LegAmounts.Builder{");
            buf.append("amounts").append('=').append(JodaBeanUtils.toString(this.amounts));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<LegAmount>> amounts = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"amounts", LegAmounts.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"amounts"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends LegAmounts> builder() {
            return new Builder();
        }

        public Class<? extends LegAmounts> beanType() {
            return LegAmounts.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<LegAmount>> amounts() {
            return this.amounts;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return ((LegAmounts)bean).getAmounts();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

