/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.amount;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.market.amount.CashFlow;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CashFlows
implements FxConvertible<CashFlows>,
ImmutableBean,
Serializable {
    public static final CashFlows NONE = new CashFlows((List<CashFlow>)ImmutableList.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<CashFlow> cashFlows;
    private static final long serialVersionUID = 1L;

    public static CashFlows of(CashFlow cashFlow) {
        return CashFlows.of((List<CashFlow>)ImmutableList.of((Object)cashFlow));
    }

    public static CashFlows of(List<CashFlow> cashFlows) {
        return new CashFlows(cashFlows);
    }

    public CashFlow getCashFlow(int index) {
        return (CashFlow)this.cashFlows.get(index);
    }

    public CashFlows combinedWith(CashFlow cashFlow) {
        return new CashFlows((List<CashFlow>)ImmutableList.builder().addAll(this.cashFlows).add((Object)cashFlow).build());
    }

    public CashFlows combinedWith(CashFlows other) {
        return new CashFlows((List<CashFlow>)ImmutableList.builder().addAll(this.cashFlows).addAll(other.cashFlows).build());
    }

    public CashFlows sorted() {
        if (Ordering.natural().isOrdered(this.cashFlows)) {
            return this;
        }
        return new CashFlows((List<CashFlow>)Ordering.natural().immutableSortedCopy(this.cashFlows));
    }

    public CashFlows convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return CashFlows.of((List)this.cashFlows.stream().map(cf -> cf.convertedTo(resultCurrency, rateProvider)).collect(Guavate.toImmutableList()));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CashFlows(List<CashFlow> cashFlows) {
        JodaBeanUtils.notNull(cashFlows, (String)"cashFlows");
        this.cashFlows = ImmutableList.copyOf(cashFlows);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<CashFlow> getCashFlows() {
        return this.cashFlows;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CashFlows other = (CashFlows)obj;
            return JodaBeanUtils.equal(this.cashFlows, other.cashFlows);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.cashFlows);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("CashFlows{");
        buf.append("cashFlows").append('=').append(JodaBeanUtils.toString(this.cashFlows));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CashFlows> {
        private List<CashFlow> cashFlows = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 733659538: {
                    return this.cashFlows;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 733659538: {
                    this.cashFlows = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CashFlows build() {
            return new CashFlows(this.cashFlows);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("CashFlows.Builder{");
            buf.append("cashFlows").append('=').append(JodaBeanUtils.toString(this.cashFlows));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<CashFlow>> cashFlows = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"cashFlows", CashFlows.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"cashFlows"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 733659538: {
                    return this.cashFlows;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CashFlows> builder() {
            return new Builder();
        }

        public Class<? extends CashFlows> beanType() {
            return CashFlows.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<CashFlow>> cashFlows() {
            return this.cashFlows;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 733659538: {
                    return ((CashFlows)bean).getCashFlows();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

