/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.amount;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CashFlow
implements FxConvertible<CashFlow>,
Comparable<CashFlow>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate paymentDate;
    @PropertyDefinition(validate="notNull")
    private final CurrencyAmount presentValue;
    @PropertyDefinition(validate="notNull")
    private final CurrencyAmount forecastValue;
    @PropertyDefinition
    private final double discountFactor;
    private static final long serialVersionUID = 1L;

    public static CashFlow ofPresentValue(LocalDate paymentDate, CurrencyAmount presentValue, double discountFactor) {
        return new CashFlow(paymentDate, presentValue, presentValue.multipliedBy(1.0 / discountFactor), discountFactor);
    }

    public static CashFlow ofPresentValue(LocalDate paymentDate, Currency currency, double presentValue, double discountFactor) {
        return CashFlow.ofPresentValue(paymentDate, CurrencyAmount.of((Currency)currency, (double)presentValue), discountFactor);
    }

    public static CashFlow ofForecastValue(LocalDate paymentDate, CurrencyAmount forecastValue, double discountFactor) {
        return new CashFlow(paymentDate, forecastValue.multipliedBy(discountFactor), forecastValue, discountFactor);
    }

    public static CashFlow ofForecastValue(LocalDate paymentDate, Currency currency, double forecastValue, double discountFactor) {
        return CashFlow.ofForecastValue(paymentDate, CurrencyAmount.of((Currency)currency, (double)forecastValue), discountFactor);
    }

    public CashFlow convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.presentValue.getCurrency().equals((Object)resultCurrency) && this.forecastValue.getCurrency().equals((Object)resultCurrency)) {
            return this;
        }
        CurrencyAmount pv = this.presentValue.convertedTo(resultCurrency, rateProvider);
        CurrencyAmount fv = this.forecastValue.convertedTo(resultCurrency, rateProvider);
        return new CashFlow(this.paymentDate, pv, fv, this.discountFactor);
    }

    @Override
    public int compareTo(CashFlow other) {
        return ComparisonChain.start().compare((Comparable)this.paymentDate, (Comparable)other.paymentDate).compare((Comparable)this.presentValue, (Comparable)other.presentValue).compare((Comparable)this.forecastValue, (Comparable)other.forecastValue).compare(this.discountFactor, other.discountFactor).result();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CashFlow(LocalDate paymentDate, CurrencyAmount presentValue, CurrencyAmount forecastValue, double discountFactor) {
        JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
        JodaBeanUtils.notNull((Object)presentValue, (String)"presentValue");
        JodaBeanUtils.notNull((Object)forecastValue, (String)"forecastValue");
        this.paymentDate = paymentDate;
        this.presentValue = presentValue;
        this.forecastValue = forecastValue;
        this.discountFactor = discountFactor;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public CurrencyAmount getPresentValue() {
        return this.presentValue;
    }

    public CurrencyAmount getForecastValue() {
        return this.forecastValue;
    }

    public double getDiscountFactor() {
        return this.discountFactor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CashFlow other = (CashFlow)obj;
            return JodaBeanUtils.equal((Object)this.paymentDate, (Object)other.paymentDate) && JodaBeanUtils.equal((Object)this.presentValue, (Object)other.presentValue) && JodaBeanUtils.equal((Object)this.forecastValue, (Object)other.forecastValue) && JodaBeanUtils.equal((double)this.discountFactor, (double)other.discountFactor);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.presentValue);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.forecastValue);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.discountFactor);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("CashFlow{");
        buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
        buf.append("presentValue").append('=').append(JodaBeanUtils.toString((Object)this.presentValue)).append(',').append(' ');
        buf.append("forecastValue").append('=').append(JodaBeanUtils.toString((Object)this.forecastValue)).append(',').append(' ');
        buf.append("discountFactor").append('=').append(JodaBeanUtils.toString((Object)this.discountFactor));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CashFlow> {
        private LocalDate paymentDate;
        private CurrencyAmount presentValue;
        private CurrencyAmount forecastValue;
        private double discountFactor;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1540873516: {
                    return this.paymentDate;
                }
                case 686253430: {
                    return this.presentValue;
                }
                case 1310579766: {
                    return this.forecastValue;
                }
                case -557144592: {
                    return this.discountFactor;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1540873516: {
                    this.paymentDate = (LocalDate)newValue;
                    break;
                }
                case 686253430: {
                    this.presentValue = (CurrencyAmount)newValue;
                    break;
                }
                case 1310579766: {
                    this.forecastValue = (CurrencyAmount)newValue;
                    break;
                }
                case -557144592: {
                    this.discountFactor = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CashFlow build() {
            return new CashFlow(this.paymentDate, this.presentValue, this.forecastValue, this.discountFactor);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("CashFlow.Builder{");
            buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
            buf.append("presentValue").append('=').append(JodaBeanUtils.toString((Object)this.presentValue)).append(',').append(' ');
            buf.append("forecastValue").append('=').append(JodaBeanUtils.toString((Object)this.forecastValue)).append(',').append(' ');
            buf.append("discountFactor").append('=').append(JodaBeanUtils.toString((Object)this.discountFactor));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> paymentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDate", CashFlow.class, LocalDate.class);
        private final MetaProperty<CurrencyAmount> presentValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"presentValue", CashFlow.class, CurrencyAmount.class);
        private final MetaProperty<CurrencyAmount> forecastValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"forecastValue", CashFlow.class, CurrencyAmount.class);
        private final MetaProperty<Double> discountFactor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountFactor", CashFlow.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"paymentDate", "presentValue", "forecastValue", "discountFactor"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1540873516: {
                    return this.paymentDate;
                }
                case 686253430: {
                    return this.presentValue;
                }
                case 1310579766: {
                    return this.forecastValue;
                }
                case -557144592: {
                    return this.discountFactor;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CashFlow> builder() {
            return new Builder();
        }

        public Class<? extends CashFlow> beanType() {
            return CashFlow.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> paymentDate() {
            return this.paymentDate;
        }

        public MetaProperty<CurrencyAmount> presentValue() {
            return this.presentValue;
        }

        public MetaProperty<CurrencyAmount> forecastValue() {
            return this.forecastValue;
        }

        public MetaProperty<Double> discountFactor() {
            return this.discountFactor;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1540873516: {
                    return ((CashFlow)bean).getPaymentDate();
                }
                case 686253430: {
                    return ((CashFlow)bean).getPresentValue();
                }
                case 1310579766: {
                    return ((CashFlow)bean).getForecastValue();
                }
                case -557144592: {
                    return ((CashFlow)bean).getDiscountFactor();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

