/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market;

import com.google.common.base.CharMatcher;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.TypedString;
import org.joda.convert.FromString;

public final class ValueType
extends TypedString<ValueType> {
    private static final long serialVersionUID = 1L;
    private static final CharMatcher NAME_MATCHER = CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.is((char)'-')).precomputed();
    public static final ValueType UNKNOWN = ValueType.of("Unknown");
    public static final ValueType YEAR_FRACTION = ValueType.of("YearFraction");
    public static final ValueType MONTHS = ValueType.of("Months");
    public static final ValueType ZERO_RATE = ValueType.of("ZeroRate");
    public static final ValueType FORWARD_RATE = ValueType.of("ForwardRate");
    public static final ValueType DISCOUNT_FACTOR = ValueType.of("DiscountFactor");
    public static final ValueType DIVIDEND_YIELD = ValueType.of("DividendYield");
    public static final ValueType PRICE_INDEX = ValueType.of("PriceIndex");
    public static final ValueType RECOVERY_RATE = ValueType.of("RecoveryRate");
    public static final ValueType BLACK_VOLATILITY = ValueType.of("BlackVolatility");
    public static final ValueType NORMAL_VOLATILITY = ValueType.of("NormalVolatility");
    public static final ValueType LOCAL_VOLATILITY = ValueType.of("LocalVolatility");
    public static final ValueType PRICE = ValueType.of("Price");
    public static final ValueType STRIKE = ValueType.of("Strike");
    public static final ValueType SIMPLE_MONEYNESS = ValueType.of("SimpleMoneyness");
    public static final ValueType LOG_MONEYNESS = ValueType.of("LogMoneyness");
    public static final ValueType SABR_ALPHA = ValueType.of("SabrAlpha");
    public static final ValueType SABR_BETA = ValueType.of("SabrBeta");
    public static final ValueType SABR_RHO = ValueType.of("SabrRho");
    public static final ValueType SABR_NU = ValueType.of("SabrNu");
    public static final ValueType SABR_SHIFT = ValueType.of("SabrShift");
    public static final ValueType RISK_REVERSAL = ValueType.of("RiskReversal");
    public static final ValueType STRANGLE = ValueType.of("Strangle");
    public static final ValueType CORRELATION = ValueType.of("CORRELATION");

    @FromString
    public static ValueType of(String name) {
        return new ValueType(name);
    }

    private ValueType(String name) {
        super(name, NAME_MATCHER, "Value type must only contain the characters A-Z, a-z, 0-9 and -");
    }

    public void checkEquals(ValueType other, String exceptionPrefix) {
        if (!this.equals((Object)other)) {
            throw new IllegalArgumentException(Messages.format((String)"{}, expected {} but was {}", (Object[])new Object[]{exceptionPrefix, other, this}));
        }
    }
}

