/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.AuthoritiesProvider;
import com.okta.spring.boot.oauth.AuthorityProvidersConfig;
import com.okta.spring.boot.oauth.ConditionalOnOktaClientProperties;
import com.okta.spring.boot.oauth.Okta;
import com.okta.spring.boot.oauth.OktaOAuth2UserService;
import com.okta.spring.boot.oauth.OktaOidcUserService;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.ConditionalOnDefaultWebSecurity;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.SecurityFilterChain;

@AutoConfiguration
@ConditionalOnOktaClientProperties
@EnableConfigurationProperties(value={OktaOAuth2Properties.class})
@ConditionalOnClass(value={EnableWebSecurity.class, ClientRegistration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Import(value={AuthorityProvidersConfig.class})
class OktaOAuth2AutoConfig {
    OktaOAuth2AutoConfig() {
    }

    @Bean
    @ConditionalOnProperty(name={"okta.oauth2.post-logout-redirect-uri"})
    OidcClientInitiatedLogoutSuccessHandler oidcLogoutSuccessHandler(OktaOAuth2Properties oktaOAuth2Properties, ClientRegistrationRepository clientRegistrationRepository) {
        OidcClientInitiatedLogoutSuccessHandler successHandler = new OidcClientInitiatedLogoutSuccessHandler(clientRegistrationRepository);
        String logoutUri = oktaOAuth2Properties.getPostLogoutRedirectUri();
        successHandler.setPostLogoutRedirectUri((logoutUri.startsWith("/") ? "{baseUrl}" : "") + logoutUri);
        return successHandler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"oAuth2UserService"})
    OAuth2UserService<OAuth2UserRequest, OAuth2User> oAuth2UserService(Collection<AuthoritiesProvider> authoritiesProviders) {
        return new OktaOAuth2UserService(authoritiesProviders);
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcUserService"})
    OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService(@Qualifier(value="oAuth2UserService") OAuth2UserService<OAuth2UserRequest, OAuth2User> oAuth2UserService, Collection<AuthoritiesProvider> authoritiesProviders) {
        return new OktaOidcUserService(oAuth2UserService, authoritiesProviders);
    }

    @Configuration
    @ConditionalOnDefaultWebSecurity
    static class OAuth2SecurityFilterChainConfiguration {
        OAuth2SecurityFilterChainConfiguration() {
        }

        @Bean
        SecurityFilterChain oauth2SecurityFilterChain(HttpSecurity http, ClientRegistrationRepository clientRegistrationRepository) throws Exception {
            http.authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated());
            Okta.configureOAuth2WithPkce(http, clientRegistrationRepository);
            http.oauth2Client();
            http.oauth2ResourceServer(OAuth2ResourceServerConfigurer::jwt);
            return (SecurityFilterChain)http.build();
        }
    }
}

