/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.application;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.application.DefaultApplicationGroupAssignment;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.AppUserList;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationAccessibility;
import com.okta.sdk.resource.application.ApplicationCredentials;
import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import com.okta.sdk.resource.application.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.application.ApplicationLicensing;
import com.okta.sdk.resource.application.ApplicationSettings;
import com.okta.sdk.resource.application.ApplicationSignOnMode;
import com.okta.sdk.resource.application.ApplicationVisibility;
import com.okta.sdk.resource.application.Csr;
import com.okta.sdk.resource.application.CsrList;
import com.okta.sdk.resource.application.CsrMetadata;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrant;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrantList;
import com.okta.sdk.resource.application.OAuth2Token;
import com.okta.sdk.resource.application.OAuth2TokenList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultApplication
extends AbstractInstanceResource<Application>
implements Application {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final ResourceReference<ApplicationAccessibility> accessibilityProperty = new ResourceReference<ApplicationAccessibility>("accessibility", ApplicationAccessibility.class, false);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final ResourceReference<ApplicationCredentials> credentialsProperty = new ResourceReference<ApplicationCredentials>("credentials", ApplicationCredentials.class, false);
    private static final ListProperty featuresProperty = new ListProperty("features");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final StringProperty labelProperty = new StringProperty("label");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final ResourceReference<ApplicationLicensing> licensingProperty = new ResourceReference<ApplicationLicensing>("licensing", ApplicationLicensing.class, false);
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final MapProperty profileProperty = new MapProperty("profile");
    private static final ResourceReference<ApplicationSettings> settingsProperty = new ResourceReference<ApplicationSettings>("settings", ApplicationSettings.class, false);
    private static final EnumProperty<ApplicationSignOnMode> signOnModeProperty = new EnumProperty<ApplicationSignOnMode>("signOnMode", ApplicationSignOnMode.class);
    private static final EnumProperty<Application.StatusEnum> statusProperty = new EnumProperty<Application.StatusEnum>("status", Application.StatusEnum.class);
    private static final ResourceReference<ApplicationVisibility> visibilityProperty = new ResourceReference<ApplicationVisibility>("visibility", ApplicationVisibility.class, false);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultApplication.createPropertyDescriptorMap(embeddedProperty, linksProperty, accessibilityProperty, createdProperty, credentialsProperty, featuresProperty, idProperty, labelProperty, lastUpdatedProperty, licensingProperty, nameProperty, profileProperty, settingsProperty, signOnModeProperty, statusProperty, visibilityProperty);

    public DefaultApplication(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultApplication(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Application.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public ApplicationAccessibility getAccessibility() {
        return this.getResourceProperty(accessibilityProperty);
    }

    public Application setAccessibility(ApplicationAccessibility accessibility) {
        this.setProperty(accessibilityProperty, (Object)accessibility);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public ApplicationCredentials getCredentials() {
        return this.getResourceProperty(credentialsProperty);
    }

    public Application setCredentials(ApplicationCredentials credentials) {
        this.setProperty(credentialsProperty, (Object)credentials);
        return this;
    }

    public List<String> getFeatures() {
        return this.getListProperty(featuresProperty);
    }

    public Application setFeatures(List<String> features) {
        this.setProperty(featuresProperty, features);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public String getLabel() {
        return this.getString(labelProperty);
    }

    public Application setLabel(String label) {
        this.setProperty(labelProperty, (Object)label);
        return this;
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public ApplicationLicensing getLicensing() {
        return this.getResourceProperty(licensingProperty);
    }

    public Application setLicensing(ApplicationLicensing licensing) {
        this.setProperty(licensingProperty, (Object)licensing);
        return this;
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public Map<String, Object> getProfile() {
        return this.getMap(profileProperty);
    }

    public Application setProfile(Map<String, Object> profile) {
        this.setProperty(profileProperty, profile);
        return this;
    }

    public ApplicationSettings getSettings() {
        return this.getResourceProperty(settingsProperty);
    }

    public Application setSettings(ApplicationSettings settings) {
        this.setProperty(settingsProperty, (Object)settings);
        return this;
    }

    public ApplicationSignOnMode getSignOnMode() {
        return this.getEnumProperty(signOnModeProperty);
    }

    public Application setSignOnMode(ApplicationSignOnMode signOnMode) {
        this.setProperty(signOnModeProperty, (Object)signOnMode);
        return this;
    }

    public Application.StatusEnum getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public ApplicationVisibility getVisibility() {
        return this.getResourceProperty(visibilityProperty);
    }

    public Application setVisibility(ApplicationVisibility visibility) {
        this.setProperty(visibilityProperty, (Object)visibility);
        return this;
    }

    public void revokeCsr(String csrId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Csr getCsr(String csrId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "", Csr.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUser getApplicationUser(String userId, String expand) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/users/" + userId + "", AppUser.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUser getApplicationUser(String userId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/users/" + userId + "", AppUser.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey cloneApplicationKey(String keyId, String targetAid) {
        String appId = this.getId();
        Assert.notNull((Object)targetAid, (String)"'targetAid' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (targetAid != null) {
            queryArgs.put("targetAid", targetAid);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "/clone", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Csr generateCsr(CsrMetadata metadata) {
        String appId = this.getId();
        Assert.notNull((Object)metadata, (String)"'metadata' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/csrs", metadata, this, Csr.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationGroupAssignmentList listGroupAssignments(String q, String expand) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/groups", ApplicationGroupAssignmentList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationGroupAssignmentList listGroupAssignments() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/groups", ApplicationGroupAssignmentList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrantList listScopeConsentGrants(String expand) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrantList listScopeConsentGrants() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeOAuth2TokenForApplication(String tokenId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/tokens/" + tokenId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey publishBinaryCerCert(String csrId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeOAuth2Tokens() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/tokens", queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeScopeConsentGrant(String grantId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/grants/" + grantId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUser assignUserToApplication(AppUser appUser) {
        String appId = this.getId();
        Assert.notNull((Object)appUser, (String)"'appUser' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/users", appUser, this, AppUser.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return appUser;
    }

    public OAuth2ScopeConsentGrant grantConsentToScope(OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) {
        String appId = this.getId();
        Assert.notNull((Object)oAuth2ScopeConsentGrant, (String)"'oAuth2ScopeConsentGrant' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/grants", oAuth2ScopeConsentGrant, this, OAuth2ScopeConsentGrant.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2ScopeConsentGrant;
    }

    @Override
    public void delete() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey publishDerCert(String csrId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void activate() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationGroupAssignment createApplicationGroupAssignment(String groupId, ApplicationGroupAssignment applicationGroupAssignment) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/apps/" + appId + "/groups/" + groupId + "";
        this.getDataStore().save(href, applicationGroupAssignment, this, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return applicationGroupAssignment;
    }

    public ApplicationGroupAssignment createApplicationGroupAssignment(String groupId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/apps/" + appId + "/groups/" + groupId + "";
        DefaultApplicationGroupAssignment applicationGroupAssignment = new DefaultApplicationGroupAssignment(this.getDataStore());
        this.getDataStore().save(href, applicationGroupAssignment, this, queryArgs, (Map<String, List<String>>)headers);
        return applicationGroupAssignment;
    }

    public ApplicationGroupAssignment getApplicationGroupAssignment(String groupId, String expand) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/groups/" + groupId + "", ApplicationGroupAssignment.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationGroupAssignment getApplicationGroupAssignment(String groupId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/groups/" + groupId + "", ApplicationGroupAssignment.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey generateKey(Integer validityYears) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (validityYears != null) {
            queryArgs.put("validityYears", validityYears);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/keys/generate", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey generateKey() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/keys/generate", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2TokenList listOAuth2Tokens(String expand) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/tokens", OAuth2TokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2TokenList listOAuth2Tokens() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/tokens", OAuth2TokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrant getScopeConsentGrant(String grantId, String expand) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/grants/" + grantId + "", OAuth2ScopeConsentGrant.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrant getScopeConsentGrant(String grantId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/grants/" + grantId + "", OAuth2ScopeConsentGrant.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivate() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey publishBinaryPemCert(String csrId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Application update() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/apps/" + appId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public JsonWebKeyList listKeys() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/credentials/keys", JsonWebKeyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Token getOAuth2Token(String tokenId, String expand) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/tokens/" + tokenId + "", OAuth2Token.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Token getOAuth2Token(String tokenId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/tokens/" + tokenId + "", OAuth2Token.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public CsrList listCsrs() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/credentials/csrs", CsrList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUserList listApplicationUsers(String q, String queryScope, String filter, String expand) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (queryScope != null) {
            queryArgs.put("query_scope", queryScope);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/users", AppUserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUserList listApplicationUsers() {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/users", AppUserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey getApplicationKey(String keyId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "", JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey publishCerCert(String csrId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey publishBinaryDerCert(String csrId) {
        String appId = this.getId();
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

