/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.oauth2;

import com.okta.commons.lang.Assert;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.impl.oauth2.AccessTokenRetrieverService;
import com.okta.sdk.impl.oauth2.OAuth2AccessToken;
import com.okta.sdk.impl.oauth2.OAuth2TokenRetrieverException;
import java.io.IOException;
import java.security.InvalidKeyException;

public class OAuth2ClientCredentials
implements ClientCredentials<OAuth2AccessToken> {
    private OAuth2AccessToken oAuth2AccessToken;
    private AccessTokenRetrieverService accessTokenRetrieverService;

    public OAuth2ClientCredentials(AccessTokenRetrieverService accessTokenRetrieverService) {
        Assert.notNull((Object)accessTokenRetrieverService, (String)"accessTokenRetrieverService must not be null.");
        this.accessTokenRetrieverService = accessTokenRetrieverService;
        this.oAuth2AccessToken = this.eagerFetchOAuth2AccessToken();
    }

    private OAuth2AccessToken eagerFetchOAuth2AccessToken() {
        OAuth2AccessToken accessToken;
        try {
            accessToken = this.accessTokenRetrieverService.getOAuth2AccessToken();
        }
        catch (IOException | InvalidKeyException e) {
            throw new OAuth2TokenRetrieverException("Failed to fetch OAuth2 access token eagerly", e);
        }
        if (accessToken == null) {
            throw new OAuth2TokenRetrieverException("Failed to fetch OAuth2 access token eagerly");
        }
        return accessToken;
    }

    public OAuth2AccessToken getCredentials() {
        return this.oAuth2AccessToken;
    }

    public void setCredentials(OAuth2AccessToken oAuth2AccessToken) {
        this.oAuth2AccessToken = oAuth2AccessToken;
    }

    public AccessTokenRetrieverService getAccessTokenRetrieverService() {
        return this.accessTokenRetrieverService;
    }

    public String toString() {
        return "<OAuth2ClientCredentials>";
    }
}

