/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.bootstrap.Bootstrap;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.client.ClientChannelFactory;
import io.reactivex.netty.client.ClientConnectionFactory;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.ConnectionPoolBuilder;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.http.client.CompositeHttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientImpl;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.Subscription;

public class CompositeHttpClient<I, O>
extends HttpClientImpl<I, O> {
    private final ConcurrentHashMap<RxClient.ServerInfo, HttpClient<I, O>> httpClients = new ConcurrentHashMap();
    private final PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator;
    private final ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder;

    public CompositeHttpClient(String name, RxClient.ServerInfo defaultServer, Bootstrap clientBootstrap, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, RxClient.ClientConfig clientConfig, ClientChannelFactory<HttpClientResponse<O>, HttpClientRequest<I>> channelFactory, ClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>, ? extends ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionFactory, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(name, defaultServer, clientBootstrap, pipelineConfigurator, clientConfig, channelFactory, connectionFactory, eventsSubject);
        this.pipelineConfigurator = pipelineConfigurator;
        this.poolBuilder = null;
        this.httpClients.put(defaultServer, this);
    }

    CompositeHttpClient(String name, RxClient.ServerInfo defaultServer, Bootstrap clientBootstrap, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, RxClient.ClientConfig clientConfig, ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(name, defaultServer, clientBootstrap, pipelineConfigurator, clientConfig, poolBuilder, eventsSubject);
        this.pipelineConfigurator = pipelineConfigurator;
        this.poolBuilder = poolBuilder;
        this.httpClients.put(defaultServer, this);
    }

    public Observable<HttpClientResponse<O>> submit(RxClient.ServerInfo serverInfo, HttpClientRequest<I> request) {
        HttpClient<I, O> client = this.getClient(serverInfo);
        return client.submit(request);
    }

    public Observable<HttpClientResponse<O>> submit(RxClient.ServerInfo serverInfo, HttpClientRequest<I> request, HttpClient.HttpClientConfig config) {
        HttpClient<I, O> client = this.getClient(serverInfo);
        return client.submit(request, config);
    }

    private HttpClient<I, O> getClient(RxClient.ServerInfo serverInfo) {
        HttpClient<I, O> existing;
        HttpClient<I, O> client = this.httpClients.get(serverInfo);
        if (null == client && null != (existing = this.httpClients.putIfAbsent(serverInfo, client = this.newClient(serverInfo)))) {
            client.shutdown();
            client = existing;
        }
        return client;
    }

    @Override
    public void shutdown() {
        for (HttpClient<I, O> client : this.httpClients.values()) {
            client.shutdown();
        }
    }

    public Subscription subscribe(RxClient.ServerInfo server, MetricEventsListener<? extends ClientMetricsEvent<?>> listener) {
        HttpClient<I, O> client = this.httpClients.get(server);
        if (null == client) {
            throw new IllegalArgumentException("Invalid server: " + server.getHost() + ':' + server.getPort());
        }
        return client.subscribe(listener);
    }

    public RxClient.ServerInfo getDefaultServer() {
        return this.serverInfo;
    }

    private HttpClientImpl<I, O> newClient(RxClient.ServerInfo serverInfo) {
        if (null != this.poolBuilder) {
            return new HttpClientImpl<I, O>(this.name, serverInfo, this.clientBootstrap.clone(), this.pipelineConfigurator, this.clientConfig, this.clonePoolBuilder(serverInfo, this.poolBuilder), (MetricEventsSubject<ClientMetricsEvent<?>>)this.eventsSubject);
        }
        return new HttpClientImpl<I, O>(this.name, serverInfo, this.clientBootstrap.clone(), this.pipelineConfigurator, this.clientConfig, this.channelFactory, this.connectionFactory, (MetricEventsSubject<ClientMetricsEvent<?>>)this.eventsSubject);
    }

    private ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> clonePoolBuilder(RxClient.ServerInfo serverInfo, ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder) {
        ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> toReturn = poolBuilder.copy(serverInfo);
        toReturn.withConnectionPoolLimitStrategy(((CompositeHttpClientBuilder.CloneablePoolLimitDeterminationStrategy)poolBuilder.getLimitDeterminationStrategy()).copy());
        return toReturn;
    }
}

